/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.ItemPanels;
import codechicken.nei.Label;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.Widget;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ItemPanel
extends Widget {
    public static ArrayList<ItemStack> items = new ArrayList();
    public ArrayList<ItemStack> realItems = new ArrayList();
    protected ArrayList<ItemStack> _items = this.realItems;
    public ItemStack draggedStack;
    public int mouseDownSlot = -1;
    public Button prev;
    public Button next;
    public Label pageLabel;
    private int marginLeft;
    private int marginTop;
    private int rows;
    private int columns;
    private boolean[] validSlotMap;
    private int firstIndex;
    private int itemsPerPage;
    private int page;
    private int numPages;

    public ArrayList<ItemStack> getItems() {
        return this.realItems;
    }

    public static void updateItemList(ArrayList<ItemStack> newItems) {
        ItemPanels.itemPanel._items = newItems;
    }

    public void init() {
        this.pageLabel = new Label("(0/0)", true);
        this.prev = new Button("Prev"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    ItemPanel.this.scroll(-1);
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return "<";
            }
        };
        this.next = new Button("Next"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    ItemPanel.this.scroll(1);
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return ">";
            }
        };
    }

    public int getX(GuiContainer gui) {
        return (gui.field_146999_f + gui.field_146294_l) / 2 + 3;
    }

    public int getMarginLeft() {
        return this.x + this.w % 18 / 2;
    }

    public int getMarginTop() {
        return this.y + this.h % 18 / 2;
    }

    public int getButtonTop() {
        return 2;
    }

    public int getNextX(GuiContainer gui) {
        return gui.field_146294_l - this.prev.w - 2;
    }

    public int getPrevX(GuiContainer gui) {
        return (gui.field_146999_f + gui.field_146294_l) / 2 + 2;
    }

    public int getPageX(GuiContainer gui) {
        return gui.field_147003_i * 3 / 2 + gui.field_146999_f + 1;
    }

    public int getHeight(GuiContainer gui) {
        return gui.field_146295_m - 15 - this.y + this.getHightAdjustment();
    }

    public int getHightAdjustment() {
        int hAdj = 0;
        if (!NEIClientConfig.canPerformAction("item")) {
            hAdj += 15;
        }
        return hAdj;
    }

    public int getWidth(GuiContainer gui) {
        return LayoutManager.getSideWidth(gui) - this.x;
    }

    public String getLabelText() {
        this.pageLabel.text = "(" + this.getPage() + "/" + this.getNumPages() + ")";
        return this.pageLabel.text;
    }

    protected void setItems() {
        this.realItems = this._items;
        ItemPanels.itemPanel._items = this._items;
    }

    public void resize(GuiContainer gui) {
        this.setItems();
        int buttonHeight = 16;
        int buttonWidth = 16;
        this.prev.x = this.getPrevX(gui);
        this.prev.y = this.getButtonTop();
        this.prev.h = 16;
        this.prev.w = 16;
        this.next.x = this.getNextX(gui);
        this.next.y = this.getButtonTop();
        this.next.h = 16;
        this.next.w = 16;
        this.pageLabel.x = this.getPageX(gui);
        this.pageLabel.y = this.prev.y + 5;
        this.pageLabel.text = this.getLabelText();
        this.y = this.prev.h + this.prev.y;
        this.x = this.getX(gui);
        this.w = this.getWidth(gui);
        this.h = this.getHeight(gui);
        this.marginLeft = this.getMarginLeft();
        this.marginTop = this.getMarginTop();
        this.columns = this.w / 18;
        this.rows = this.h / 18;
        if (this.rows < 0) {
            this.rows = 0;
        }
        if (this.columns < 0) {
            this.columns = 0;
        }
        this.calculatePage();
        this.updateValidSlots();
    }

    private void calculatePage() {
        this.numPages = this.itemsPerPage == 0 ? 0 : (int)Math.ceil((float)this.realItems.size() / (float)this.itemsPerPage);
        if (this.firstIndex >= this.realItems.size()) {
            this.firstIndex = 0;
        }
        this.page = this.numPages == 0 ? 0 : this.firstIndex / this.itemsPerPage + 1;
    }

    public void setVisible() {
        LayoutManager.addWidget(this.prev);
        LayoutManager.addWidget(this.next);
        LayoutManager.addWidget(this.pageLabel);
    }

    private void updateValidSlots() {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        this.validSlotMap = new boolean[this.rows * this.columns];
        this.itemsPerPage = 0;
        for (int i = 0; i < this.validSlotMap.length; ++i) {
            if (!this.slotValid(gui, i)) continue;
            this.validSlotMap[i] = true;
            ++this.itemsPerPage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean slotValid(GuiContainer gui, int i) {
        Rectangle4i rect = this.getSlotRect(i);
        try {
            GuiInfo.readLock.lock();
            if (GuiInfo.guiHandlers.stream().anyMatch(handler -> handler.hideItemPanelSlot(gui, rect.x, rect.y, rect.w, rect.h))) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            GuiInfo.readLock.unlock();
        }
        return true;
    }

    public Rectangle4i getSlotRect(int i) {
        return this.getSlotRect(i / this.columns, i % this.columns);
    }

    public Rectangle4i getSlotRect(int row, int column) {
        return new Rectangle4i(this.marginLeft + column * 18, this.marginTop + row * 18, 18, 18);
    }

    @Override
    public void draw(int mousex, int mousey) {
        if (this.itemsPerPage == 0) {
            return;
        }
        GuiContainerManager.enableMatrixStackLogging();
        int index = this.firstIndex;
        for (int i = 0; i < this.rows * this.columns && index < this.realItems.size(); ++i) {
            if (!this.validSlotMap[i]) continue;
            Rectangle4i rect = this.getSlotRect(i);
            if (rect.contains(mousex, mousey)) {
                GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
            }
            GuiContainerManager.drawItem(rect.x + 1, rect.y + 1, this.realItems.get(index));
            ++index;
        }
        GuiContainerManager.disableMatrixStackLogging();
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        if (this.draggedStack != null) {
            GuiContainerManager.drawItems.field_77023_b += 100.0f;
            GuiContainerManager.drawItem(mousex - 8, mousey - 8, this.draggedStack);
            GuiContainerManager.drawItems.field_77023_b -= 100.0f;
        }
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        if (this.mouseDownSlot >= 0 && this.draggedStack == null && NEIClientUtils.getHeldItem() == null && NEIClientConfig.hasSMPCounterPart() && !GuiInfo.hasCustomSlots(NEIClientUtils.getGuiContainer())) {
            ItemPanelSlot mouseOverSlot = this.getSlotMouseOver(mousex, mousey);
            ItemStack stack = (ItemPanel)this.new ItemPanelSlot((int)this.mouseDownSlot).item;
            if (stack != null && (mouseOverSlot == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 500L)) {
                int amount = NEIClientConfig.getItemQuantity();
                if (amount == 0) {
                    amount = stack.func_77976_d();
                }
                this.draggedStack = NEIServerUtils.copyStack(stack, amount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.handleDraggedClick(mousex, mousey, button)) {
            return true;
        }
        if (NEIClientUtils.getHeldItem() != null) {
            try {
                GuiInfo.readLock.lock();
                if (GuiInfo.guiHandlers.stream().anyMatch(handler -> handler.hideItemPanelSlot(NEIClientUtils.getGuiContainer(), mousex, mousey, 1, 1))) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                GuiInfo.readLock.unlock();
            }
            if (NEIClientConfig.canPerformAction("delete") && NEIClientConfig.canPerformAction("item")) {
                if (button == 1) {
                    NEIClientUtils.decreaseSlotStack(-999);
                } else {
                    NEIClientUtils.deleteHeldItem();
                }
            } else {
                NEIClientUtils.dropHeldItem();
            }
            return true;
        }
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            if (button == 2) {
                ItemStack stack = hoverSlot.item;
                if (stack != null) {
                    int amount = NEIClientConfig.getItemQuantity();
                    if (amount == 0) {
                        amount = stack.func_77976_d();
                    }
                    this.draggedStack = NEIServerUtils.copyStack(stack, amount);
                }
            } else {
                this.mouseDownSlot = hoverSlot.slotIndex;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleDraggedClick(int mousex, int mousey, int button) {
        if (this.draggedStack == null) {
            return false;
        }
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        boolean handled = false;
        try {
            GuiInfo.readLock.lock();
            for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
                if (!handler.handleDragNDrop(gui, mousex, mousey, this.draggedStack, button)) continue;
                handled = true;
                if (this.draggedStack.field_77994_a != 0) continue;
                this.draggedStack = null;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            GuiInfo.readLock.unlock();
        }
        if (handled) {
            return true;
        }
        Slot overSlot = gui.func_146975_c(mousex, mousey);
        if (overSlot != null && overSlot.func_75214_a(this.draggedStack)) {
            if (NEIClientConfig.canCheatItem(this.draggedStack)) {
                int total;
                int add;
                int contents = overSlot.func_75216_d() ? overSlot.func_75211_c().field_77994_a : 0;
                int n = add = button == 0 ? this.draggedStack.field_77994_a : 1;
                if (overSlot.func_75216_d() && !NEIServerUtils.areStacksSameType(this.draggedStack, overSlot.func_75211_c())) {
                    contents = 0;
                }
                if ((total = Math.min(contents + add, Math.min(overSlot.func_75219_a(), this.draggedStack.func_77976_d()))) > contents) {
                    NEIClientUtils.setSlotContents(overSlot.field_75222_d, NEIServerUtils.copyStack(this.draggedStack, total), true);
                    NEICPH.sendGiveItem(NEIServerUtils.copyStack(this.draggedStack, total), false, false);
                    this.draggedStack.field_77994_a -= total - contents;
                }
                if (this.draggedStack.field_77994_a == 0) {
                    this.draggedStack = null;
                }
            } else {
                this.draggedStack = null;
            }
        } else if (mousex < gui.field_147003_i || mousey < gui.field_147009_r || mousex >= gui.field_147003_i + gui.field_146999_f || mousey >= gui.field_147009_r + gui.field_147000_g) {
            this.draggedStack = null;
        }
        return true;
    }

    @Override
    public boolean handleClickExt(int mousex, int mousey, int button) {
        return this.handleDraggedClick(mousex, mousey, button);
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && hoverSlot.slotIndex == this.mouseDownSlot && this.draggedStack == null) {
            ItemStack item = hoverSlot.item;
            if (NEIController.manager.window instanceof GuiRecipe || !NEIClientConfig.canCheatItem(item)) {
                if (button == 0) {
                    GuiCraftingRecipe.openRecipeGui("item", item);
                } else if (button == 1) {
                    GuiUsageRecipe.openRecipeGui("item", item);
                }
                this.draggedStack = null;
                this.mouseDownSlot = -1;
                return;
            }
            NEIClientUtils.cheatItem(item, button, -1);
        }
        this.mouseDownSlot = -1;
    }

    @Override
    public boolean onMouseWheel(int i, int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        this.scroll(-i);
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (keyID == NEIClientConfig.getKeyBinding("gui.next")) {
            this.scroll(1);
            return true;
        }
        if (keyID == NEIClientConfig.getKeyBinding("gui.prev")) {
            this.scroll(-1);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        ItemPanelSlot slot = this.getSlotMouseOver(mousex, mousey);
        return slot == null ? null : slot.item;
    }

    public ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        int index = this.firstIndex;
        for (int i = 0; i < this.rows * this.columns && index < this.realItems.size(); ++i) {
            if (!this.validSlotMap[i]) continue;
            if (this.getSlotRect(i).contains(mousex, mousey)) {
                return new ItemPanelSlot(index);
            }
            ++index;
        }
        return null;
    }

    public void scroll(int i) {
        if (this.itemsPerPage != 0) {
            int oldIndex = this.firstIndex;
            this.firstIndex += i * this.itemsPerPage;
            if (this.firstIndex >= this.realItems.size()) {
                this.firstIndex = 0;
            }
            if (this.firstIndex < 0) {
                this.firstIndex = oldIndex > 0 ? 0 : (this.realItems.size() - 1) / this.itemsPerPage * this.itemsPerPage;
            }
            this.calculatePage();
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getNumPages() {
        return this.numPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int px, int py) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        Rectangle4i rect = new Rectangle4i(px, py, 1, 1);
        try {
            GuiInfo.readLock.lock();
            if (GuiInfo.guiHandlers.stream().anyMatch(handler -> handler.hideItemPanelSlot(gui, rect.x, rect.y, rect.w, rect.h))) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            GuiInfo.readLock.unlock();
        }
        return super.contains(px, py);
    }

    public class ItemPanelSlot {
        public ItemStack item;
        public int slotIndex;

        public ItemPanelSlot(int index) {
            this.item = ItemPanel.this.realItems.get(index);
            this.slotIndex = index;
        }
    }
}

