/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemPanel;
import codechicken.nei.LayoutManager;
import codechicken.nei.LayoutStyleMinecraft;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.util.NBTJson;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;

public class BookmarkPanel
extends ItemPanel {
    @Override
    public void init() {
        super.init();
    }

    @Override
    protected void setItems() {
        this.realItems = this._items;
    }

    @Override
    public String getLabelText() {
        return super.getLabelText() + " [" + this.realItems.size() + "]";
    }

    public void addOrRemoveItem(ItemStack item) {
        ItemStack normalized = this.normalize(item);
        if (!this.remove(normalized)) {
            this._items.add(normalized);
        }
        this.saveBookmarks();
    }

    public static NBTTagCompound itemStackToNBT(ItemStack stack, NBTTagCompound nbTag) {
        String strId = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
        nbTag.func_74778_a("strId", strId);
        nbTag.func_74774_a("Count", (byte)stack.field_77994_a);
        nbTag.func_74777_a("Damage", (short)stack.func_77960_j());
        if (stack.field_77990_d != null) {
            nbTag.func_74782_a("tag", (NBTBase)stack.field_77990_d);
        }
        return nbTag;
    }

    public static ItemStack loadFromNBT(NBTTagCompound nbtTag) {
        if (!nbtTag.func_74764_b("id")) {
            short id = (short)GameData.getItemRegistry().getId(nbtTag.func_74779_i("strId"));
            nbtTag.func_74777_a("id", id);
        }
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbtTag);
        return stack;
    }

    public void saveBookmarks() {
        ArrayList<String> strings = new ArrayList<String>();
        for (ItemStack item : this._items) {
            strings.add(NBTJson.toJson(BookmarkPanel.itemStackToNBT(item, new NBTTagCompound())));
        }
        File file = NEIClientConfig.bookmarkFile;
        if (file != null) {
            try (FileWriter writer = new FileWriter(file);){
                IOUtils.writeLines(strings, (String)"\n", (Writer)writer);
            }
            catch (IOException e) {
                NEIClientConfig.logger.error("Filed to save bookmarks list to file {}", new Object[]{file, e});
            }
        }
    }

    public void loadBookmarks() {
        List itemStrings;
        File file = NEIClientConfig.bookmarkFile;
        if (file == null || !file.exists()) {
            return;
        }
        try {
            FileReader reader = new FileReader(file);
            Object object = null;
            try {
                NEIClientConfig.logger.info("Loading bookmarks from file {}", new Object[]{file});
                itemStrings = IOUtils.readLines((Reader)reader);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Failed to load bookmarks from file {}", new Object[]{file, e});
            return;
        }
        this._items.clear();
        JsonParser parser = new JsonParser();
        for (String itemStr : itemStrings) {
            try {
                NBTTagCompound itemStackNBT = (NBTTagCompound)NBTJson.toNbt(parser.parse(itemStr));
                ItemStack itemStack = BookmarkPanel.loadFromNBT(itemStackNBT);
                if (itemStack != null) {
                    this._items.add(itemStack);
                    continue;
                }
                NEIClientConfig.logger.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", new Object[]{itemStr});
            }
            catch (JsonSyntaxException | IllegalArgumentException e) {
                NEIClientConfig.logger.error("Failed to load bookmarked ItemStack from json string:\n{}", new Object[]{itemStr});
            }
        }
    }

    protected ItemStack normalize(ItemStack item) {
        ItemStack copy = item.func_77946_l();
        copy.field_77994_a = 1;
        return copy;
    }

    private boolean remove(ItemStack item) {
        int i = 0;
        for (ItemStack existing : this._items) {
            if (existing == item || existing.func_77969_a(item)) {
                this._items.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getX(GuiContainer gui) {
        return 5;
    }

    @Override
    public int getMarginLeft() {
        return 5;
    }

    @Override
    public int getButtonTop() {
        LayoutStyleMinecraft layout = (LayoutStyleMinecraft)LayoutManager.getLayoutStyle();
        return 2 + (int)Math.ceil((double)layout.buttonCount / (double)layout.numButtons) * 18;
    }

    @Override
    public int getNextX(GuiContainer gui) {
        return gui.field_146294_l - this.prev.w - 2 - ((gui.field_146999_f + gui.field_146294_l) / 2 + 2) - 16;
    }

    @Override
    public int getPrevX(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getPageX(GuiContainer gui) {
        return gui.field_147003_i * 3 / 2 + gui.field_146999_f + 1 - ((gui.field_146999_f + gui.field_146294_l) / 2 + 2) - 16;
    }

    @Override
    public int getHightAdjustment() {
        return 0;
    }

    @Override
    public int getWidth(GuiContainer gui) {
        return LayoutManager.getLeftSize(gui) - ((gui.field_146999_f + gui.field_146294_l) / 2 + 3) - 16;
    }
}

