/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.utils;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.Ingredient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class IngredientTracker {
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final GuiContainer termGui;
    private List<ItemStack> requireStacks;
    private final int recipeIndex;
    private int currentIndex = 0;

    public IngredientTracker(GuiContainer termGui, IRecipeHandler recipe, int recipeIndex) {
        this.termGui = termGui;
        this.recipeIndex = recipeIndex;
        for (PositionedStack requiredIngredient : recipe.getIngredientStacks(recipeIndex)) {
            this.ingredients.add(new Ingredient(requiredIngredient));
        }
        for (Ingredient ingredient : this.ingredients) {
            for (IAEItemStack stack : GuiUtils.getStorageStacks(this.termGui, IAEStack::isCraftable)) {
                if (!ingredient.getIngredient().contains(stack.getItemStack())) continue;
                ingredient.setCraftableIngredient(stack.getItemStack());
            }
        }
        this.calculateIngredients();
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public List<ItemStack> getRequireToCraftStacks() {
        ArrayList<ItemStack> requireToCraftStacks = new ArrayList<ItemStack>();
        for (Ingredient ingredient : this.getIngredients()) {
            boolean find = false;
            if (!ingredient.isCraftable() || !ingredient.requiresToCraft()) continue;
            for (ItemStack stack : requireToCraftStacks) {
                boolean areStackEqual = stack.func_77969_a(ingredient.getCraftableIngredient()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)ingredient.getCraftableIngredient());
                if (!areStackEqual) continue;
                stack.field_77994_a = (int)((long)stack.field_77994_a + ingredient.getMissingCount());
                find = true;
            }
            if (find) continue;
            ItemStack requireStack = ingredient.getCraftableIngredient().func_77946_l();
            requireStack.field_77994_a = (int)ingredient.getMissingCount();
            requireToCraftStacks.add(requireStack);
        }
        return requireToCraftStacks;
    }

    public List<ItemStack> getRequireStacks() {
        return this.requireStacks;
    }

    public boolean hasNext() {
        return this.currentIndex < this.getRequireStacks().size();
    }

    public ItemStack getNextIngredient() {
        return this.getRequiredStack(this.currentIndex++);
    }

    public ItemStack getRequiredStack(int index) {
        return this.getRequireStacks().get(index);
    }

    public int getRecipeIndex() {
        return this.recipeIndex;
    }

    public void addAvailableStack(ItemStack stack) {
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.requiresToCraft()) continue;
            if (NEEConfig.matchOtherItems) {
                if (stack.field_77994_a <= 0 || !ingredient.getIngredient().contains(stack)) continue;
                int missingCount = (int)ingredient.getMissingCount();
                ingredient.addCount(stack.field_77994_a);
                if (ingredient.requiresToCraft()) {
                    stack.field_77994_a = 0;
                    break;
                }
                stack.field_77994_a -= missingCount;
                break;
            }
            ItemStack craftableStack = ingredient.getCraftableIngredient();
            if (craftableStack == null || !craftableStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)craftableStack, (ItemStack)stack) || stack.field_77994_a <= 0) continue;
            int missingCount = (int)ingredient.getMissingCount();
            ingredient.addCount(stack.field_77994_a);
            if (ingredient.requiresToCraft()) {
                stack.field_77994_a = 0;
                break;
            }
            stack.field_77994_a -= missingCount;
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void calculateIngredients() {
        void var3_6;
        List<IAEItemStack> stacks = GuiUtils.getStorageStacks(this.termGui, stack -> NEEConfig.matchOtherItems || stack.isCraftable());
        for (Ingredient ingredient : this.ingredients) {
            ingredient.setCurrentCount(0L);
            for (IAEItemStack stack2 : stacks) {
                if (stack2.getStackSize() <= 0L || !ingredient.getIngredient().contains(stack2.getItemStack())) continue;
                ingredient.addCount(stack2.getStackSize());
                if (ingredient.requiresToCraft()) {
                    stack2.setStackSize(0L);
                    continue;
                }
                stack2.setStackSize(stack2.getStackSize() - ingredient.getRequireCount());
            }
        }
        ArrayList<ItemStack> inventoryStacks = new ArrayList<ItemStack>();
        for (Slot slot : this.termGui.field_147002_h.field_75151_b) {
            boolean canGetStack = slot != null && slot.func_75216_d() && slot.func_75211_c().field_77994_a > 0 && slot.func_75214_a(slot.func_75211_c()) && slot.func_82869_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (!canGetStack) continue;
            inventoryStacks.add(slot.func_75211_c().func_77946_l());
        }
        boolean bl = false;
        while (var3_6 < this.getIngredients().size()) {
            for (ItemStack stack3 : inventoryStacks) {
                this.addAvailableStack(stack3);
            }
            ++var3_6;
        }
        this.requireStacks = this.getRequireToCraftStacks();
    }
}

