/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee;

import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.client.gui.implementations.GuiInterface;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.gui.implementations.GuiMEPortableCell;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.client.gui.implementations.GuiPatternTermEx;
import codechicken.nei.NEIController;
import codechicken.nei.api.API;
import codechicken.nei.api.IBookmarkContainerHandler;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.DefaultOverlayHandler;
import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.client.GuiEventHandler;
import com.github.vfyjxf.nee.nei.NEECraftingTerminalHandler;
import com.github.vfyjxf.nee.nei.NEEExtremeAutoCrafterHandler;
import com.github.vfyjxf.nee.nei.NEEKnowledgeInscriberHandler;
import com.github.vfyjxf.nee.nei.NEEPatternTerminalHandler;
import com.github.vfyjxf.nee.nei.NEETerminalBookmarkContainerHandler;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import com.github.vfyjxf.nee.processor.RecipeProcessor;
import com.glodblock.github.client.gui.GuiFluidCraftingWireless;
import com.glodblock.github.client.gui.GuiFluidPatternExWireless;
import com.glodblock.github.client.gui.GuiFluidPatternTerminal;
import com.glodblock.github.client.gui.GuiFluidPatternTerminalEx;
import com.glodblock.github.client.gui.GuiFluidPatternWireless;
import cpw.mods.fml.common.Loader;
import fox.spiteful.avaritia.gui.GUIExtremeCrafting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.p455w0rd.wirelesscraftingterminal.client.gui.GuiWirelessCraftingTerminal;
import thaumicenergistics.client.gui.GuiArcaneCraftingTerminal;
import thaumicenergistics.client.gui.GuiKnowledgeInscriber;
import wanion.avaritiaddons.block.extremeautocrafter.GuiExtremeAutoCrafter;

public class NEINeeConfig
implements IConfigureNEI {
    private static final List<Class<?>> transferBlacklist = new ArrayList<Class>(Arrays.asList(GuiInterface.class, GuiPatternTerm.class));

    public void loadConfig() {
        RecipeProcessor.init();
        this.registerKeyBindings();
        this.registerGuiHandler();
        HashSet<String> defaultIdentifiers = new HashSet<String>(Arrays.asList("crafting", "crafting2x2", "brewing", "smelting", "fuel", null));
        HashSet<String> identifiers = new HashSet<String>(defaultIdentifiers);
        RecipeProcessor.recipeProcessors.stream().map(IRecipeProcessor::getAllOverlayIdentifier).forEach(identifiers::addAll);
        for (String ident : identifiers) {
            API.registerGuiOverlay(GuiPatternTerm.class, (String)ident);
            API.registerGuiOverlayHandler(GuiPatternTerm.class, (IOverlayHandler)NEEPatternTerminalHandler.instance, (String)ident);
        }
        this.installCraftingTermSupport();
        this.installWirelessCraftingTermSupport();
        this.installFluidPatternTerminalSupport(new HashSet<String>(identifiers));
        this.installThaumicEnergisticsSupport();
        this.installAvaritiaSupport();
        this.installAvaritiaddonsSupport();
        this.installPatternTerminalExSupport(new HashSet<String>(identifiers));
        this.installFluidPatternTerminalExSupport(new HashSet<String>(identifiers));
        this.installlBookmarkContainerHandler();
    }

    private void installFluidPatternTerminalExSupport(Set<String> identifiers) {
        if (Loader.isModLoaded((String)"ae2fc")) {
            identifiers.remove("crafting");
            identifiers.remove("crafting2x2");
            for (String ident : identifiers) {
                API.registerGuiOverlay(GuiFluidPatternTerminalEx.class, (String)ident);
                API.registerGuiOverlay(GuiFluidPatternExWireless.class, (String)ident);
                API.registerGuiOverlayHandler(GuiFluidPatternTerminalEx.class, (IOverlayHandler)NEEPatternTerminalHandler.instance, (String)ident);
                API.registerGuiOverlayHandler(GuiFluidPatternExWireless.class, (IOverlayHandler)NEEPatternTerminalHandler.instance, (String)ident);
            }
        }
    }

    private void installFluidPatternTerminalSupport(Set<String> identifiers) {
        if (Loader.isModLoaded((String)"ae2fc")) {
            for (String ident : identifiers) {
                API.registerGuiOverlay(GuiFluidPatternTerminal.class, (String)ident);
                API.registerGuiOverlay(GuiFluidPatternWireless.class, (String)ident);
                API.registerGuiOverlayHandler(GuiFluidPatternTerminal.class, (IOverlayHandler)NEEPatternTerminalHandler.instance, (String)ident);
                API.registerGuiOverlayHandler(GuiFluidPatternWireless.class, (IOverlayHandler)NEEPatternTerminalHandler.instance, (String)ident);
            }
        }
    }

    private void installlBookmarkContainerHandler() {
        API.registerBookmarkContainerHandler(GuiPatternTerm.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
        API.registerBookmarkContainerHandler(GuiPatternTermEx.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
        API.registerBookmarkContainerHandler(GuiCraftingTerm.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
        API.registerBookmarkContainerHandler(GuiMEMonitorable.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
        API.registerBookmarkContainerHandler(GuiMEPortableCell.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
        if (Loader.isModLoaded((String)"ae2fc")) {
            API.registerBookmarkContainerHandler(GuiFluidPatternWireless.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
            API.registerBookmarkContainerHandler(GuiFluidPatternTerminal.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
            API.registerBookmarkContainerHandler(GuiFluidPatternTerminalEx.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
            API.registerBookmarkContainerHandler(GuiFluidPatternExWireless.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
            API.registerBookmarkContainerHandler(GuiFluidCraftingWireless.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
        }
        if (Loader.isModLoaded((String)"ae2wct")) {
            API.registerBookmarkContainerHandler(GuiWirelessCraftingTerminal.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
        }
        if (Loader.isModLoaded((String)"thaumicenergistics")) {
            API.registerBookmarkContainerHandler(GuiArcaneCraftingTerminal.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
        }
    }

    public String getName() {
        return "NotEnoughEnergistics";
    }

    public String getVersion() {
        return "1.7.7";
    }

    private void registerKeyBindings() {
        API.addKeyBind((String)"nee.count", (int)29);
        API.addKeyBind((String)"nee.ingredient", (int)42);
        API.addKeyBind((String)"nee.preview", (int)29);
        API.addKeyBind((String)"nee.nopreview", (int)56);
    }

    private void registerGuiHandler() {
        API.registerNEIGuiHandler((INEIGuiHandler)GuiEventHandler.instance);
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)GuiEventHandler.instance);
        this.replaceNEIController();
    }

    private void replaceNEIController() {
        int controllerIndex = -1;
        for (IContainerInputHandler inputHandler : GuiContainerManager.inputHandlers) {
            if (!(inputHandler instanceof NEIController)) continue;
            controllerIndex = GuiContainerManager.inputHandlers.indexOf(inputHandler);
            break;
        }
        if (controllerIndex > 0) {
            GuiContainerManager.inputHandlers.remove(controllerIndex);
            GuiContainerManager.inputHandlers.add(controllerIndex, new NEIController(){

                public boolean mouseScrolled(GuiContainer gui, int mouseX, int mouseY, int scrolled) {
                    if (transferBlacklist.contains(gui.getClass())) {
                        return false;
                    }
                    return super.mouseScrolled(gui, mouseX, mouseY, scrolled);
                }
            });
            NotEnoughEnergistics.logger.info("NEIController replaced success");
        }
    }

    private void installCraftingTermSupport() {
        API.registerGuiOverlay(GuiCraftingTerm.class, (String)"crafting");
        API.registerGuiOverlay(GuiCraftingTerm.class, (String)"crafting2x2");
        API.registerGuiOverlayHandler(GuiCraftingTerm.class, (IOverlayHandler)NEECraftingTerminalHandler.instance, (String)"crafting");
        API.registerGuiOverlayHandler(GuiCraftingTerm.class, (IOverlayHandler)NEECraftingTerminalHandler.instance, (String)"crafting2x2");
        if (Loader.isModLoaded((String)"ae2fc")) {
            API.registerGuiOverlayHandler(GuiFluidCraftingWireless.class, (IOverlayHandler)NEECraftingTerminalHandler.instance, (String)"crafting");
            API.registerGuiOverlayHandler(GuiFluidCraftingWireless.class, (IOverlayHandler)NEECraftingTerminalHandler.instance, (String)"crafting2x2");
        }
    }

    private void installWirelessCraftingTermSupport() {
        if (Loader.isModLoaded((String)"ae2wct")) {
            API.registerGuiOverlayHandler(GuiWirelessCraftingTerminal.class, (IOverlayHandler)NEECraftingTerminalHandler.instance, (String)"crafting");
            API.registerGuiOverlayHandler(GuiWirelessCraftingTerminal.class, (IOverlayHandler)NEECraftingTerminalHandler.instance, (String)"crafting2x2");
        }
    }

    private void installThaumicEnergisticsSupport() {
        if (Loader.isModLoaded((String)"thaumicenergistics")) {
            NotEnoughEnergistics.logger.info("Install ThaumicEnergistics support");
            try {
                Class.forName("thaumicenergistics.client.gui.GuiKnowledgeInscriber");
                API.registerGuiOverlay(GuiKnowledgeInscriber.class, (String)"arcaneshapedrecipes");
                API.registerGuiOverlay(GuiKnowledgeInscriber.class, (String)"arcaneshapelessSrecipes");
                API.registerGuiOverlayHandler(GuiKnowledgeInscriber.class, (IOverlayHandler)NEEKnowledgeInscriberHandler.instance, (String)"arcaneshapedrecipes");
                API.registerGuiOverlayHandler(GuiKnowledgeInscriber.class, (IOverlayHandler)NEEKnowledgeInscriberHandler.instance, (String)"arcaneshapelessrecipes");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void installPatternTerminalExSupport(Set<String> identifiers) {
        identifiers.remove("crafting");
        identifiers.remove("crafting2x2");
        for (String ident : identifiers) {
            API.registerGuiOverlay(GuiPatternTermEx.class, (String)ident);
            API.registerGuiOverlayHandler(GuiPatternTermEx.class, (IOverlayHandler)NEEPatternTerminalHandler.instance, (String)ident);
        }
    }

    private void installAvaritiaddonsSupport() {
        try {
            Class.forName("wanion.avaritiaddons.block.extremeautocrafter.GuiExtremeAutoCrafter");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (Loader.isModLoaded((String)"avaritiaddons")) {
            NotEnoughEnergistics.logger.info("Install Avaritiaddons support");
            API.registerGuiOverlay(GuiExtremeAutoCrafter.class, (String)"extreme", (int)181, (int)15);
            API.registerGuiOverlayHandler(GuiExtremeAutoCrafter.class, (IOverlayHandler)NEEExtremeAutoCrafterHandler.instance, (String)"extreme");
        }
    }

    private void installAvaritiaSupport() {
        try {
            Class.forName("fox.spiteful.avaritia.gui.GUIExtremeCrafting");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (Loader.isModLoaded((String)"Avaritia")) {
            API.registerGuiOverlay(GUIExtremeCrafting.class, (String)"extreme", (int)9, (int)5);
            API.registerGuiOverlayHandler(GUIExtremeCrafting.class, (IOverlayHandler)new DefaultOverlayHandler(9, 5), (String)"extreme");
        }
    }
}

