/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.nei;

import appeng.util.Platform;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.GuiOverlayButton;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeButton;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.github.vfyjxf.nee.config.ItemCombination;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.nei.NEETerminalOverlayButton;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketNEIPatternRecipe;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import com.github.vfyjxf.nee.processor.RecipeProcessor;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.Ingredient;
import com.github.vfyjxf.nee.utils.IngredientTracker;
import com.github.vfyjxf.nee.utils.ItemUtils;
import com.glodblock.github.nei.FluidPatternTerminalRecipeTransferHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NEEPatternTerminalHandler
implements IOverlayHandler {
    public static final String INPUT_KEY = "#";
    public static final String OUTPUT_KEY = "Outputs";
    public static Map<String, PositionedStack> ingredients = new HashMap<String, PositionedStack>();
    public static final NEEPatternTerminalHandler instance = new NEEPatternTerminalHandler();

    private NEEPatternTerminalHandler() {
    }

    public void overlayRecipe(GuiContainer gui, IRecipeHandler handler, int recipeIndex, boolean shift) {
        this.transferRecipe(gui, handler, recipeIndex, 1);
    }

    public int transferRecipe(GuiContainer gui, IRecipeHandler handler, int recipeIndex, int multiplier) {
        multiplier = Math.max(1, multiplier);
        NEENetworkHandler.getInstance().sendToServer((IMessage)this.packRecipe(handler, recipeIndex, multiplier));
        if (Loader.isModLoaded((String)"ae2fc") && (GuiUtils.isFluidCraftPatternTermEx((GuiScreen)gui) || GuiUtils.isFluidCraftPatternTerm((GuiScreen)gui))) {
            this.fluidCraftOverlayRecipe(gui, handler, recipeIndex);
        }
        return 0;
    }

    public List<GuiOverlayButton.ItemOverlayState> presenceOverlay(GuiContainer firstGui, IRecipeHandler handler, int recipeIndex) {
        IngredientTracker tracker = new IngredientTracker(firstGui, handler, recipeIndex);
        ArrayList<GuiOverlayButton.ItemOverlayState> itemPresenceSlots = new ArrayList<GuiOverlayButton.ItemOverlayState>();
        for (Ingredient ingredient : tracker.getIngredients()) {
            itemPresenceSlots.add(new NEETerminalOverlayButton.NEEItemOverlayState(ingredient, false));
        }
        return itemPresenceSlots;
    }

    @Optional.Method(modid="ae2fc")
    private void fluidCraftOverlayRecipe(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex) {
        FluidPatternTerminalRecipeTransferHandler.INSTANCE.overlayRecipe(firstGui, recipe, recipeIndex, true);
    }

    private PacketNEIPatternRecipe packRecipe(IRecipeHandler recipe, int recipeIndex, int multiplier) {
        if (this.isCraftingTableRecipe(recipe)) {
            return this.packCraftingTableRecipe(recipe, recipeIndex);
        }
        return this.packProcessRecipe(recipe, recipeIndex, multiplier);
    }

    private boolean isCraftingTableRecipe(IRecipeHandler recipe) {
        if (recipe instanceof TemplateRecipeHandler) {
            TemplateRecipeHandler templateRecipeHandler = (TemplateRecipeHandler)recipe;
            String overlayIdentifier = templateRecipeHandler.getOverlayIdentifier();
            return "crafting".equals(overlayIdentifier) || "crafting2x2".equals(overlayIdentifier);
        }
        return false;
    }

    private PacketNEIPatternRecipe packProcessRecipe(IRecipeHandler recipe, int recipeIndex, int multiplier) {
        String identifier;
        NBTTagCompound recipeInputs = new NBTTagCompound();
        NBTTagCompound recipeOutputs = new NBTTagCompound();
        String string = identifier = recipe instanceof TemplateRecipeHandler ? recipe.getOverlayIdentifier() : "null";
        if (identifier == null) {
            identifier = "null";
        }
        int inputIndex = 0;
        int outputIndex = 0;
        for (IRecipeProcessor processor : RecipeProcessor.recipeProcessors) {
            if (!processor.getAllOverlayIdentifier().contains(identifier)) continue;
            List<PositionedStack> inputs = processor.getRecipeInput(recipe, recipeIndex, identifier);
            List<PositionedStack> outputs = processor.getRecipeOutput(recipe, recipeIndex, identifier);
            String recipeProcessorId = processor.getRecipeProcessorId();
            if (inputs.isEmpty() || outputs.isEmpty()) continue;
            List<PositionedStack> mergedInputs = this.getMergedInputs(inputs, processor, recipe, recipeIndex, identifier);
            ingredients.clear();
            for (PositionedStack positionedStack : mergedInputs) {
                ItemStack currentStack = (ItemStack)positionedStack.getFilteredPermutations().get(0);
                ItemStack preferModItem = ItemUtils.getPreferModItem(positionedStack.items);
                int stackSize = currentStack.field_77994_a;
                if (preferModItem != null) {
                    currentStack = preferModItem;
                    currentStack.field_77994_a = stackSize;
                }
                for (ItemStack stack : positionedStack.items) {
                    if (!Platform.isRecipePrioritized((ItemStack)stack) && !ItemUtils.isPreferItems(stack, recipeProcessorId, identifier)) continue;
                    currentStack = stack.func_77946_l();
                    currentStack.field_77994_a = stackSize;
                    break;
                }
                if (ItemUtils.isInBlackList(currentStack, recipeProcessorId, identifier)) continue;
                if (currentStack.func_77960_j() == Short.MAX_VALUE) {
                    currentStack.func_77964_b(0);
                }
                if (currentStack.field_77994_a < 1) {
                    currentStack.field_77994_a = 1;
                }
                recipeInputs.func_74782_a(INPUT_KEY + inputIndex, (NBTBase)ItemUtils.writeItemStackToNBT(currentStack, currentStack.field_77994_a * multiplier));
                ingredients.put(INPUT_KEY + inputIndex, positionedStack);
                ++inputIndex;
            }
            for (PositionedStack positionedStack : outputs) {
                if (outputIndex >= 4 || positionedStack == null || positionedStack.item == null) continue;
                ItemStack outputStack = positionedStack.item.func_77946_l();
                if (outputStack.func_77960_j() == Short.MAX_VALUE) {
                    outputStack.func_77964_b(0);
                }
                if (outputStack.field_77994_a < 1) {
                    outputStack.field_77994_a = 1;
                }
                recipeOutputs.func_74782_a(OUTPUT_KEY + outputIndex, (NBTBase)ItemUtils.writeItemStackToNBT(outputStack, outputStack.field_77994_a * multiplier));
                ++outputIndex;
            }
        }
        return new PacketNEIPatternRecipe(recipeInputs, recipeOutputs);
    }

    private List<PositionedStack> getMergedInputs(List<PositionedStack> inputs, IRecipeProcessor processor, IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> mergedInputs = new ArrayList<PositionedStack>();
        for (PositionedStack positionedStack : inputs) {
            ItemStack currentStack = (ItemStack)positionedStack.getFilteredPermutations().get(0);
            ItemCombination currentValue = ItemCombination.valueOf(NEEConfig.itemCombinationMode);
            boolean find = false;
            if (currentValue != ItemCombination.DISABLED && processor.mergeStacks(recipe, recipeIndex, identifier)) {
                boolean isWhitelist;
                boolean bl = isWhitelist = currentValue == ItemCombination.WHITELIST && Arrays.asList(NEEConfig.itemCombinationWhitelist).contains(identifier);
                if (currentValue == ItemCombination.ENABLED || isWhitelist) {
                    for (PositionedStack storedStack : mergedInputs) {
                        ItemStack firstStack = (ItemStack)storedStack.getFilteredPermutations().get(0);
                        boolean areItemStackEqual = NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)firstStack, (ItemStack)currentStack);
                        if (!areItemStackEqual || firstStack.field_77994_a + currentStack.field_77994_a > firstStack.func_77976_d()) continue;
                        storedStack.items[0].field_77994_a = firstStack.field_77994_a + currentStack.field_77994_a;
                        find = true;
                    }
                }
            }
            if (find) continue;
            mergedInputs.add(positionedStack.copy());
        }
        return mergedInputs;
    }

    private PacketNEIPatternRecipe packCraftingTableRecipe(IRecipeHandler recipe, int recipeIndex) {
        List ingredients = recipe.getIngredientStacks(recipeIndex);
        NBTTagCompound recipeInputs = new NBTTagCompound();
        NEEPatternTerminalHandler.ingredients.clear();
        for (PositionedStack positionedStack : ingredients) {
            int col = (positionedStack.relx - 25) / 18;
            int row = (positionedStack.rely - 6) / 18;
            int slotIndex = col + row * 3;
            if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
            positionedStack = positionedStack.copy();
            ItemStack stack = (ItemStack)positionedStack.getFilteredPermutations().get(0);
            ItemStack preferModItem = ItemUtils.getPreferModItem(positionedStack.items);
            if (preferModItem != null) {
                stack = preferModItem;
            }
            for (ItemStack currentStack : positionedStack.items) {
                if (!Platform.isRecipePrioritized((ItemStack)currentStack) && !ItemUtils.isPreferItems(currentStack)) continue;
                stack = currentStack.func_77946_l();
            }
            ItemUtils.transformGTTool(stack);
            if (stack.func_77960_j() == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
            positionedStack.item = stack;
            recipeInputs.func_74782_a(INPUT_KEY + slotIndex, (NBTBase)ItemUtils.writeItemStackToNBT(stack, stack.field_77994_a));
            NEEPatternTerminalHandler.ingredients.put(INPUT_KEY + slotIndex, positionedStack);
        }
        return new PacketNEIPatternRecipe(recipeInputs, null);
    }

    @SubscribeEvent
    public void onActionPerformedEventPost(GuiRecipeButton.UpdateRecipeButtonsEvent.Post event) {
        GuiRecipe guiRecipe;
        GuiScreen guiScreen = event.gui;
        if (guiScreen instanceof GuiRecipe && this.isGuiPatternTerm(guiRecipe = (GuiRecipe)guiScreen)) {
            NEETerminalOverlayButton.updateRecipeButtons(guiRecipe, event.buttonList);
        }
    }

    private boolean isGuiPatternTerm(GuiRecipe<?> gui) {
        return gui.firstGui != null && this.getClass().isInstance(gui.getHandler().getOverlayHandler(gui.firstGui, 0));
    }
}

