/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.nei;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.implementations.GuiAmount;
import appeng.client.gui.implementations.GuiCraftAmount;
import appeng.client.gui.implementations.GuiCraftConfirm;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketCraftingRequest;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.Ingredient;
import com.github.vfyjxf.nee.utils.IngredientTracker;
import com.github.vfyjxf.nee.utils.ItemUtils;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.gui.GuiFluidCraftAmount;
import com.glodblock.github.client.gui.base.FCGuiAmount;
import com.glodblock.github.network.CPacketInventoryAction;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.p455w0rd.wirelesscraftingterminal.core.sync.WCTPacket;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import thaumicenergistics.common.network.packet.server.Packet_S_ArcaneCraftingTerminal;

public class NEECraftingPreviewHandler {
    public static final NEECraftingPreviewHandler instance = new NEECraftingPreviewHandler();
    private boolean isPatternInterfaceExists = false;
    private NBTTagCompound patternCompound = null;
    private IngredientTracker tracker = null;
    private boolean isAutoStart = false;
    private int resultStackSize = 0;
    private String modID = "";

    private NEECraftingPreviewHandler() {
    }

    public boolean handle(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex) {
        PositionedStack pStack = recipe.getResultStack(recipeIndex);
        this.isAutoStart = NEIClientConfig.isKeyHashDown((String)"nee.nopreview");
        this.modID = NEECraftingPreviewHandler.getModID(firstGui.field_147002_h);
        this.resultStackSize = 0;
        this.patternCompound = null;
        this.tracker = null;
        if ((this.isAutoStart || NEIClientConfig.isKeyHashDown((String)"nee.preview")) && !this.modID.isEmpty()) {
            firstGui.field_146297_k.func_147108_a((GuiScreen)firstGui);
            if (pStack != null) {
                this.resultStackSize = pStack.item.field_77994_a;
            }
            if (pStack != null && this.existsRecipeResult(firstGui, pStack)) {
                if (this.isAutoStart) {
                    PacketCraftingRequest craftingRequest = new PacketCraftingRequest(this.modID, PacketCraftingRequest.COMMAND_OPEN_CRAFT_CONFIRM, pStack.item.func_77955_b(new NBTTagCompound()), pStack.item.field_77994_a, true);
                    NEENetworkHandler.getInstance().sendToServer((IMessage)craftingRequest);
                } else {
                    this.openCraftAmount(firstGui, pStack.item);
                }
                return true;
            }
            if (pStack != null && this.isPatternInterfaceExists && this.isCraftingTableRecipe(recipe)) {
                this.patternCompound = this.getPatternStack(recipe, recipeIndex, (World)Minecraft.func_71410_x().field_71441_e);
                if (this.isAutoStart) {
                    PacketCraftingRequest craftingRequest = new PacketCraftingRequest(this.modID, PacketCraftingRequest.COMMAND_CREATE_PATTERN, this.patternCompound, pStack.item.field_77994_a, true);
                    NEENetworkHandler.getInstance().sendToServer((IMessage)craftingRequest);
                } else {
                    this.openCraftAmount(firstGui, pStack.item);
                }
                return true;
            }
            this.tracker = new IngredientTracker(firstGui, recipe, recipeIndex);
            if (this.tracker.hasNext()) {
                if (this.isAutoStart) {
                    this.requestNextIngredient();
                } else if (pStack != null) {
                    this.openCraftAmount(firstGui, pStack.item);
                } else {
                    PositionedStack otherStack = null;
                    Iterator iterator = recipe.getOtherStacks(recipeIndex).iterator();
                    if (iterator.hasNext()) {
                        PositionedStack positionedStack;
                        otherStack = positionedStack = (PositionedStack)iterator.next();
                    }
                    if (otherStack != null) {
                        this.resultStackSize = otherStack.item.field_77994_a;
                        this.openCraftAmount(firstGui, otherStack.item);
                    } else {
                        return false;
                    }
                }
                return true;
            }
            this.tracker = null;
            return false;
        }
        return false;
    }

    private void openCraftAmount(GuiContainer firstGui, ItemStack itemstack) {
        AEItemStack aeItemStack = AEItemStack.create((ItemStack)itemstack);
        if (this.modID.equals("thaumicenergistics")) {
            this.sendToArcaneCraftingerver((IAEItemStack)aeItemStack);
        } else if (this.modID.equals("ae2fc")) {
            ((AEBaseContainer)firstGui.field_147002_h).setTargetStack((IAEItemStack)aeItemStack);
            this.sendToFluidCraftingServer();
        } else if (this.modID.equals("ae2wct")) {
            ((AEBaseContainer)firstGui.field_147002_h).setTargetStack((IAEItemStack)aeItemStack);
            this.sendToWirelessCraftingServer();
        } else if (this.modID.equals("AE")) {
            ((AEBaseContainer)firstGui.field_147002_h).setTargetStack((IAEItemStack)aeItemStack);
            appeng.core.sync.network.NetworkHandler.instance.sendToServer((AppEngPacket)new PacketInventoryAction(InventoryAction.AUTO_CRAFT, 0, 0L));
        }
    }

    @Optional.Method(modid="thaumicenergistics")
    protected void sendToArcaneCraftingerver(IAEItemStack aeItemStack) {
        Packet_S_ArcaneCraftingTerminal.sendAutoCraft((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (IAEItemStack)aeItemStack);
    }

    @Optional.Method(modid="ae2fc")
    protected void sendToFluidCraftingServer() {
        CPacketInventoryAction packet = new CPacketInventoryAction(InventoryAction.AUTO_CRAFT, 0, 0L);
        FluidCraft.proxy.netHandler.sendToServer((IMessage)packet);
    }

    @Optional.Method(modid="ae2wct")
    protected void sendToWirelessCraftingServer() {
        net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketInventoryAction packet = new net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketInventoryAction(InventoryAction.AUTO_CRAFT, 0, 0L);
        NetworkHandler.instance.sendToServer((WCTPacket)packet);
    }

    @SubscribeEvent
    public void onGuiCraftConfirmOpen(GuiOpenEvent event) {
        GuiScreen old = Minecraft.func_71410_x().field_71462_r;
        if (this.patternCompound != null && old instanceof GuiCraftConfirm) {
            this.patternCompound = null;
        }
        if (this.tracker != null && old instanceof GuiCraftConfirm) {
            if (old != null && this.tracker.hasNext()) {
                this.requestNextIngredient();
            } else {
                this.tracker = null;
            }
        }
    }

    @SubscribeEvent
    public void onCraftConfirmActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        GuiScreen guiScreen;
        if ((this.tracker != null || this.patternCompound != null) && (guiScreen = event.gui) instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)guiScreen;
            int craftAmount = NEECraftingPreviewHandler.getCraftAmount(gui, event.button);
            if (craftAmount == -1) {
                return;
            }
            if (this.tracker != null) {
                int craftMultiplier = (int)Math.ceil(1.0f * (float)craftAmount / (float)this.resultStackSize);
                this.isAutoStart = this.isAutoStart || GuiScreen.func_146272_n();
                for (Ingredient ingr : this.tracker.getIngredients()) {
                    ingr.setRequireCount(ingr.getRequireCount() * (long)craftMultiplier);
                }
                this.tracker.calculateIngredients();
                this.requestNextIngredient();
                event.setCanceled(true);
            } else if (this.patternCompound != null) {
                PacketCraftingRequest craftingRequest = new PacketCraftingRequest(this.modID, PacketCraftingRequest.COMMAND_CREATE_PATTERN, this.patternCompound, craftAmount, GuiScreen.func_146272_n());
                NEENetworkHandler.getInstance().sendToServer((IMessage)craftingRequest);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onCraftConfirmActionPerformed(GuiScreenEvent.ActionPerformedEvent.Post event) {
        GuiCraftConfirm guiConfirm;
        GuiScreen guiScreen;
        if ((this.tracker != null || this.patternCompound != null) && (guiScreen = event.gui) instanceof GuiCraftConfirm && NEECraftingPreviewHandler.getCancelButton(guiConfirm = (GuiCraftConfirm)guiScreen) == event.button) {
            if (this.patternCompound != null) {
                PacketCraftingRequest craftingRequest = new PacketCraftingRequest(this.modID, PacketCraftingRequest.COMMAND_REMOVE_PATTERN, this.patternCompound, 0, false);
                NEENetworkHandler.getInstance().sendToServer((IMessage)craftingRequest);
            }
            this.patternCompound = null;
            this.tracker = null;
        }
    }

    private static GuiButton getCancelButton(GuiCraftConfirm gui) {
        return (GuiButton)ReflectionHelper.getPrivateValue(GuiCraftConfirm.class, (Object)gui, (String[])new String[]{"cancel"});
    }

    private static int getCraftAmount(GuiContainer screen, GuiButton button) {
        try {
            GuiCraftAmount gui;
            if (Loader.isModLoaded((String)"ae2fc") && screen instanceof GuiFluidCraftAmount) {
                GuiFluidCraftAmount gui2 = (GuiFluidCraftAmount)screen;
                if (ReflectionHelper.getPrivateValue(FCGuiAmount.class, (Object)gui2, (String[])new String[]{"submit"}) == button) {
                    return (Integer)ReflectionHelper.findMethod(FCGuiAmount.class, (Object)gui2, (String[])new String[]{"getAmount"}, (Class[])new Class[0]).invoke((Object)gui2, new Object[0]);
                }
            } else if (screen instanceof GuiCraftAmount && ReflectionHelper.getPrivateValue(GuiAmount.class, (Object)(gui = (GuiCraftAmount)screen), (String[])new String[]{"nextBtn"}) == button) {
                return (Integer)ReflectionHelper.findMethod(GuiAmount.class, (Object)gui, (String[])new String[]{"getAmount"}, (Class[])new Class[0]).invoke((Object)gui, new Object[0]);
            }
        }
        catch (Exception ex) {
            return 1;
        }
        return -1;
    }

    private static String getModID(Container container) {
        if (Loader.isModLoaded((String)"thaumicenergistics") && container.getClass().getName().startsWith("thaumicenergistics.common.container")) {
            return "thaumicenergistics";
        }
        if (Loader.isModLoaded((String)"ae2fc") && container.getClass().getName().startsWith("com.glodblock.github.client.gui.container")) {
            return "ae2fc";
        }
        if (Loader.isModLoaded((String)"ae2wct") && container.getClass().getName().startsWith("net.p455w0rd.wirelesscraftingterminal.common.container")) {
            return "ae2wct";
        }
        if (container instanceof AEBaseContainer) {
            return "AE";
        }
        return "";
    }

    private void requestNextIngredient() {
        ItemStack stack = this.tracker.getNextIngredient();
        if (stack != null) {
            PacketCraftingRequest craftingRequest = new PacketCraftingRequest(this.modID, PacketCraftingRequest.COMMAND_OPEN_CRAFT_CONFIRM, stack.func_77955_b(new NBTTagCompound()), stack.field_77994_a, this.isAutoStart);
            NEENetworkHandler.getInstance().sendToServer((IMessage)craftingRequest);
        }
    }

    private boolean isCraftingTableRecipe(IRecipeHandler recipe) {
        if (recipe instanceof TemplateRecipeHandler) {
            TemplateRecipeHandler templateRecipeHandler = (TemplateRecipeHandler)recipe;
            String overlayIdentifier = templateRecipeHandler.getOverlayIdentifier();
            return "crafting".equals(overlayIdentifier) || "crafting2x2".equals(overlayIdentifier);
        }
        return false;
    }

    private NBTTagCompound getPatternStack(IRecipeHandler recipeHandler, int recipeIndex, World world) {
        InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
        List ingredients = recipeHandler.getIngredientStacks(recipeIndex);
        for (PositionedStack positionedStack : ingredients) {
            int col = (positionedStack.relx - 25) / 18;
            int row = (positionedStack.rely - 6) / 18;
            int slotIndex = col + row * 3;
            if (positionedStack.items != null && positionedStack.items.length > 0) {
                ItemStack[] currentStackList = positionedStack.items;
                ItemStack stack = positionedStack.items[0];
                ItemStack preferModItem = ItemUtils.getPreferModItem(positionedStack.items);
                if (preferModItem != null) {
                    stack = preferModItem;
                }
                for (ItemStack currentStack : currentStackList) {
                    if (!Platform.isRecipePrioritized((ItemStack)currentStack) && !ItemUtils.isPreferItems(currentStack)) continue;
                    stack = currentStack.func_77946_l();
                }
                if (stack.func_77960_j() == Short.MAX_VALUE) {
                    stack.func_77964_b(0);
                }
                ic.func_70299_a(slotIndex, stack);
                continue;
            }
            ic.func_70299_a(slotIndex, null);
        }
        ItemStack result = CraftingManager.func_77594_a().func_82787_a(ic, world);
        if (result != null) {
            NBTTagCompound patternValue = new NBTTagCompound();
            NBTTagList tagIn = new NBTTagList();
            for (int slotIndex = 0; slotIndex < ic.func_70302_i_(); ++slotIndex) {
                ItemStack itemStack = ic.func_70301_a(slotIndex);
                if (itemStack != null) {
                    tagIn.func_74742_a((NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
                    continue;
                }
                tagIn.func_74742_a((NBTBase)new NBTTagCompound());
            }
            patternValue.func_74782_a("in", (NBTBase)tagIn);
            patternValue.func_74782_a("out", (NBTBase)result.func_77955_b(new NBTTagCompound()));
            patternValue.func_74757_a("crafting", true);
            patternValue.func_74757_a("substitute", false);
            return patternValue;
        }
        return null;
    }

    public void setIsPatternInterfaceExists(boolean isPatternInterfaceExists) {
        this.isPatternInterfaceExists = isPatternInterfaceExists;
    }

    public boolean canCraftRecipeResult(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex) {
        PositionedStack pStack = recipe.getResultStack(recipeIndex);
        if (pStack == null) {
            return false;
        }
        if (this.isPatternInterfaceExists && this.isCraftingTableRecipe(recipe)) {
            return true;
        }
        return this.existsRecipeResult(firstGui, pStack);
    }

    private boolean existsRecipeResult(GuiContainer firstGui, PositionedStack pStack) {
        return pStack != null && !GuiUtils.getStorageStacks(firstGui, aestack -> aestack.isCraftable() && aestack.isSameType(pStack.item)).isEmpty();
    }
}

