/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.block.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.core.settings.TickRates;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.me.GridAccessException;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.WrapperInvSlot;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePatternInterface
extends AENetworkInvTile
implements IGridTickable,
ICraftingProvider,
IInventoryDestination {
    private final int[] sides = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private final AppEngInternalInventory gridInv;
    private final AppEngInternalInventory patterns;
    private final AppEngInternalInventory ejectInv;
    private List<ICraftingPatternDetails> craftingList;
    private List<ItemStack> waitingToSend;
    private final MachineSource source;
    private final WrapperInvSlot slotInv;
    private final boolean[] workStarted = new boolean[9];

    public TilePatternInterface() {
        this.gridInv = new AppEngInternalInventory((IAEAppEngInventory)this, 10);
        this.gridInv.setMaxStackSize(1);
        this.patterns = new AppEngInternalInventory((IAEAppEngInventory)this, 9);
        this.ejectInv = new AppEngInternalInventory((IAEAppEngInventory)this, 9);
        this.craftingList = new ArrayList<ICraftingPatternDetails>();
        this.source = new MachineSource((IActionHost)this);
        this.slotInv = new WrapperInvSlot((IInventory)this.ejectInv);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.getProxy().setIdlePowerUsage(30.0);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.notifyNeighbors();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.notifyNeighbors();
    }

    private void notifyNeighbors() {
        if (this.getProxy().isActive()) {
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            Platform.notifyBlocksOfNeighbors((World)this.func_145831_w(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(TickRates.Interface.getMin(), TickRates.Interface.getMax(), !this.hasItemToSend(), true);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.getProxy().isActive()) {
            return TickRateModulation.SLEEP;
        }
        if (this.hasItemToSend()) {
            this.ejectItems();
        }
        if (this.hasItemsToPush()) {
            this.pushItemsOut(EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN)));
        }
        if (this.hasWorkFinished()) {
            this.updateWorks();
        }
        if (this.hasWorks()) {
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLEEP;
    }

    @Nonnull
    public IInventory getInternalInventory() {
        return this.ejectInv;
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.ejectInv || inv == this.patterns) {
            try {
                this.getProxy().getTick().alertDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public void onReady() {
        super.onReady();
        this.updateCraftingList();
    }

    public int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return this.sides;
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.getProxy().isActive()) {
            if (this.craftingList.isEmpty()) {
                for (int i = 0; i < this.patterns.func_70302_i_(); ++i) {
                    ICraftingPatternDetails pattern;
                    ItemStack stack = this.patterns.func_70301_a(i);
                    if (stack == null || !(stack.func_77973_b() instanceof ICraftingPatternItem) || (pattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)) == null || !pattern.isCraftable()) continue;
                    this.craftingList.add(pattern);
                }
            }
            for (ICraftingPatternDetails details : this.craftingList) {
                craftingTracker.addCraftingOption((ICraftingMedium)this, details);
            }
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (!this.isBusy() && this.getProxy().isActive() && this.craftingList.contains(patternDetails) && !this.hasItemsToPush()) {
            EnumSet<ForgeDirection> possibleDirections = EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN));
            for (ForgeDirection direction : possibleDirections) {
                ICraftingMachine cm;
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
                if (te instanceof IInterfaceHost) {
                    try {
                        if (this.sameGrid(this.getGridFromInterface(((IInterfaceHost)te).getInterfaceDuality()))) {
                        }
                    }
                    catch (GridAccessException e) {}
                    continue;
                }
                if (te instanceof ICraftingMachine && (cm = (ICraftingMachine)te).acceptsPlans()) {
                    if (!cm.pushPattern(patternDetails, table, direction.getOpposite())) continue;
                    this.setWorkStart(patternDetails);
                    return true;
                }
                InventoryAdaptor ad = InventoryAdaptor.getAdaptor((Object)te, (ForgeDirection)direction.getOpposite());
                if (ad == null || !this.acceptsItems(ad, table)) continue;
                for (int x = 0; x < table.func_70302_i_(); ++x) {
                    ItemStack is = table.func_70301_a(x);
                    if (is == null) continue;
                    ItemStack added = ad.addItems(is);
                    this.addToSendList(added);
                }
                this.pushItemsOut(possibleDirections);
                this.setWorkStart(patternDetails);
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.hasItemsToPush();
    }

    public void getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        if (this.hasItemsToPush()) {
            for (ItemStack stack : this.waitingToSend) {
                if (stack == null) continue;
                drops.add(stack);
            }
        }
        for (int i = 0; i < this.ejectInv.func_70302_i_(); ++i) {
            ItemStack stack;
            stack = this.ejectInv.func_70301_a(i);
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    public AppEngInternalInventory getGirdInventory() {
        return this.gridInv;
    }

    public AppEngInternalInventory getPatternInventory() {
        return this.patterns;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public boolean canInsert(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        try {
            IAEItemStack out = (IAEItemStack)this.getProxy().getStorage().getItemInventory().injectItems((IAEStack)AEApi.instance().storage().createItemStack(stack), Actionable.SIMULATE, (BaseActionSource)this.source);
            if (out == null) {
                return true;
            }
            return out.getStackSize() != (long)stack.field_77994_a;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public NBTTagCompound writeToNBT_TilePatternInterface(NBTTagCompound data) {
        this.patterns.writeToNBT(data, "patterns");
        this.ejectInv.writeToNBT(data, "ejectInv");
        NBTTagList waitingToSend = new NBTTagList();
        if (this.waitingToSend != null) {
            for (ItemStack is : this.waitingToSend) {
                NBTTagCompound item = new NBTTagCompound();
                is.func_77955_b(item);
                waitingToSend.func_74742_a((NBTBase)item);
            }
        }
        data.func_74782_a("waitingToSend", (NBTBase)waitingToSend);
        return data;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TilePatternInterface(NBTTagCompound data) {
        this.waitingToSend = null;
        NBTTagList waitingList = data.func_150295_c("waitingToSend", 10);
        if (waitingList != null) {
            for (int x = 0; x < waitingList.func_74745_c(); ++x) {
                NBTTagCompound c = waitingList.func_150305_b(x);
                if (c == null) continue;
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)c);
                this.addToSendList(is);
            }
        }
        this.patterns.readFromNBT(data, "patterns");
        this.ejectInv.readFromNBT(data, "ejectInv");
        this.updateCraftingList();
    }

    private boolean hasItemsToPush() {
        return this.waitingToSend != null && !this.waitingToSend.isEmpty();
    }

    public boolean canPutPattern(ItemStack result) {
        if (result == null) {
            return false;
        }
        for (int i = 0; i < this.patterns.func_70302_i_(); ++i) {
            ICraftingPatternDetails pattern;
            ItemStack stack = this.patterns.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ICraftingPatternItem) || !result.func_77969_a((pattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)).getOutputs()[0].getItemStack())) continue;
            return false;
        }
        return IntStream.range(0, this.patterns.func_70302_i_()).anyMatch(slot -> this.patterns.func_70301_a(slot) == null);
    }

    public int putPattern(ItemStack pattern) {
        for (int i = 0; i < this.patterns.func_70302_i_(); ++i) {
            ItemStack stack = this.patterns.func_70301_a(i);
            if (stack != null) continue;
            this.patterns.func_70299_a(i, pattern);
            this.updateCraftingList();
            return i;
        }
        return -1;
    }

    public void updateCraftingList() {
        Boolean[] accountedFor = new Boolean[]{false, false, false, false, false, false, false, false, false};
        assert (accountedFor.length == this.patterns.func_70302_i_());
        if (!this.getProxy().isReady()) {
            return;
        }
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.patterns.func_70301_a(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (accountedFor[x].booleanValue()) continue;
            this.addToCraftingList(this.patterns.func_70301_a(x));
        }
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void cancelWork(int recipeIndex) {
        IAEItemStack result = this.getResultStack(recipeIndex);
        if (result != null) {
            this.workStarted[recipeIndex] = false;
            try {
                ICraftingGrid cg = this.getProxy().getCrafting();
                ImmutableSet cpuSet = cg.getCpus();
                block2: for (ICraftingCPU cpu : cpuSet) {
                    if (!(cpu instanceof CraftingCPUCluster)) continue;
                    CraftingCPUCluster cluster = (CraftingCPUCluster)cpu;
                    IItemList pendingList = AEApi.instance().storage().createItemList();
                    cluster.getListOfItem(pendingList, CraftingItemList.PENDING);
                    for (IAEItemStack pendingStack : pendingList) {
                        if (!pendingStack.isSameType(result)) continue;
                        cluster.cancel();
                        continue block2;
                    }
                }
            }
            catch (GridAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void addToCraftingList(ItemStack is) {
        ICraftingPatternItem cpi;
        ICraftingPatternDetails details;
        if (is == null) {
            return;
        }
        if (is.func_77973_b() instanceof ICraftingPatternItem && (details = (cpi = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.field_145850_b)) != null) {
            if (this.craftingList == null) {
                this.craftingList = new LinkedList<ICraftingPatternDetails>();
            }
            this.craftingList.add(details);
        }
    }

    private void addToSendList(ItemStack is) {
        if (is == null) {
            return;
        }
        if (this.waitingToSend == null) {
            this.waitingToSend = new LinkedList<ItemStack>();
        }
        this.waitingToSend.add(is);
        try {
            this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private boolean acceptsItems(InventoryAdaptor ad, InventoryCrafting table) {
        for (int x = 0; x < table.func_70302_i_(); ++x) {
            ItemStack is = table.func_70301_a(x);
            if (is == null || ad.simulateAdd(is.func_77946_l()) == null) continue;
            return false;
        }
        return true;
    }

    private void pushItemsOut(EnumSet<ForgeDirection> possibleDirections) {
        if (!this.hasItemsToPush()) {
            return;
        }
        Iterator<ItemStack> i = this.waitingToSend.iterator();
        while (i.hasNext()) {
            ItemStack whatToSend = i.next();
            for (ForgeDirection s : possibleDirections) {
                InventoryAdaptor ad;
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + s.offsetX, this.field_145848_d + s.offsetY, this.field_145849_e + s.offsetZ);
                if (te == null || (ad = InventoryAdaptor.getAdaptor((Object)te, (ForgeDirection)s.getOpposite())) == null) continue;
                ItemStack Result = ad.addItems(whatToSend);
                if (Result == null) {
                    whatToSend = null;
                } else {
                    whatToSend.field_77994_a -= whatToSend.field_77994_a - Result.field_77994_a;
                }
                if (whatToSend != null) continue;
                break;
            }
            if (whatToSend != null) continue;
            i.remove();
        }
        if (this.waitingToSend.isEmpty()) {
            this.waitingToSend = null;
        }
    }

    private boolean hasItemToSend() {
        for (int i = 0; i < this.ejectInv.func_70302_i_(); ++i) {
            ItemStack stack = this.ejectInv.func_70301_a(i);
            if (stack == null) continue;
            return true;
        }
        return false;
    }

    private void ejectItems() {
        for (int i = 0; i < this.ejectInv.func_70302_i_(); ++i) {
            if (this.ejectInv.func_70301_a(i) == null) continue;
            ItemStack stack = this.ejectInv.func_70301_a(i);
            int itemCount = stack.field_77994_a;
            InventoryAdaptor adaptor = this.getAdaptor(i);
            ItemStack canExtract = adaptor.simulateRemove(itemCount, stack, null);
            if (canExtract == null || canExtract.field_77994_a != itemCount) continue;
            try {
                IMEMonitor inv = this.getProxy().getStorage().getItemInventory();
                IEnergyGrid energy = this.getProxy().getEnergy();
                IAEItemStack aeStack = AEApi.instance().storage().createItemStack(stack);
                if (aeStack == null) continue;
                IAEItemStack failed = (IAEItemStack)Platform.poweredInsert((IEnergySource)energy, (IMEInventory)inv, (IAEStack)aeStack, (BaseActionSource)this.source);
                if (failed != null) {
                    itemCount = (int)((long)itemCount - failed.getStackSize());
                }
                if (itemCount == 0) continue;
                ItemStack removed = adaptor.removeItems(itemCount, null, null);
                if (removed == null) {
                    throw new IllegalStateException("bad attempt at managing inventory. ( removeItems )");
                }
                if (removed.field_77994_a == itemCount) continue;
                throw new IllegalStateException("bad attempt at managing inventory. ( removeItems )");
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private InventoryAdaptor getAdaptor(int slot) {
        return new AdaptorIInventory(this.slotInv.getWrapper(slot));
    }

    private boolean hasWorks() {
        for (int i = 0; i < this.patterns.func_70302_i_(); ++i) {
            if (this.patterns.func_70301_a(i) == null) continue;
            return true;
        }
        return false;
    }

    private void setWorkStart(ICraftingPatternDetails pattern) {
        for (int i = 0; i < this.patterns.func_70302_i_(); ++i) {
            ICraftingPatternDetails currentPattern;
            ItemStack stack = this.patterns.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ICraftingPatternItem) || (currentPattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)) == null || !currentPattern.equals(pattern)) continue;
            this.workStarted[i] = true;
        }
    }

    private boolean hasWorkFinished() {
        for (int i = 0; i < this.patterns.func_70302_i_(); ++i) {
            IAEItemStack what;
            ICraftingPatternDetails currentPattern;
            ItemStack stack = this.patterns.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ICraftingPatternItem) || (currentPattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)) == null) continue;
            IAEItemStack iAEItemStack = what = currentPattern.getOutputs().length > 0 ? currentPattern.getOutputs()[0] : null;
            if (!this.isNotRequesting(what) || !this.workStarted[i]) continue;
            return true;
        }
        return false;
    }

    private void updateWorks() {
        for (int i = 0; i < this.patterns.func_70302_i_(); ++i) {
            IAEItemStack what = this.getResultStack(i);
            if (!this.isNotRequesting(what) || !this.workStarted[i]) continue;
            this.patterns.func_70299_a(i, null);
            this.workStarted[i] = false;
            this.updateCraftingList();
        }
    }

    private boolean isNotRequesting(IAEItemStack stack) {
        if (stack == null) {
            return true;
        }
        try {
            ICraftingGrid cg = this.getProxy().getCrafting();
            ImmutableSet cpuSet = cg.getCpus();
            IItemList pendingList = AEApi.instance().storage().createItemList();
            for (ICraftingCPU cpu : cpuSet) {
                if (!(cpu instanceof CraftingCPUCluster)) continue;
                CraftingCPUCluster cluster = (CraftingCPUCluster)cpu;
                cluster.getListOfItem(pendingList, CraftingItemList.PENDING);
            }
            for (IAEItemStack pendingStack : pendingList) {
                if (!pendingStack.isSameType(stack)) continue;
                return false;
            }
        }
        catch (GridAccessException e) {
            e.printStackTrace();
        }
        return true;
    }

    private IAEItemStack getResultStack(int pattern) {
        ICraftingPatternDetails currentPattern;
        ItemStack stack = this.patterns.func_70301_a(pattern);
        if (stack != null && stack.func_77973_b() instanceof ICraftingPatternItem && (currentPattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)) != null) {
            return currentPattern.getOutputs().length > 0 ? currentPattern.getOutputs()[0] : null;
        }
        return null;
    }

    public void gridChanged() {
        this.notifyNeighbors();
    }

    private boolean sameGrid(IGrid grid) throws GridAccessException {
        return grid == this.getProxy().getGrid();
    }

    private IGrid getGridFromInterface(DualityInterface iface) {
        return (IGrid)ReflectionHelper.getPrivateValue(DualityInterface.class, (Object)iface, (String[])new String[]{"gridProxy"});
    }
}

