/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.utils;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.me.ItemRepo;
import appeng.util.item.AEItemStack;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.nei.NEECraftingHelper;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketCraftingRequest;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.Ingredient;
import com.glodblock.github.client.gui.GuiFCBaseMonitor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.p455w0rd.wirelesscraftingterminal.client.gui.GuiWirelessCraftingTerminal;

public class IngredientTracker {
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final GuiContainer termGui;
    private List<ItemStack> requireStacks;
    private final int recipeIndex;
    private int currentIndex = 0;

    public IngredientTracker(GuiContainer termGui, IRecipeHandler recipe, int recipeIndex) {
        this.termGui = termGui;
        this.recipeIndex = recipeIndex;
        for (PositionedStack requiredIngredient : recipe.getIngredientStacks(recipeIndex)) {
            Ingredient ingredient = new Ingredient(requiredIngredient);
            this.ingredients.add(ingredient);
        }
        for (Ingredient ingredient : this.ingredients) {
            for (IAEItemStack stack : this.getCraftableStacks()) {
                if (!ingredient.getIngredient().contains(stack.getItemStack())) continue;
                ingredient.setCraftableIngredient(stack.getItemStack());
            }
        }
        this.calculateIngredients();
    }

    public IngredientTracker(GuiRecipe guiRecipe, IRecipeHandler recipe, int recipeIndex) {
        this.termGui = guiRecipe.firstGui;
        this.recipeIndex = recipeIndex;
        this.getCraftableStacks();
        for (PositionedStack requiredIngredient : recipe.getIngredientStacks(recipeIndex)) {
            Ingredient ingredient = new Ingredient(requiredIngredient);
            this.ingredients.add(ingredient);
        }
        for (Ingredient ingredient : this.ingredients) {
            for (IAEItemStack stack : this.getCraftableStacks()) {
                if (!ingredient.getIngredient().contains(stack.getItemStack())) continue;
                ingredient.setCraftableIngredient(stack.getItemStack());
            }
        }
    }

    private ItemRepo getRepo() throws IllegalAccessException {
        if (GuiUtils.isFluidCraftPatternTerm((GuiScreen)this.termGui)) {
            return (ItemRepo)ReflectionHelper.findField(GuiFCBaseMonitor.class, (String[])new String[]{"repo"}).get(this.termGui);
        }
        return (ItemRepo)ReflectionHelper.findField(GuiMEMonitorable.class, (String[])new String[]{"repo"}).get(this.termGui);
    }

    private List<IAEItemStack> getCraftableStacks() {
        ArrayList<IAEItemStack> craftableStacks = new ArrayList<IAEItemStack>();
        if (this.termGui != null) {
            IItemList list = null;
            try {
                ItemRepo repo;
                if (!GuiUtils.isGuiWirelessCrafting((GuiScreen)this.termGui)) {
                    repo = this.getRepo();
                    list = (IItemList)ReflectionHelper.findField(ItemRepo.class, (String[])new String[]{"list"}).get(repo);
                } else {
                    repo = (ItemRepo)ReflectionHelper.findField(GuiWirelessCraftingTerminal.class, (String[])new String[]{"repo"}).get(this.termGui);
                    list = (IItemList)ReflectionHelper.findField(ItemRepo.class, (String[])new String[]{"list"}).get(repo);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (list != null) {
                for (IAEItemStack stack : list) {
                    if (!stack.isCraftable()) continue;
                    craftableStacks.add(stack.copy());
                }
            }
        }
        return craftableStacks;
    }

    private List<IAEItemStack> getStorageStacks() {
        ArrayList<IAEItemStack> list = new ArrayList<IAEItemStack>();
        if (this.termGui != null) {
            try {
                if (!GuiUtils.isGuiWirelessCrafting((GuiScreen)this.termGui)) {
                    ItemRepo repo = (ItemRepo)ReflectionHelper.findField(GuiMEMonitorable.class, (String[])new String[]{"repo"}).get(this.termGui);
                    for (IAEItemStack stack : (IItemList)ReflectionHelper.findField(ItemRepo.class, (String[])new String[]{"list"}).get(repo)) {
                        list.add(stack.copy());
                    }
                } else {
                    ItemRepo repo = (ItemRepo)ReflectionHelper.findField(GuiWirelessCraftingTerminal.class, (String[])new String[]{"repo"}).get(this.termGui);
                    for (IAEItemStack stack : (IItemList)ReflectionHelper.findField(ItemRepo.class, (String[])new String[]{"list"}).get(repo)) {
                        list.add(stack.copy());
                    }
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public List<ItemStack> getRequireToCraftStacks() {
        ArrayList<ItemStack> requireToCraftStacks = new ArrayList<ItemStack>();
        for (Ingredient ingredient : this.getIngredients()) {
            boolean find = false;
            if (!ingredient.isCraftable() || !ingredient.requiresToCraft()) continue;
            for (ItemStack stack : requireToCraftStacks) {
                boolean areStackEqual = stack.func_77969_a(ingredient.getCraftableIngredient()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)ingredient.getCraftableIngredient());
                if (!areStackEqual) continue;
                stack.field_77994_a = (int)((long)stack.field_77994_a + ingredient.getMissingCount());
                find = true;
            }
            if (find) continue;
            ItemStack requireStack = ingredient.getCraftableIngredient().func_77946_l();
            requireStack.field_77994_a = (int)ingredient.getMissingCount();
            requireToCraftStacks.add(requireStack);
        }
        return requireToCraftStacks;
    }

    public List<ItemStack> getRequireStacks() {
        return this.requireStacks;
    }

    public boolean hasNext() {
        return this.currentIndex < this.getRequireStacks().size();
    }

    public void requestNextIngredient() {
        AEItemStack stack = AEItemStack.create((ItemStack)this.getRequiredStack(this.currentIndex));
        if (stack != null) {
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketCraftingRequest((IAEItemStack)stack, NEECraftingHelper.noPreview));
        }
        ++this.currentIndex;
    }

    public ItemStack getRequiredStack(int index) {
        return this.getRequireStacks().get(index);
    }

    public int getRecipeIndex() {
        return this.recipeIndex;
    }

    public void addAvailableStack(ItemStack stack) {
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.requiresToCraft()) continue;
            if (NEEConfig.matchOtherItems) {
                if (stack.field_77994_a <= 0 || !ingredient.getIngredient().contains(stack)) continue;
                int missingCount = (int)ingredient.getMissingCount();
                ingredient.addCount(stack.field_77994_a);
                if (ingredient.requiresToCraft()) {
                    stack.field_77994_a = 0;
                    break;
                }
                stack.field_77994_a -= missingCount;
                break;
            }
            ItemStack craftableStack = ingredient.getCraftableIngredient();
            if (craftableStack == null || !craftableStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)craftableStack, (ItemStack)stack) || stack.field_77994_a <= 0) continue;
            int missingCount = (int)ingredient.getMissingCount();
            ingredient.addCount(stack.field_77994_a);
            if (ingredient.requiresToCraft()) {
                stack.field_77994_a = 0;
                break;
            }
            stack.field_77994_a -= missingCount;
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void calculateIngredients() {
        void var3_6;
        List<IAEItemStack> stacks = NEEConfig.matchOtherItems ? this.getStorageStacks() : this.getCraftableStacks();
        for (Ingredient ingredient : this.ingredients) {
            for (IAEItemStack stack : stacks) {
                if (!ingredient.getIngredient().contains(stack.getItemStack()) || stack.getStackSize() <= 0L) continue;
                ingredient.addCount(stack.getStackSize());
                if (ingredient.requiresToCraft()) {
                    stack.setStackSize(0L);
                    continue;
                }
                stack.setStackSize(stack.getStackSize() - ingredient.getRequireCount());
            }
        }
        ArrayList<ItemStack> inventoryStacks = new ArrayList<ItemStack>();
        for (Slot slot : this.termGui.field_147002_h.field_75151_b) {
            boolean canGetStack = slot != null && slot.func_75216_d() && slot.func_75211_c().field_77994_a > 0 && slot.func_75214_a(slot.func_75211_c()) && slot.func_82869_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (!canGetStack) continue;
            inventoryStacks.add(slot.func_75211_c().func_77946_l());
        }
        boolean bl = false;
        while (var3_6 < this.getIngredients().size()) {
            for (ItemStack stack : inventoryStacks) {
                this.addAvailableStack(stack);
            }
            ++var3_6;
        }
        this.requireStacks = this.getRequireToCraftStacks();
    }
}

