/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.processor;

import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.processor.AppengRecipeProcessor;
import com.github.vfyjxf.nee.processor.AvaritiaRecipeProcessor;
import com.github.vfyjxf.nee.processor.BloodMagicRecipeProcessor;
import com.github.vfyjxf.nee.processor.BuildCraftRecipeProcessor;
import com.github.vfyjxf.nee.processor.EnderIORecipeProcessor;
import com.github.vfyjxf.nee.processor.ForestryRecipeProcessor;
import com.github.vfyjxf.nee.processor.GTPPRecipeProcessor;
import com.github.vfyjxf.nee.processor.GoodGeneratorRecipeProcessor;
import com.github.vfyjxf.nee.processor.GregTech5RecipeProcessor;
import com.github.vfyjxf.nee.processor.GregTech6RecipeProcessor;
import com.github.vfyjxf.nee.processor.ICRecipeProcessor;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import com.github.vfyjxf.nee.processor.ImmersiveEngineeringRecipeProcessor;
import com.github.vfyjxf.nee.processor.MekanismRecipeProcessor;
import com.github.vfyjxf.nee.processor.TCNEIPluginRecipeProcessor;
import com.github.vfyjxf.nee.processor.ThermalExpansionRecipeProcessor;
import com.github.vfyjxf.nee.processor.VanillaRecipeProcessor;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;

public class RecipeProcessor {
    public static final String NULL_IDENTIFIER = "null";
    public static List<IRecipeProcessor> recipeProcessors = new ArrayList<IRecipeProcessor>();

    public static void init() {
        NotEnoughEnergistics.logger.info("-----Not Enough Energistics Init Start-----");
        NotEnoughEnergistics.logger.info("Install Vanilla Support");
        recipeProcessors.add(new VanillaRecipeProcessor());
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            NotEnoughEnergistics.logger.info("Found Applied Energistics 2,install Applied Energistics 2 support");
            recipeProcessors.add(new AppengRecipeProcessor());
        }
        if (Loader.isModLoaded((String)"gregtech") && !Loader.isModLoaded((String)"gregapi")) {
            NotEnoughEnergistics.logger.info("Found GregTech5,install GregTech5 support");
            recipeProcessors.add(new GregTech5RecipeProcessor());
        }
        if (Loader.isModLoaded((String)"gregapi") && Loader.isModLoaded((String)"gregapi_post")) {
            NotEnoughEnergistics.logger.info("Found GregTech6,install GregTech6 support");
            recipeProcessors.add(new GregTech6RecipeProcessor());
        }
        if (Loader.isModLoaded((String)"IC2")) {
            NotEnoughEnergistics.logger.info("Found IC2,install IC2 Support");
            recipeProcessors.add(new ICRecipeProcessor());
        }
        if (Loader.isModLoaded((String)"Avaritia")) {
            NotEnoughEnergistics.logger.info("Found Avaritia, install Avaritia support");
            recipeProcessors.add(new AvaritiaRecipeProcessor());
        }
        if (Loader.isModLoaded((String)"EnderIO")) {
            NotEnoughEnergistics.logger.info("Found EnderIO, install EnderIO support");
            recipeProcessors.add(new EnderIORecipeProcessor());
        }
        if (Loader.isModLoaded((String)"Forestry")) {
            NotEnoughEnergistics.logger.info("Found Forestry, install Forestry support");
            recipeProcessors.add(new ForestryRecipeProcessor());
        }
        if (Loader.isModLoaded((String)"thaumcraftneiplugin")) {
            NotEnoughEnergistics.logger.info("Found TCNEIPlugin, install TCNEIPlugin support");
            recipeProcessors.add(new TCNEIPluginRecipeProcessor());
        }
        if (Loader.isModLoaded((String)"ThermalExpansion")) {
            NotEnoughEnergistics.logger.info("Found ThermalExpansion, install ThermalExpansion support");
            recipeProcessors.add(new ThermalExpansionRecipeProcessor());
        }
        if (Loader.isModLoaded((String)"ImmersiveEngineering")) {
            NotEnoughEnergistics.logger.info("Found ImmersiveEngineering, install ImmersiveEngineering support");
            recipeProcessors.add(new ImmersiveEngineeringRecipeProcessor());
        }
        if (Loader.isModLoaded((String)"Mekanism")) {
            NotEnoughEnergistics.logger.info("Found Mekanism, install Mekanism support");
            recipeProcessors.add(new MekanismRecipeProcessor());
        }
        if (Loader.isModLoaded((String)"AWWayofTime")) {
            NotEnoughEnergistics.logger.info("Found BloodMagic, install BloodMagic support");
            recipeProcessors.add(new BloodMagicRecipeProcessor());
        }
        if (Loader.isModLoaded((String)"BuildCraft|Compat")) {
            NotEnoughEnergistics.logger.info("Found BuildCraft-Compat, install BuildCraft-Compat support");
            recipeProcessors.add(new BuildCraftRecipeProcessor());
        }
        if (Loader.isModLoaded((String)"miscutils")) {
            NotEnoughEnergistics.logger.info("Found GT++, install GT++ support");
            recipeProcessors.add(new GTPPRecipeProcessor());
        }
        if (Loader.isModLoaded((String)"GoodGenerator")) {
            NotEnoughEnergistics.logger.info("Found Good Generator, install Good Generator support");
            recipeProcessors.add(new GoodGeneratorRecipeProcessor());
        }
        NotEnoughEnergistics.logger.info("-----Not Enough Energistics Init  Finished-----");
    }
}

