/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.processor;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import gregtech.api.enums.ItemList;
import gregtech.api.util.GT_Recipe;
import gregtech.nei.GT_NEI_DefaultHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GregTech5RecipeProcessor
implements IRecipeProcessor {
    private static final Class<?> gtDefaultClz;
    private static final Class<?> gtAssLineClz;

    public static FluidStack getFluidFromDisplayStack(ItemStack aDisplayStack) {
        if (!GregTech5RecipeProcessor.isStackValid(aDisplayStack) || aDisplayStack.func_77973_b() != ItemList.Display_Fluid.getItem() || !aDisplayStack.func_77942_o()) {
            return null;
        }
        Fluid tFluid = FluidRegistry.getFluid((int)ItemList.Display_Fluid.getItem().getDamage(aDisplayStack));
        return new FluidStack(tFluid, (int)aDisplayStack.func_77978_p().func_74763_f("mFluidDisplayAmount"));
    }

    public static boolean isStackValid(Object aStack) {
        return aStack instanceof ItemStack && ((ItemStack)aStack).func_77973_b() != null && ((ItemStack)aStack).field_77994_a >= 0;
    }

    @Override
    @Nonnull
    public Set<String> getAllOverlayIdentifier() {
        HashSet<String> identifiers = new HashSet<String>();
        for (GT_Recipe.GT_Recipe_Map tMap : GT_Recipe.GT_Recipe_Map.sMappings) {
            if (!tMap.mNEIAllowed) continue;
            identifiers.add(tMap.mNEIName);
        }
        identifiers.add("gt.recipe.fakeAssemblylineProcess");
        return identifiers;
    }

    @Override
    @Nonnull
    public String getRecipeProcessorId() {
        return "GregTech5";
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeInput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeInputs = new ArrayList<PositionedStack>();
        if (gtDefaultClz.isInstance(recipe) || gtAssLineClz.isInstance(recipe)) {
            ItemStack specialItem;
            recipeInputs.addAll(recipe.getIngredientStacks(recipeIndex));
            recipeInputs.removeIf(positionedStack -> GregTech5RecipeProcessor.getFluidFromDisplayStack(positionedStack.items[0]) != null || positionedStack.item.field_77994_a == 0);
            if (!recipeInputs.isEmpty() && ((specialItem = ((PositionedStack)recipeInputs.get((int)(recipeInputs.size() - 1))).items[0]).func_77969_a(ItemList.Tool_DataStick.get(1L, new Object[0])) || specialItem.func_77969_a(ItemList.Tool_DataOrb.get(1L, new Object[0])) && (recipe.getRecipeName().equals("gt.recipe.scanner") || recipe.getRecipeName().equals("gt.recipe.fakeAssemblylineProcess")))) {
                recipeInputs.remove(recipeInputs.size() - 1);
            }
            return recipeInputs;
        }
        return recipeInputs;
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeOutput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeOutputs = new ArrayList<PositionedStack>();
        if (gtDefaultClz.isInstance(recipe) || gtAssLineClz.isInstance(recipe)) {
            recipeOutputs.addAll(recipe.getOtherStacks(recipeIndex));
            recipeOutputs.removeIf(positionedStack -> GregTech5RecipeProcessor.getFluidFromDisplayStack(positionedStack.items[0]) != null);
            recipeOutputs.removeIf(stack -> stack instanceof GT_NEI_DefaultHandler.FixedPositionedStack && ((GT_NEI_DefaultHandler.FixedPositionedStack)stack).mChance != 10000 && ((GT_NEI_DefaultHandler.FixedPositionedStack)stack).mChance > 0);
            return recipeOutputs;
        }
        return recipeOutputs;
    }

    @Override
    public boolean mergeStacks(IRecipeHandler recipe, int recipeIndex, String identifier) {
        return !"gt.recipe.fakeAssemblylineProcess".equals(identifier);
    }

    static {
        Class<?> gtDH = null;
        Class<?> gtAL = null;
        try {
            gtDH = Class.forName("gregtech.nei.GT_NEI_DefaultHandler");
            gtAL = Class.forName("gregtech.nei.GT_NEI_AssLineHandler");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        gtDefaultClz = gtDH;
        gtAssLineClz = gtAL;
    }
}

