/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerPatternTerm;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class PacketStackCountChange
implements IMessage {
    private int slotIndex;
    private int changeCount;

    public PacketStackCountChange() {
    }

    public PacketStackCountChange(int slotIndex, int changeCount) {
        this.slotIndex = slotIndex;
        this.changeCount = changeCount;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public void fromBytes(ByteBuf buf) {
        this.slotIndex = buf.readInt();
        this.changeCount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slotIndex);
        buf.writeInt(this.changeCount);
    }

    public static final class Handler
    implements IMessageHandler<PacketStackCountChange, IMessage> {
        public IMessage onMessage(PacketStackCountChange message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container instanceof AEBaseContainer) {
                this.handleMessage(message, container);
            }
            return null;
        }

        private void handleMessage(PacketStackCountChange message, Container container) {
            if (container instanceof ContainerPatternTerm && ((ContainerPatternTerm)container).isCraftingMode()) {
                return;
            }
            Slot currentSlot = container.func_75139_a(message.getSlotIndex());
            for (int i = 0; i < Math.abs(message.getChangeCount()); ++i) {
                int currentStackSize;
                int n = currentStackSize = message.getChangeCount() > 0 ? currentSlot.func_75211_c().field_77994_a + 1 : currentSlot.func_75211_c().field_77994_a - 1;
                if (currentStackSize > currentSlot.func_75211_c().func_77976_d() || currentStackSize <= 0) break;
                ItemStack nextStack = currentSlot.func_75211_c().func_77946_l();
                nextStack.field_77994_a = currentStackSize;
                currentSlot.func_75215_d(nextStack);
            }
        }
    }
}

