/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.utils;

import codechicken.nei.PositionedStack;
import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import com.github.vfyjxf.nee.processor.RecipeProcessor;
import com.github.vfyjxf.nee.utils.StackProcessor;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public final class ItemUtils {
    public static Gson gson = new Gson();
    public static List<StackProcessor> transformItemBlacklist = ItemUtils.getTransformItemBlacklist();
    public static List<StackProcessor> transformItemPriorityList = ItemUtils.getTransformItemPriorityList();

    public static void reloadConfig() {
        transformItemBlacklist = ItemUtils.getTransformItemBlacklist();
        transformItemPriorityList = ItemUtils.getTransformItemPriorityList();
    }

    public static List<StackProcessor> getTransformItemBlacklist() {
        ArrayList<StackProcessor> transformItemBlacklist = new ArrayList<StackProcessor>();
        for (String itemJsonString : NEEConfig.transformBlacklist) {
            ItemStack currentStack;
            Item currentItem;
            StackProcessor processor;
            try {
                processor = (StackProcessor)gson.fromJson(itemJsonString, StackProcessor.class);
            }
            catch (JsonSyntaxException e) {
                NotEnoughEnergistics.logger.error("Found a error item json in item blacklist: " + itemJsonString);
                continue;
            }
            if (processor == null || (currentItem = GameRegistry.findItem((String)processor.modid, (String)processor.name)) == null) continue;
            ItemStack itemStack = currentStack = processor.meta != null ? new ItemStack(currentItem, 1, Integer.parseInt(processor.meta)) : new ItemStack(currentItem);
            if (processor.nbt != null) {
                NBTTagCompound nbt = null;
                try {
                    nbt = (NBTTagCompound)JsonToNBT.func_150315_a((String)processor.nbt);
                }
                catch (NBTException e) {
                    e.printStackTrace();
                }
                if (nbt != null) {
                    currentStack.func_77982_d(nbt);
                }
            }
            transformItemBlacklist.add(new StackProcessor(currentStack, currentItem, processor.recipeProcessor, processor.identifier));
        }
        return transformItemBlacklist;
    }

    public static List<StackProcessor> getTransformItemPriorityList() {
        ArrayList<StackProcessor> transformItemPriorityList = new ArrayList<StackProcessor>();
        for (String itemJsonString : NEEConfig.transformPriorityList) {
            ItemStack currentStack;
            Item currentItem;
            StackProcessor processor;
            try {
                processor = (StackProcessor)gson.fromJson(itemJsonString, StackProcessor.class);
            }
            catch (JsonSyntaxException e) {
                NotEnoughEnergistics.logger.error("Found a error item json in item priority list: " + itemJsonString);
                continue;
            }
            if (processor == null || (currentItem = GameRegistry.findItem((String)processor.modid, (String)processor.name)) == null) continue;
            ItemStack itemStack = currentStack = processor.meta != null ? new ItemStack(currentItem, 1, Integer.parseInt(processor.meta)) : new ItemStack(currentItem);
            if (processor.nbt != null) {
                NBTTagCompound nbt = null;
                try {
                    nbt = (NBTTagCompound)JsonToNBT.func_150315_a((String)processor.nbt);
                }
                catch (NBTException e) {
                    e.printStackTrace();
                }
                if (nbt != null) {
                    currentStack.func_77982_d(nbt);
                }
            }
            transformItemPriorityList.add(new StackProcessor(currentStack, currentItem, processor.recipeProcessor, processor.identifier));
        }
        return transformItemPriorityList;
    }

    public static boolean isPreferItems(ItemStack itemStack, String recipeProcessor, String identifier) {
        for (StackProcessor processor : transformItemPriorityList) {
            ItemStack copyStack = itemStack.func_77946_l();
            copyStack.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)copyStack, (ItemStack)processor.itemStack)) continue;
            if (processor.recipeProcessor == null && processor.identifier == null) {
                return true;
            }
            if (processor.recipeProcessor == null) {
                return identifier.equals(processor.identifier);
            }
            if (processor.identifier == null) {
                return recipeProcessor.equals(processor.recipeProcessor);
            }
            return recipeProcessor.equals(processor.recipeProcessor) && identifier.equals(processor.identifier);
        }
        return false;
    }

    public static boolean isPreferItems(ItemStack itemStack) {
        for (StackProcessor processor : transformItemPriorityList) {
            ItemStack copyStack = itemStack.func_77946_l();
            copyStack.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)copyStack, (ItemStack)processor.itemStack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInBlackList(ItemStack itemStack, String recipeProcessor, String identifier) {
        for (StackProcessor processor : transformItemBlacklist) {
            ItemStack copyStack = itemStack.func_77946_l();
            copyStack.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)copyStack, (ItemStack)processor.itemStack)) continue;
            if (processor.recipeProcessor == null && processor.identifier == null) {
                return true;
            }
            if (processor.recipeProcessor == null) {
                return identifier.equals(processor.identifier);
            }
            if (processor.identifier == null) {
                return recipeProcessor.equals(processor.recipeProcessor);
            }
            return recipeProcessor.equals(processor.recipeProcessor) && identifier.equals(processor.identifier);
        }
        return false;
    }

    public static ItemStack getPreferModItem(ItemStack[] items) {
        for (String currentId : NEEConfig.transformPriorityModList) {
            for (ItemStack stack : items) {
                GameRegistry.UniqueIdentifier itemId = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
                if (!itemId.modId.equals(currentId)) continue;
                return stack;
            }
        }
        return null;
    }

    public static int getIngredientIndex(ItemStack stack, PositionedStack positionedStack) {
        ItemStack stackInput = stack.func_77946_l();
        stackInput.field_77994_a = 1;
        for (int i = 0; i < positionedStack.items.length; ++i) {
            ItemStack currentStack = positionedStack.items[i].func_77946_l();
            currentStack.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)currentStack, (ItemStack)stackInput)) continue;
            return i;
        }
        return -1;
    }

    public static String toItemJsonString(ItemStack stack) {
        GameRegistry.UniqueIdentifier identifier = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
        String nbtString = stack.func_77942_o() ? ",\"nbt\":" + stack.func_77978_p().toString() : "";
        int meta = stack.func_77960_j();
        return "{\"modid\":" + identifier.modId + ",\"name\":" + identifier.name + ",\"meta\":" + meta + nbtString + "}";
    }

    public static boolean hasRecipeProcessor(String processorId) {
        for (IRecipeProcessor processor : RecipeProcessor.recipeProcessors) {
            if (!processor.getRecipeProcessorId().equals(processorId)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOverlayIdentifier(String identifier) {
        for (IRecipeProcessor processor : RecipeProcessor.recipeProcessors) {
            for (String ident : processor.getAllOverlayIdentifier()) {
                if (!ident.equals(identifier)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasModId(String modid) {
        for (String currentId : NEEConfig.transformPriorityModList) {
            if (!currentId.equals(modid)) continue;
            return true;
        }
        return false;
    }
}

