/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.processor;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import forestry.factory.recipes.nei.NEIHandlerBottler;
import forestry.factory.recipes.nei.NEIHandlerCarpenter;
import forestry.factory.recipes.nei.NEIHandlerCentrifuge;
import forestry.factory.recipes.nei.NEIHandlerFabricator;
import forestry.factory.recipes.nei.NEIHandlerMoistener;
import forestry.factory.recipes.nei.NEIHandlerSqueezer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ForestryRecipeProcessor
implements IRecipeProcessor {
    @Override
    @Nonnull
    public String getRecipeProcessorId() {
        return "Forestry";
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeInput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        if (recipe instanceof NEIHandlerBottler) {
            return this.bottlerHandler((NEIHandlerBottler)recipe, recipeIndex, true);
        }
        if (recipe instanceof NEIHandlerCarpenter) {
            return this.carpenterHandler((NEIHandlerCarpenter)recipe, recipeIndex, true);
        }
        if (recipe instanceof NEIHandlerCentrifuge) {
            return this.centrifugeHandler((NEIHandlerCentrifuge)recipe, recipeIndex, true);
        }
        if (recipe instanceof NEIHandlerFabricator) {
            return this.fabricatorHandler((NEIHandlerFabricator)recipe, recipeIndex, true);
        }
        if (recipe instanceof NEIHandlerMoistener) {
            return this.moistenerHandler((NEIHandlerMoistener)recipe, recipeIndex, true);
        }
        if (recipe instanceof NEIHandlerSqueezer) {
            return this.squeezerHandler((NEIHandlerSqueezer)recipe, recipeIndex, true);
        }
        return new ArrayList<PositionedStack>();
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeOutput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        if (recipe instanceof NEIHandlerBottler) {
            return this.bottlerHandler((NEIHandlerBottler)recipe, recipeIndex, false);
        }
        if (recipe instanceof NEIHandlerCarpenter) {
            return this.carpenterHandler((NEIHandlerCarpenter)recipe, recipeIndex, false);
        }
        if (recipe instanceof NEIHandlerCentrifuge) {
            return this.centrifugeHandler((NEIHandlerCentrifuge)recipe, recipeIndex, false);
        }
        if (recipe instanceof NEIHandlerFabricator) {
            return this.fabricatorHandler((NEIHandlerFabricator)recipe, recipeIndex, false);
        }
        if (recipe instanceof NEIHandlerMoistener) {
            return this.moistenerHandler((NEIHandlerMoistener)recipe, recipeIndex, false);
        }
        if (recipe instanceof NEIHandlerSqueezer) {
            return this.squeezerHandler((NEIHandlerSqueezer)recipe, recipeIndex, false);
        }
        return new ArrayList<PositionedStack>();
    }

    private List<PositionedStack> bottlerHandler(NEIHandlerBottler base, int recipeIndex, boolean getInput) {
        return getInput ? base.getIngredientStacks(recipeIndex) : Collections.singletonList(base.getResultStack(recipeIndex));
    }

    private List<PositionedStack> carpenterHandler(NEIHandlerCarpenter base, int recipeIndex, boolean getInput) {
        return getInput ? base.getIngredientStacks(recipeIndex) : Collections.singletonList(base.getResultStack(recipeIndex));
    }

    private List<PositionedStack> centrifugeHandler(NEIHandlerCentrifuge base, int recipeIndex, boolean getInput) {
        return getInput ? base.getIngredientStacks(recipeIndex) : base.getOtherStacks(recipeIndex);
    }

    private List<PositionedStack> fabricatorHandler(NEIHandlerFabricator base, int recipeIndex, boolean getInput) {
        ArrayList<PositionedStack> recipeInput = new ArrayList<PositionedStack>(base.getIngredientStacks(recipeIndex));
        recipeInput.addAll(base.getOtherStacks(recipeIndex));
        return getInput ? recipeInput : Collections.singletonList(base.getResultStack(recipeIndex));
    }

    private List<PositionedStack> moistenerHandler(NEIHandlerMoistener base, int recipeIndex, boolean getInput) {
        ArrayList<PositionedStack> recipeInput = new ArrayList<PositionedStack>(base.getIngredientStacks(recipeIndex));
        recipeInput.addAll(base.getOtherStacks(recipeIndex));
        return getInput ? recipeInput : Collections.singletonList(base.getResultStack(recipeIndex));
    }

    private List<PositionedStack> squeezerHandler(NEIHandlerSqueezer base, int recipeIndex, boolean getInput) {
        return getInput ? base.getIngredientStacks(recipeIndex) : Collections.singletonList(base.getResultStack(recipeIndex));
    }
}

