/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.implementations.ContainerPatternTermEx;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PacketNEIPatternRecipe
implements IMessage {
    NBTTagCompound input;
    NBTTagCompound output;

    public PacketNEIPatternRecipe() {
    }

    public PacketNEIPatternRecipe(@Nonnull NBTTagCompound input, NBTTagCompound output) {
        this.input = input;
        this.output = output;
    }

    public void fromBytes(ByteBuf buf) {
        this.input = ByteBufUtils.readTag((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.output = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.input);
        if (this.output != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.output);
        } else {
            buf.writeBoolean(false);
        }
    }

    private void craftingTableRecipeHandler(ContainerPatternTerm container, PacketNEIPatternRecipe message) {
        ItemStack[] recipeInput = new ItemStack[9];
        for (int i = 0; i < recipeInput.length; ++i) {
            NBTTagCompound currentStack = (NBTTagCompound)message.input.func_74781_a("#" + i);
            recipeInput[i] = currentStack == null ? null : ItemStack.func_77949_a((NBTTagCompound)currentStack);
        }
        ContainerPatternTerm cct = container;
        IGridNode node = cct.getNetworkNode();
        if (node != null) {
            IGrid grid = node.getGrid();
            if (grid == null) {
                return;
            }
            IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
            ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
            IInventory craftMatrix = cct.getInventoryByName("crafting");
            if (inv != null && message.input != null && security != null) {
                for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                    ItemStack currentItem = null;
                    if (recipeInput[i] != null) {
                        currentItem = recipeInput[i].func_77946_l();
                    }
                    craftMatrix.func_70299_a(i, currentItem);
                }
                container.func_75130_a(craftMatrix);
            }
        }
    }

    private void processRecipeHandler(ContainerPatternTerm container, PacketNEIPatternRecipe message) {
        NBTTagCompound currentStack;
        int i;
        ItemStack[] recipeInput = new ItemStack[9];
        ItemStack[] recipeOutput = new ItemStack[3];
        for (i = 0; i < recipeInput.length; ++i) {
            currentStack = (NBTTagCompound)message.input.func_74781_a("#" + i);
            recipeInput[i] = currentStack == null ? null : ItemStack.func_77949_a((NBTTagCompound)currentStack);
        }
        for (i = 0; i < recipeOutput.length; ++i) {
            currentStack = (NBTTagCompound)message.output.func_74781_a("Outputs" + i);
            recipeOutput[i] = currentStack == null ? null : ItemStack.func_77949_a((NBTTagCompound)currentStack);
        }
        ContainerPatternTerm cct = container;
        IGridNode node = cct.getNetworkNode();
        if (node != null) {
            IGrid grid = node.getGrid();
            if (grid == null) {
                return;
            }
            IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
            ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
            IInventory craftMatrix = cct.getInventoryByName("crafting");
            IInventory outputMatrix = cct.getInventoryByName("output");
            if (inv != null && message.input != null && security != null) {
                ItemStack currentItem;
                int i2;
                for (i2 = 0; i2 < craftMatrix.func_70302_i_(); ++i2) {
                    currentItem = null;
                    if (recipeInput[i2] != null) {
                        currentItem = recipeInput[i2].func_77946_l();
                    }
                    craftMatrix.func_70299_a(i2, currentItem);
                }
                for (i2 = 0; i2 < outputMatrix.func_70302_i_(); ++i2) {
                    currentItem = null;
                    if (recipeOutput[i2] != null) {
                        currentItem = recipeOutput[i2].func_77946_l();
                    }
                    outputMatrix.func_70299_a(i2, currentItem);
                }
                container.func_75130_a(craftMatrix);
            }
        }
    }

    private void processRecipeHandler(ContainerPatternTermEx container, PacketNEIPatternRecipe message) {
        NBTTagCompound currentStack;
        int i;
        ItemStack[] recipeInput = new ItemStack[16];
        ItemStack[] recipeOutput = new ItemStack[4];
        for (i = 0; i < recipeInput.length; ++i) {
            currentStack = (NBTTagCompound)message.input.func_74781_a("#" + i);
            recipeInput[i] = currentStack == null ? null : ItemStack.func_77949_a((NBTTagCompound)currentStack);
        }
        for (i = 0; i < recipeOutput.length; ++i) {
            currentStack = (NBTTagCompound)message.output.func_74781_a("Outputs" + i);
            recipeOutput[i] = currentStack == null ? null : ItemStack.func_77949_a((NBTTagCompound)currentStack);
        }
        ContainerPatternTermEx cct = container;
        IGridNode node = cct.getNetworkNode();
        if (node != null) {
            IGrid grid = node.getGrid();
            if (grid == null) {
                return;
            }
            IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
            ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
            IInventory craftMatrix = cct.getInventoryByName("crafting");
            IInventory outputMatrix = cct.getInventoryByName("output");
            if (inv != null && message.input != null && security != null) {
                ItemStack currentItem;
                int i2;
                for (i2 = 0; i2 < craftMatrix.func_70302_i_(); ++i2) {
                    currentItem = null;
                    if (recipeInput[i2] != null) {
                        currentItem = recipeInput[i2].func_77946_l();
                    }
                    craftMatrix.func_70299_a(i2, currentItem);
                }
                for (i2 = 0; i2 < recipeOutput.length; ++i2) {
                    currentItem = null;
                    if (recipeOutput[i2] != null) {
                        currentItem = recipeOutput[i2].func_77946_l();
                    }
                    outputMatrix.func_70299_a(i2, currentItem);
                }
                container.func_75130_a(craftMatrix);
            }
        }
    }

    public static final class Handler
    implements IMessageHandler<PacketNEIPatternRecipe, IMessage> {
        public IMessage onMessage(PacketNEIPatternRecipe message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container instanceof ContainerPatternTerm && message.output == null) {
                ((ContainerPatternTerm)container).getPatternTerminal().setCraftingRecipe(true);
                message.craftingTableRecipeHandler((ContainerPatternTerm)container, message);
            } else if (container instanceof ContainerPatternTerm) {
                ((ContainerPatternTerm)container).getPatternTerminal().setCraftingRecipe(false);
                message.processRecipeHandler((ContainerPatternTerm)container, message);
            } else if (container instanceof ContainerPatternTermEx && message.output != null) {
                ((ContainerPatternTermEx)container).getPatternTerminal().setInverted(false);
                message.processRecipeHandler((ContainerPatternTermEx)container, message);
            }
            return null;
        }
    }
}

