/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.nei;

import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.util.Platform;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.nei.NEECraftingHandler;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketOpenCraftAmount;
import com.github.vfyjxf.nee.network.packet.PacketValueConfigServer;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.IngredientTracker;
import com.github.vfyjxf.nee.utils.ItemUtils;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.p455w0rd.wirelesscraftingterminal.core.sync.WCTPacket;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketNEIRecipe;
import org.lwjgl.input.Keyboard;

public class NEECraftingHelper
implements IOverlayHandler {
    public static final NEECraftingHelper INSTANCE = new NEECraftingHelper();
    public static IngredientTracker tracker = null;
    public static boolean noPreview = false;
    private static boolean isPatternInterfaceExists = false;
    public static final int RECIPE_LENGTH = 9;

    public void overlayRecipe(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        if (GuiUtils.isGuiCraftingTerm((GuiScreen)firstGui) && NEECraftingHandler.isCraftingTableRecipe(recipe)) {
            boolean doCraftingHelp = Keyboard.isKeyDown((int)NEIClientConfig.getKeyBinding((String)"nee.preview")) || Keyboard.isKeyDown((int)NEIClientConfig.getKeyBinding((String)"nee.nopreview"));
            noPreview = Keyboard.isKeyDown((int)NEIClientConfig.getKeyBinding((String)"nee.nopreview"));
            if (doCraftingHelp) {
                if (isPatternInterfaceExists) {
                    NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketOpenCraftAmount(this.packCraftingRecipe(recipe, recipeIndex)));
                    isPatternInterfaceExists = false;
                } else {
                    tracker = new IngredientTracker(firstGui, recipe, recipeIndex);
                    if (!tracker.getRequireStacks().isEmpty()) {
                        tracker.requestNextIngredient();
                    } else {
                        this.moveItems(firstGui, recipe, recipeIndex);
                    }
                }
            } else {
                this.moveItems(firstGui, recipe, recipeIndex);
            }
        }
    }

    private NBTTagCompound packCraftingRecipe(IRecipeHandler recipeHandler, int recipeIndex) {
        NBTTagCompound recipe = new NBTTagCompound();
        List ingredients = recipeHandler.getIngredientStacks(recipeIndex);
        for (PositionedStack positionedStack : ingredients) {
            int col = (positionedStack.relx - 25) / 18;
            int row = (positionedStack.rely - 6) / 18;
            int slotIndex = col + row * 3;
            if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
            ItemStack[] currentStackList = positionedStack.items;
            ItemStack stack = positionedStack.items[0];
            ItemStack preferModItem = ItemUtils.getPreferModItem(positionedStack.items);
            if (preferModItem != null) {
                stack = preferModItem;
            }
            for (ItemStack currentStack : currentStackList) {
                if (!Platform.isRecipePrioritized((ItemStack)currentStack) && !ItemUtils.isPreferItems(currentStack)) continue;
                stack = currentStack.func_77946_l();
            }
            if (stack.func_77960_j() == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
            recipe.func_74782_a("#" + slotIndex, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        PositionedStack resultStack = recipeHandler.getResultStack(recipeIndex);
        if (resultStack.item != null) {
            recipe.func_74782_a("Outputs", (NBTBase)resultStack.item.func_77955_b(new NBTTagCompound()));
        }
        return recipe;
    }

    private void moveItems(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex) {
        try {
            List ingredients = recipe.getIngredientStacks(recipeIndex);
            if (firstGui instanceof GuiCraftingTerm) {
                appeng.core.sync.packets.PacketNEIRecipe packet = new appeng.core.sync.packets.PacketNEIRecipe(this.packIngredients(firstGui, ingredients, false));
                int packetSize = this.getPacketSize((AppEngPacket)packet);
                if (packetSize >= 32768) {
                    AELog.warn((String)("Recipe for " + recipe.getRecipeName() + " has too many variants, reduced version will be used"), (Object[])new Object[0]);
                    packet = new appeng.core.sync.packets.PacketNEIRecipe(this.packIngredients(firstGui, ingredients, true));
                }
                if (packetSize >= 0) {
                    appeng.core.sync.network.NetworkHandler.instance.sendToServer((AppEngPacket)packet);
                } else {
                    NotEnoughEnergistics.logger.error("Can't get packet size!");
                }
            } else if (GuiUtils.isGuiWirelessCrafting((GuiScreen)firstGui)) {
                this.moveItemsForWirelessCrafting(firstGui, ingredients);
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    private boolean testSize(NBTTagCompound recipe) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bytes);
        CompressedStreamTools.func_74799_a((NBTTagCompound)recipe, (OutputStream)outputStream);
        return bytes.size() > 3072;
    }

    private NBTTagCompound packIngredients(GuiContainer gui, List<PositionedStack> ingredients, boolean limited) throws IOException {
        NBTTagCompound recipe = new NBTTagCompound();
        block0: for (PositionedStack positionedStack : ingredients) {
            int col = (positionedStack.relx - 25) / 18;
            int row = (positionedStack.rely - 6) / 18;
            if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
            for (Slot slot : gui.field_147002_h.field_75151_b) {
                if (!this.isCraftingMatrixSlot(gui, slot) || slot.getSlotIndex() != col + row * 3) continue;
                NBTTagList tags = new NBTTagList();
                LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                for (int x = 0; x < positionedStack.items.length; ++x) {
                    if (Platform.isRecipePrioritized((ItemStack)positionedStack.items[x])) {
                        list.add(0, positionedStack.items[x]);
                        continue;
                    }
                    list.add(positionedStack.items[x]);
                }
                for (ItemStack is : list) {
                    NBTTagCompound tag = new NBTTagCompound();
                    is.func_77955_b(tag);
                    tags.func_74742_a((NBTBase)tag);
                    if (!limited) continue;
                    NBTTagCompound test = new NBTTagCompound();
                    test.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                    if (!this.testSize(test)) continue;
                    break;
                }
                recipe.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                continue block0;
            }
        }
        return recipe;
    }

    private boolean isCraftingMatrixSlot(GuiContainer gui, Slot slot) {
        if (gui instanceof GuiCraftingTerm) {
            return slot instanceof SlotCraftingMatrix || slot instanceof SlotFakeCraftingMatrix;
        }
        if (GuiUtils.isGuiWirelessCrafting((GuiScreen)gui)) {
            return slot instanceof net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotCraftingMatrix || slot instanceof net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotFakeCraftingMatrix;
        }
        return false;
    }

    private int getPacketSize(AppEngPacket packet) {
        try {
            ByteBuf p = (ByteBuf)ReflectionHelper.findField(AppEngPacket.class, (String[])new String[]{"p"}).get(packet);
            return p.array().length;
        }
        catch (IllegalAccessException e) {
            return -1;
        }
    }

    @Optional.Method(modid="ae2wct")
    private void moveItemsForWirelessCrafting(GuiContainer firstGui, List<PositionedStack> ingredients) {
        try {
            NetworkHandler.instance.sendToServer((WCTPacket)new PacketNEIRecipe(this.packIngredients(firstGui, ingredients, false)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onActionPerformedEventPre(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (NEEConfig.noShift && event.gui instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)event.gui;
            ArrayList<Object> overlayButtons = null;
            int OVERLAY_BUTTON_ID_START = 4;
            boolean isGtnhNei = true;
            try {
                Field overlayButtonsField = GuiRecipe.class.getDeclaredField("overlayButtons");
                overlayButtonsField.setAccessible(true);
                overlayButtons = new ArrayList<GuiButton>(Arrays.asList((GuiButton[])overlayButtonsField.get(guiRecipe)));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                isGtnhNei = false;
            }
            if (!isGtnhNei) {
                overlayButtons = new ArrayList();
                GuiButton overlay1 = (GuiButton)ReflectionHelper.getPrivateValue(GuiRecipe.class, (Object)guiRecipe, (String[])new String[]{"overlay1"});
                GuiButton overlay2 = (GuiButton)ReflectionHelper.getPrivateValue(GuiRecipe.class, (Object)guiRecipe, (String[])new String[]{"overlay2"});
                overlayButtons.add(overlay1);
                overlayButtons.add(overlay2);
            }
            if (event.button.field_146127_k >= 4 && event.button.field_146127_k < 4 + overlayButtons.size()) {
                boolean isCraftingTerm;
                boolean isPatternTerm = guiRecipe.firstGui instanceof GuiPatternTerm || GuiUtils.isPatternTermExGui((GuiScreen)guiRecipe.firstGui);
                boolean bl = isCraftingTerm = guiRecipe.firstGui instanceof GuiCraftingTerm || GuiUtils.isGuiWirelessCrafting((GuiScreen)guiRecipe.firstGui);
                if (isCraftingTerm || isPatternTerm) {
                    int recipesPerPage = 2;
                    IRecipeHandler handler = (IRecipeHandler)guiRecipe.currenthandlers.get(guiRecipe.recipetype);
                    if (isGtnhNei) {
                        try {
                            recipesPerPage = (Integer)ReflectionHelper.findMethod(GuiRecipe.class, (Object)guiRecipe, (String[])new String[]{"getRecipesPerPage"}, (Class[])new Class[0]).invoke((Object)guiRecipe, new Object[0]);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                    if (recipesPerPage >= 0 && handler != null) {
                        int recipe = guiRecipe.page * recipesPerPage + event.button.field_146127_k - 4;
                        IOverlayHandler overlayHandler = handler.getOverlayHandler(guiRecipe.firstGui, recipe);
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)guiRecipe.firstGui);
                        overlayHandler.overlayRecipe(guiRecipe.firstGui, (IRecipeHandler)guiRecipe.currenthandlers.get(guiRecipe.recipetype), recipe, NEIClientUtils.shiftKey());
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.gui instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)event.gui;
            GuiContainer firstGui = guiRecipe.firstGui;
            if (GuiUtils.isGuiCraftingTerm((GuiScreen)firstGui)) {
                NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketValueConfigServer("PatternInterface.check"));
            }
        }
    }

    public static void setIsPatternInterfaceExists(boolean isPatternInterfaceExists) {
        NEECraftingHelper.isPatternInterfaceExists = isPatternInterfaceExists;
    }

    public static boolean isIsPatternInterfaceExists() {
        return isPatternInterfaceExists;
    }
}

