/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee;

import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.client.gui.implementations.GuiInterface;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.client.gui.implementations.GuiPatternTermEx;
import codechicken.nei.NEIController;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.client.GuiEventHandler;
import com.github.vfyjxf.nee.nei.NEECraftingHandler;
import com.github.vfyjxf.nee.nei.NEECraftingHelper;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import com.github.vfyjxf.nee.processor.RecipeProcessor;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.p455w0rd.wirelesscraftingterminal.client.gui.GuiWirelessCraftingTerminal;
import thaumicenergistics.client.gui.GuiKnowledgeInscriber;
import wanion.avaritiaddons.block.extremeautocrafter.GuiExtremeAutoCrafter;

public class NEINeeConfig
implements IConfigureNEI {
    private static final List<Class<?>> transferBlacklist = new ArrayList<Class>(Arrays.asList(GuiInterface.class, GuiPatternTerm.class));

    public void loadConfig() {
        RecipeProcessor.init();
        this.registerKeyBindings();
        this.registerGuiHandler();
        HashSet<String> defaultIdentifiers = new HashSet<String>(Arrays.asList("crafting", "crafting2x2", "brewing", "smelting", "fuel", null));
        HashSet<String> identifiers = new HashSet<String>(defaultIdentifiers);
        RecipeProcessor.recipeProcessors.stream().map(IRecipeProcessor::getAllOverlayIdentifier).forEach(identifiers::addAll);
        for (String ident : identifiers) {
            API.registerGuiOverlay(GuiPatternTerm.class, (String)ident);
            API.registerGuiOverlayHandler(GuiPatternTerm.class, (IOverlayHandler)NEECraftingHandler.INSTANCE, (String)ident);
        }
        this.installCraftingTermSupport();
        this.installWirelessCraftingTermSupport();
        this.installPatternTerminalExSupport(identifiers);
        this.installThaumicEnergisticsSupport();
        this.installAvaritiaddonsSupport();
    }

    public String getName() {
        return "NotEnoughEnergistics";
    }

    public String getVersion() {
        return "1.3.11";
    }

    private void registerKeyBindings() {
        API.addKeyBind((String)"nee.count", (int)29);
        API.addKeyBind((String)"nee.ingredient", (int)42);
        API.addKeyBind((String)"nee.preview", (int)29);
        API.addKeyBind((String)"nee.nopreview", (int)56);
    }

    private void registerGuiHandler() {
        API.registerNEIGuiHandler((INEIGuiHandler)GuiEventHandler.instance);
        this.replaceNEIController();
    }

    private void replaceNEIController() {
        int controllerIndex = -1;
        for (IContainerInputHandler inputHandler : GuiContainerManager.inputHandlers) {
            if (!(inputHandler instanceof NEIController)) continue;
            controllerIndex = GuiContainerManager.inputHandlers.indexOf(inputHandler);
            break;
        }
        if (controllerIndex > 0) {
            GuiContainerManager.inputHandlers.remove(controllerIndex);
            GuiContainerManager.inputHandlers.add(controllerIndex, new NEIController(){

                public boolean mouseScrolled(GuiContainer gui, int mouseX, int mouseY, int scrolled) {
                    if (transferBlacklist.contains(gui.getClass())) {
                        return false;
                    }
                    return super.mouseScrolled(gui, mouseX, mouseY, scrolled);
                }
            });
            NotEnoughEnergistics.logger.info("NEIController replaced success");
        }
    }

    private void installCraftingTermSupport() {
        API.registerGuiOverlay(GuiCraftingTerm.class, (String)"crafting");
        API.registerGuiOverlay(GuiCraftingTerm.class, (String)"crafting2x2");
        API.registerGuiOverlayHandler(GuiCraftingTerm.class, (IOverlayHandler)NEECraftingHelper.INSTANCE, (String)"crafting");
        API.registerGuiOverlayHandler(GuiCraftingTerm.class, (IOverlayHandler)NEECraftingHelper.INSTANCE, (String)"crafting2x2");
    }

    private void installWirelessCraftingTermSupport() {
        if (Loader.isModLoaded((String)"ae2wct")) {
            API.registerGuiOverlayHandler(GuiWirelessCraftingTerminal.class, (IOverlayHandler)NEECraftingHelper.INSTANCE, (String)"crafting");
            API.registerGuiOverlayHandler(GuiWirelessCraftingTerminal.class, (IOverlayHandler)NEECraftingHelper.INSTANCE, (String)"crafting2x2");
        }
    }

    private void installThaumicEnergisticsSupport() {
        try {
            Class.forName("thaumicenergistics.client.gui.GuiKnowledgeInscriber");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (Loader.isModLoaded((String)"thaumcraftneiplugin")) {
            NotEnoughEnergistics.logger.info("Install ThaumicEnergistics support");
            API.registerGuiOverlay(GuiKnowledgeInscriber.class, (String)"arcaneshapedrecipes");
            API.registerGuiOverlay(GuiKnowledgeInscriber.class, (String)"arcaneshapelessrecipes");
            API.registerGuiOverlayHandler(GuiKnowledgeInscriber.class, (IOverlayHandler)new NEECraftingHandler(), (String)"arcaneshapedrecipes");
            API.registerGuiOverlayHandler(GuiKnowledgeInscriber.class, (IOverlayHandler)new NEECraftingHandler(), (String)"arcaneshapelessrecipes");
        }
    }

    private void installPatternTerminalExSupport(Set<String> identifiers) {
        try {
            Class.forName("appeng.client.gui.implementations.GuiPatternTermEx");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        identifiers.remove("crafting");
        identifiers.remove("crafting2x2");
        for (String ident : identifiers) {
            API.registerGuiOverlay(GuiPatternTermEx.class, (String)ident);
            API.registerGuiOverlayHandler(GuiPatternTermEx.class, (IOverlayHandler)new NEECraftingHandler(), (String)ident);
        }
    }

    private void installAvaritiaddonsSupport() {
        try {
            Class.forName("wanion.avaritiaddons.block.extremeautocrafter.GuiExtremeAutoCrafter");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (Loader.isModLoaded((String)"avaritiaddons")) {
            NotEnoughEnergistics.logger.info("Install Avaritiaddons support");
            API.registerGuiOverlay(GuiExtremeAutoCrafter.class, (String)"extreme");
            API.registerGuiOverlayHandler(GuiExtremeAutoCrafter.class, (IOverlayHandler)new NEECraftingHandler(), (String)"extreme");
        }
    }
}

