/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.nei;

import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.client.gui.implementations.GuiPatternTermEx;
import appeng.util.Platform;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketNEIPatternRecipe;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import com.github.vfyjxf.nee.processor.RecipeProcessor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NEECraftingHandler
implements IOverlayHandler {
    public static final String OUTPUT_KEY = "Outputs";

    public void overlayRecipe(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        if (firstGui instanceof GuiPatternTerm || firstGui instanceof GuiPatternTermEx) {
            NEENetworkHandler.getInstance().sendToServer((IMessage)this.packRecipe(recipe, recipeIndex));
        }
    }

    private PacketNEIPatternRecipe packRecipe(IRecipeHandler recipe, int recipeIndex) {
        if (this.isCraftingTableRecipe(recipe)) {
            return this.packCraftingTableRecipe(recipe, recipeIndex);
        }
        return this.packProcessRecipe(recipe, recipeIndex);
    }

    private PacketNEIPatternRecipe packProcessRecipe(IRecipeHandler recipe, int recipeIndex) {
        NBTTagCompound recipeInputs = new NBTTagCompound();
        NBTTagCompound recipeOutputs = new NBTTagCompound();
        String identifier = ((TemplateRecipeHandler)recipe).getOverlayIdentifier();
        int inputIndex = 0;
        int outputIndex = 0;
        for (IRecipeProcessor processor : RecipeProcessor.recipeProcessors) {
            ItemStack currentStack;
            List<PositionedStack> inputs = processor.getRecipeInput(recipe, recipeIndex, identifier);
            List<PositionedStack> outputs = processor.getRecipeOutput(recipe, recipeIndex, identifier);
            ArrayList<PositionedStack> tInputs = new ArrayList<PositionedStack>();
            if (inputs == null || outputs == null) continue;
            for (PositionedStack positionedStack : inputs) {
                currentStack = positionedStack.items[0];
                boolean find = false;
                for (PositionedStack storedStack : tInputs) {
                    ItemStack StoredStack = storedStack.items[0];
                    if (!StoredStack.func_77969_a(currentStack) || StoredStack.field_77994_a + currentStack.field_77994_a > StoredStack.func_77976_d()) continue;
                    find = true;
                    storedStack.items[0].field_77994_a = StoredStack.field_77994_a + currentStack.field_77994_a;
                }
                if (find) continue;
                tInputs.add(positionedStack);
            }
            for (PositionedStack positionedStack : tInputs) {
                currentStack = positionedStack.items[0];
                for (ItemStack stack : positionedStack.items) {
                    if (!Platform.isRecipePrioritized((ItemStack)stack)) continue;
                    currentStack = stack.func_77946_l();
                    break;
                }
                recipeInputs.func_74782_a("#" + inputIndex, (NBTBase)currentStack.func_77955_b(new NBTTagCompound()));
                ++inputIndex;
            }
            for (PositionedStack positionedStack : outputs) {
                if (outputIndex >= 4 || positionedStack.item == null) continue;
                recipeOutputs.func_74782_a(OUTPUT_KEY + outputIndex, (NBTBase)positionedStack.item.func_77955_b(new NBTTagCompound()));
                ++outputIndex;
            }
        }
        return new PacketNEIPatternRecipe(recipeInputs, recipeOutputs);
    }

    private PacketNEIPatternRecipe packCraftingTableRecipe(IRecipeHandler recipe, int recipeIndex) {
        NBTTagCompound recipeInputs = new NBTTagCompound();
        List ingredients = recipe.getIngredientStacks(recipeIndex);
        for (PositionedStack positionedStack : ingredients) {
            int col = (positionedStack.relx - 25) / 18;
            int row = (positionedStack.rely - 6) / 18;
            int slotIndex = col + row * 3;
            if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
            ItemStack[] currentStackList = positionedStack.items;
            ItemStack stack = positionedStack.items[0];
            for (ItemStack currentStack : currentStackList) {
                if (!Platform.isRecipePrioritized((ItemStack)currentStack)) continue;
                stack = currentStack.func_77946_l();
            }
            recipeInputs.func_74782_a("#" + slotIndex, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        return new PacketNEIPatternRecipe(recipeInputs, null);
    }

    private boolean isCraftingTableRecipe(IRecipeHandler recipe) {
        TemplateRecipeHandler templateRecipeHandler = (TemplateRecipeHandler)recipe;
        String overlayIdentifier = templateRecipeHandler.getOverlayIdentifier();
        return "crafting".equals(overlayIdentifier) || "crafting2x2".equals(overlayIdentifier);
    }
}

