/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.processor;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import cofh.thermalexpansion.plugins.nei.handlers.RecipeHandlerBase;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class ThermalExpansionRecipeProcessor
implements IRecipeProcessor {
    private static Class<?> thermalNeiRecipeBaseClass;

    @Override
    @Nonnull
    public Set<String> getAllOverlayIdentifier() {
        return new HashSet<String>(Arrays.asList("thermalexpansion.charger", "thermalexpansion.crucible", "thermalexpansion.furnace", "thermalexpansion.insolator", "thermalexpansion.pulverizer", "thermalexpansion.sawmill", "thermalexpansion.smelter", "thermalexpansion.transposer"));
    }

    @Override
    @Nonnull
    public String getRecipeProcessorId() {
        return "ThermalExpansion";
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeInput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeInputs = new ArrayList<PositionedStack>();
        if (this.getAllOverlayIdentifier().contains(identifier)) {
            recipeInputs.addAll(recipe.getIngredientStacks(recipeIndex));
            if (recipe instanceof RecipeHandlerBase && thermalNeiRecipeBaseClass != null) {
                Field secondaryInputField = ReflectionHelper.findField(thermalNeiRecipeBaseClass, (String[])new String[]{"secondaryInput"});
                PositionedStack secondaryInput = null;
                try {
                    secondaryInput = (PositionedStack)secondaryInputField.get(((RecipeHandlerBase)recipe).arecipes.get(recipeIndex));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (secondaryInput != null) {
                    recipeInputs.add(secondaryInput);
                }
            }
            return recipeInputs;
        }
        return recipeInputs;
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeOutput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeOutputs = new ArrayList<PositionedStack>();
        if (this.getAllOverlayIdentifier().contains(identifier)) {
            recipeOutputs.add(recipe.getResultStack(recipeIndex));
            if (recipe instanceof RecipeHandlerBase && thermalNeiRecipeBaseClass != null) {
                Field secondaryOutputField = ReflectionHelper.findField(thermalNeiRecipeBaseClass, (String[])new String[]{"secondaryOutput"});
                Field secondaryOutputChanceField = ReflectionHelper.findField(thermalNeiRecipeBaseClass, (String[])new String[]{"secondaryOutputChance"});
                PositionedStack secondaryOutput = null;
                int secondaryOutputChance = 0;
                try {
                    secondaryOutput = (PositionedStack)secondaryOutputField.get(((RecipeHandlerBase)recipe).arecipes.get(recipeIndex));
                    secondaryOutputChance = (Integer)secondaryOutputChanceField.get(((RecipeHandlerBase)recipe).arecipes.get(recipeIndex));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (secondaryOutput != null && secondaryOutputChance >= 100) {
                    recipeOutputs.add(secondaryOutput);
                }
            }
            return recipeOutputs;
        }
        return recipeOutputs;
    }

    static {
        try {
            thermalNeiRecipeBaseClass = Class.forName("cofh.thermalexpansion.plugins.nei.handlers.RecipeHandlerBase$NEIRecipeBase");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

