/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.asm;

import codechicken.lib.asm.ASMInit;
import codechicken.lib.asm.ObfMapping;
import com.github.vfyjxf.nee.NotEnoughEnergistics;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class NEEClassTransformer
implements IClassTransformer {
    private static final List<String> transformedClassNames;
    private static final String TARGET_CLASS_NAME = "appeng/client/gui/AEBaseGui";
    private static final ObfMapping TARGET_METHOD_MAPPING;
    private static final String METHOD_OWNER = "codechicken/nei/recipe/TemplateRecipeHandler";
    private static final String METHOD_NAME_1 = "getOverlayHandler";
    private static final String METHOD_NAME_2 = "hasOverlay";
    private static final String METHOD_TARGET_1 = "(Lnet/minecraft/client/gui/inventory/GuiContainer;I)Lcodechicken/nei/api/IOverlayHandler;";
    private static final String METHOD_TARGET_2 = "(Lnet/minecraft/client/gui/inventory/GuiContainer;Lnet/minecraft/inventory/Container;I)Z";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        String internalName = transformedName.replace('.', '/');
        if (transformedClassNames.contains(internalName)) {
            ClassNode classNode = this.createClassNode(basicClass);
            for (MethodNode methodNode : classNode.methods) {
                InsnList insnList;
                if (METHOD_NAME_1.equals(methodNode.name) && METHOD_TARGET_1.equals(methodNode.desc)) {
                    NotEnoughEnergistics.logger.info("Transforming : " + internalName + methodNode.name + methodNode.desc);
                    for (AbstractInsnNode instruction : methodNode.instructions.toArray()) {
                        if (instruction.getOpcode() != 1) continue;
                        insnList = new InsnList();
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        insnList.add((AbstractInsnNode)new VarInsnNode(21, 2));
                        insnList.add((AbstractInsnNode)new MethodInsnNode(183, METHOD_OWNER, METHOD_NAME_1, METHOD_TARGET_1, false));
                        methodNode.instructions.insert(instruction, insnList);
                        methodNode.instructions.remove(instruction);
                    }
                }
                if (!METHOD_NAME_2.equals(methodNode.name) || !METHOD_TARGET_2.equals(methodNode.desc)) continue;
                NotEnoughEnergistics.logger.info("Transforming : " + internalName + methodNode.name + methodNode.desc);
                for (AbstractInsnNode instruction : methodNode.instructions.toArray()) {
                    if (instruction.getOpcode() != 3) continue;
                    insnList = new InsnList();
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                    insnList.add((AbstractInsnNode)new VarInsnNode(21, 3));
                    insnList.add((AbstractInsnNode)new MethodInsnNode(183, METHOD_OWNER, METHOD_NAME_2, METHOD_TARGET_2, false));
                    methodNode.instructions.insert(instruction, insnList);
                    methodNode.instructions.remove(instruction);
                }
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        if (TARGET_CLASS_NAME.equals(internalName)) {
            ClassNode classNode = this.createClassNode(basicClass);
            for (MethodNode methodNode : classNode.methods) {
                if (!TARGET_METHOD_MAPPING.matches(methodNode)) continue;
                NotEnoughEnergistics.logger.info("Transforming : " + internalName + methodNode.name + methodNode.desc);
                AbstractInsnNode aLoad = methodNode.instructions.getFirst();
                while (aLoad.getOpcode() != 21) {
                    aLoad = aLoad.getNext();
                }
                InsnList insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(21, 1));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/vfyjxf/nee/asm/AppengHelper", "handleMouseWheelInput", "(I)Z", false));
                LabelNode label = new LabelNode();
                insnList.add((AbstractInsnNode)new JumpInsnNode(153, label));
                insnList.add((AbstractInsnNode)new InsnNode(177));
                insnList.add((AbstractInsnNode)label);
                methodNode.instructions.insertBefore(aLoad, insnList);
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return basicClass;
    }

    private ClassNode createClassNode(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    static {
        ASMInit.init();
        transformedClassNames = Arrays.asList("appeng/integration/modules/NEIHelpers/NEIInscriberRecipeHandler", "appeng/integration/modules/NEIHelpers/NEIGrinderRecipeHandler");
        TARGET_METHOD_MAPPING = new ObfMapping(TARGET_CLASS_NAME, "func_146274_d", "()V").toClassloading();
    }
}

