/*
 * Decompiled with CFR 0.152.
 */
package mods.natura;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mantle.lib.TabTools;
import mantle.pulsar.control.PulseManager;
import mods.natura.CloudMaterial;
import mods.natura.common.NContent;
import mods.natura.common.NProxyCommon;
import mods.natura.common.NaturaTab;
import mods.natura.common.PHNatura;
import mods.natura.dimension.NetheriteWorldProvider;
import mods.natura.gui.NGuiHandler;
import mods.natura.plugins.PluginController;
import mods.natura.worldgen.BaseCloudWorldgen;
import mods.natura.worldgen.BaseCropWorldgen;
import mods.natura.worldgen.BaseTreeWorldgen;
import mods.natura.worldgen.retro.TickHandlerWorld;
import mods.natura.worldgen.retro.WorldHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="Natura", name="Natura", version="2.6.4", acceptedMinecraftVersions="[1.7.10]", dependencies="required-after:Mantle;after:TConstruct")
public class Natura {
    @SidedProxy(clientSide="mods.natura.client.NProxyClient", serverSide="mods.natura.common.NProxyCommon")
    public static NProxyCommon proxy;
    public static final String modID = "Natura";
    @Mod.Instance(value="Natura")
    public static Natura instance;
    public static Material cloud;
    public static Logger logger;
    public static final PulseManager pulsar;
    public static BaseCropWorldgen crops;
    public static BaseCloudWorldgen clouds;
    public static BaseTreeWorldgen trees;
    public static final int DIM_WORLDGEN_CROP_BIT = 1;
    public static final int DIM_WORLDGEN_CLOUD_BIT = 2;
    public static final int DIM_WORLDGEN_TREE_BIT = 4;
    private static final Map<Integer, Integer> dimensionWorldgenOverrides;
    public static boolean retrogen;
    NContent content;
    public static Random random;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        PluginController.registerBuiltins();
        PHNatura.initProps(evt.getSuggestedConfigurationFile());
        NaturaTab.tab = new TabTools("natura.plants");
        this.content = new NContent();
        this.content.preInit();
        this.content.addOredictSupport();
        NaturaTab.tab.init(new ItemStack((Block)NContent.floraSapling, 1, 3));
        pulsar.preInit(evt);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        if (PHNatura.enableBerryBushes | PHNatura.enableNetherBerryBushes) {
            crops = new BaseCropWorldgen();
            GameRegistry.registerWorldGenerator((IWorldGenerator)crops, (int)20);
        }
        clouds = new BaseCloudWorldgen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)clouds, (int)20);
        trees = new BaseTreeWorldgen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)trees, (int)20);
        proxy.registerRenderer();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new NGuiHandler());
        GameRegistry.registerFuelHandler((IFuelHandler)this.content);
        if (PHNatura.overrideNether) {
            DimensionManager.unregisterProviderType((int)-1);
            DimensionManager.registerProviderType((int)-1, NetheriteWorldProvider.class, (boolean)true);
        }
        MinecraftForge.EVENT_BUS.register((Object)WorldHandler.instance);
        FMLCommonHandler.instance().bus().register((Object)this);
        if (retrogen) {
            FMLCommonHandler.instance().bus().register((Object)new TickHandlerWorld());
        }
        OreDictionary.registerOre((String)"cropVine", (ItemStack)new ItemStack(NContent.thornVines));
        random.setSeed(3244L);
        pulsar.init(evt);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.content.createEntities();
        this.content.modIntegration();
        pulsar.postInit(evt);
        this.imcHandler();
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.ServerTickEvent event) {
        if (event.side.isServer() && event.phase.equals((Object)TickEvent.Phase.START)) {
            this.imcHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imcHandler() {
        ImmutableList imc = FMLInterModComms.fetchRuntimeMessages((Object)this);
        if (imc != null && !imc.isEmpty()) {
            for (FMLInterModComms.IMCMessage message : imc) {
                try {
                    if (!message.key.equalsIgnoreCase("set-worldgen-overrides") || !message.isNBTMessage()) continue;
                    NBTTagCompound tag = message.getNBTValue();
                    int[] dimensions = tag.func_74759_k("dimensions");
                    int[] settings = tag.func_74759_k("settings");
                    if (dimensions == null || settings == null || dimensions.length != settings.length) {
                        FMLLog.warning((String)"Invalid Natura IMC format, mismatched array lengths", (Object[])new Object[0]);
                        return;
                    }
                    Map<Integer, Integer> map = dimensionWorldgenOverrides;
                    synchronized (map) {
                        for (int i = 0; i < dimensions.length; ++i) {
                            dimensionWorldgenOverrides.put(dimensions[i], settings[i]);
                        }
                    }
                }
                catch (Exception e) {
                    FMLLog.warning((String)"Exception while handling a Natura IMC message `{}`", (Object[])new Object[]{message.key, e});
                }
            }
        }
    }

    public static int getDimensionWorldgenOverrides(int dimId) {
        Integer val = dimensionWorldgenOverrides.get(dimId);
        return val != null ? val : Integer.MAX_VALUE;
    }

    @SubscribeEvent
    public void bonemealEvent(BonemealEvent event) {
        if (!event.world.field_72995_K && !event.isCanceled() && event.getResult() != Event.Result.ALLOW) {
            if (event.block == NContent.glowshroom) {
                if (NContent.glowshroom.fertilizeMushroom(event.world, event.x, event.y, event.z, event.world.field_73012_v)) {
                    event.setResult(Event.Result.ALLOW);
                }
            } else if (PHNatura.enableBerryBushes && event.block == NContent.berryBush) {
                if (NContent.berryBush.boneFertilize(event.world, event.x, event.y, event.z, event.world.field_73012_v)) {
                    event.setResult(Event.Result.ALLOW);
                }
            } else if (PHNatura.enableNetherBerryBushes && event.block == NContent.netherBerryBush && NContent.netherBerryBush.boneFertilize(event.world, event.x, event.y, event.z, event.world.field_73012_v)) {
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void interactEvent(EntityInteractEvent event) {
        if (event.target instanceof EntityCow || event.target instanceof EntitySheep) {
            ItemStack equipped = event.entityPlayer.func_71045_bC();
            EntityAnimal creature = (EntityAnimal)event.target;
            if (equipped != null && equipped.func_77973_b() == NContent.plantItem && equipped.func_77960_j() == 0 && creature.func_70874_b() == 0 && !creature.func_70880_s()) {
                EntityPlayer player = event.entityPlayer;
                if (!player.field_71075_bZ.field_75098_d) {
                    --equipped.field_77994_a;
                    if (equipped.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                }
                creature.func_146082_f(event.entityPlayer);
            }
        }
    }

    @SubscribeEvent
    public void spawnEvent(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityCow || event.entity instanceof EntitySheep) {
            ((EntityLiving)event.entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)event.entity, 0.25, NContent.plantItem, false));
        } else if (event.entity instanceof EntityChicken) {
            ((EntityLiving)event.entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)event.entity, 0.25, NContent.seeds, false));
        }
    }

    @SubscribeEvent
    public void chunkDataSave(ChunkDataEvent.Save event) {
        event.getData().func_74757_a("Natura.Retrogen", true);
    }

    static {
        cloud = new CloudMaterial();
        logger = LogManager.getLogger((String)modID);
        pulsar = new PulseManager(modID, "Natura-Dynamic");
        dimensionWorldgenOverrides = new HashMap<Integer, Integer>();
        random = new Random();
    }
}

