/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.DiagramMatcher;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public class CustomDiagramGroup
extends DiagramGroup {
    private final ImmutableMap<String, Supplier<Collection<Diagram>>> customBehaviorMap;

    public CustomDiagramGroup(DiagramGroupInfo info, DiagramMatcher matcher, Supplier<DiagramState> diagramStateSupplier, Map<String, Supplier<Collection<Diagram>>> customBehaviorMap) {
        super(info, matcher, diagramStateSupplier);
        this.customBehaviorMap = ImmutableMap.copyOf(customBehaviorMap);
    }

    public CustomDiagramGroup(DiagramGroupInfo info, DiagramMatcher matcher, Map<String, Supplier<Collection<Diagram>>> customBehaviorMap) {
        super(info, matcher);
        this.customBehaviorMap = ImmutableMap.copyOf(customBehaviorMap);
    }

    public CustomDiagramGroup(CustomDiagramGroup parent, Iterable<? extends Diagram> diagrams) {
        super(parent, diagrams);
        this.customBehaviorMap = parent.customBehaviorMap;
    }

    @Override
    public CustomDiagramGroup newInstance(Iterable<? extends Diagram> diagrams) {
        return new CustomDiagramGroup(this, diagrams);
    }

    @Override
    protected Collection<Diagram> matchDiagrams(String id, Interactable.RecipeType recipeType, Object ... stacks) {
        if (this.customBehaviorMap.containsKey((Object)id)) {
            return (Collection)((Supplier)this.customBehaviorMap.get((Object)id)).get();
        }
        return super.matchDiagrams(id, recipeType, stacks);
    }
}

