/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.FluidComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.AutoValue_RecipeHandler_Recipe;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.RecipePartitioner;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechRecipeUtil;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import gregtech.api.enums.ItemList;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

class RecipeHandler {
    static final Item PROGRAMMED_CIRCUIT = ItemList.Circuit_Integrated.getItem();
    static final ImmutableSet<ItemComponent> PROGRAMMED_CIRCUITS = ImmutableSet.copyOf((Collection)IntStream.range(0, 25).mapToObj(i -> ItemComponent.create(GT_Utility.getIntegratedCircuit((int)i))).collect(Collectors.toList()));
    static final ImmutableSet<ItemComponent> SCHEMATICS = ImmutableSet.builder().add((Object)GregTechOreDictUtil.getComponent(ItemList.Schematic_1by1)).add((Object)GregTechOreDictUtil.getComponent(ItemList.Schematic_2by2)).add((Object)GregTechOreDictUtil.getComponent(ItemList.Schematic_3by3)).add((Object)GregTechOreDictUtil.getComponent(ItemList.Schematic_Dust)).build();
    final Map<RecipeMap, RecipePartitioner> allRecipes = new HashMap<RecipeMap, RecipePartitioner>();
    final List<Recipe> consumeCircuitRecipes = new ArrayList<Recipe>();
    final List<Recipe> unnecessaryCircuitRecipes = new ArrayList<Recipe>();
    final Set<Recipe> collidingRecipes = new LinkedHashSet<Recipe>();
    final List<Recipe> voidingRecipes = new ArrayList<Recipe>();
    final List<Recipe> unequalCellRecipes = new ArrayList<Recipe>();

    RecipeHandler() {
    }

    void initialize() {
        for (RecipeMap recipeMap : RecipeMap.values()) {
            Logger.GREGTECH_5_RECIPE_DEBUGGER.info("Checking recipes, pass 1: {}", new Object[]{recipeMap.name()});
            ImmutableList.Builder recipeListBuilder = ImmutableList.builder();
            recipeMap.recipeMap.mRecipeList.stream().map(recipe -> Recipe.create(recipeMap, recipe)).filter(recipe -> RecipeHandler.filterRecipes(recipeMap, recipe)).forEach(arg_0 -> ((ImmutableList.Builder)recipeListBuilder).add(arg_0));
            RecipePartitioner recipePartitioner = new RecipePartitioner((List<Recipe>)recipeListBuilder.build());
            recipePartitioner.initialize();
            this.allRecipes.put(recipeMap, recipePartitioner);
        }
        for (RecipeMap recipeMap : RecipeMap.values()) {
            Logger.GREGTECH_5_RECIPE_DEBUGGER.info("Checking recipes, pass 2: {} [{}]", new Object[]{recipeMap.name(), this.allRecipes.get((Object)recipeMap).size()});
            RecipePartitioner recipePartitioner = this.allRecipes.get((Object)recipeMap);
            for (Recipe recipe2 : recipePartitioner.allRecipes()) {
                Iterable<Recipe> matchingRecipes = recipePartitioner.lookup((Set<Component>)recipe2.inputs().keySet());
                if (RecipeHandler.consumesCircuit(recipe2)) {
                    this.consumeCircuitRecipes.add(recipe2);
                }
                if (RecipeHandler.unnecessaryCircuit(recipe2, matchingRecipes)) {
                    this.unnecessaryCircuitRecipes.add(recipe2);
                }
                this.collidingRecipes.addAll(RecipeHandler.findCollidingRecipes(recipe2, matchingRecipes));
                if (RecipeHandler.voidingRecipe(recipe2)) {
                    this.voidingRecipes.add(recipe2);
                }
                if (!RecipeHandler.unequalCellRecipe(recipe2)) continue;
                this.unequalCellRecipes.add(recipe2);
            }
        }
    }

    static Set<Component> filterCircuits(Set<Component> components) {
        return Sets.difference(components, PROGRAMMED_CIRCUITS);
    }

    private static boolean filterRecipes(RecipeMap recipeMap, Recipe recipe) {
        if (recipeMap == RecipeMap.CUTTING_MACHINE) {
            return recipe.inputs().keySet().stream().anyMatch(component -> component.type() == Component.ComponentType.ITEM);
        }
        return true;
    }

    private static boolean isSubset(Set<Component> a, Set<Component> b) {
        return b.containsAll(a);
    }

    private static boolean isSubsetComparingStackSizes(Map<Component, Integer> a, Map<Component, Integer> b) {
        for (Map.Entry<Component, Integer> entry : a.entrySet()) {
            if (b.getOrDefault(entry.getKey(), 0) >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean consumesCircuit(Recipe recipe) {
        for (Map.Entry entry : recipe.inputs().entrySet()) {
            Component component = (Component)entry.getKey();
            if (component.type() != Component.ComponentType.ITEM || !PROGRAMMED_CIRCUITS.contains((Object)component) && !SCHEMATICS.contains((Object)component) || (Integer)entry.getValue() <= 0) continue;
            return true;
        }
        return false;
    }

    private static boolean unnecessaryCircuit(Recipe recipe, Iterable<Recipe> recipes) {
        ImmutableSet inputs = recipe.inputs().keySet();
        if (inputs.stream().noneMatch(arg_0 -> PROGRAMMED_CIRCUITS.contains(arg_0))) {
            return false;
        }
        Set<Component> filteredInputs = RecipeHandler.filterCircuits((Set<Component>)inputs);
        for (Recipe otherRecipe : recipes) {
            if (recipe == otherRecipe || !RecipeHandler.isSubset(filteredInputs, (Set<Component>)otherRecipe.inputs().keySet())) continue;
            return false;
        }
        return true;
    }

    private static Set<Recipe> findCollidingRecipes(Recipe recipe, Iterable<Recipe> recipes) {
        LinkedHashSet collidingRecipes = Sets.newLinkedHashSet();
        collidingRecipes.add(recipe);
        for (Recipe otherRecipe : recipes) {
            if (recipe == otherRecipe || !RecipeHandler.isSubset((Set<Component>)recipe.inputs().keySet(), (Set<Component>)otherRecipe.inputs().keySet())) continue;
            collidingRecipes.add(otherRecipe);
        }
        if (collidingRecipes.size() > 1) {
            return collidingRecipes;
        }
        return Sets.newHashSet();
    }

    private static boolean voidingRecipe(Recipe recipe) {
        return RecipeHandler.isSubsetComparingStackSizes(recipe.outputs(), recipe.inputs());
    }

    private static int countCells(Map<Component, Integer> componentMap) {
        int cells = 0;
        for (Map.Entry<Component, Integer> entry : componentMap.entrySet()) {
            Component component = entry.getKey();
            if (component.type() != Component.ComponentType.ITEM) continue;
            ItemStack itemStack = ((ItemComponent)component).stack();
            try {
                if (GT_ModHandler.getCapsuleCellContainerCount((ItemStack)itemStack) <= 0) continue;
                cells += entry.getValue().intValue();
            }
            catch (NullPointerException nullPointerException) {}
        }
        return cells;
    }

    private static boolean unequalCellRecipe(Recipe recipe) {
        if (recipe.recipeMap() == RecipeMap.MACERATOR) {
            return false;
        }
        return RecipeHandler.countCells(recipe.inputs()) != RecipeHandler.countCells(recipe.outputs());
    }

    @AutoValue
    static abstract class Recipe {
        Recipe() {
        }

        /*
         * WARNING - void declaration
         */
        static Recipe create(RecipeMap recipeMap, GT_Recipe recipe) {
            void var6_13;
            void var6_11;
            HashMap<Component, Integer> inputs = new HashMap<Component, Integer>();
            for (ItemStack itemStack : recipe.mInputs) {
                if (itemStack == null) continue;
                ItemStack itemStack2 = GT_OreDictUnificator.get_nocopy((ItemStack)itemStack);
                inputs.merge(ItemComponent.createWithNbt(itemStack2), itemStack.field_77994_a, Integer::sum);
            }
            for (ItemStack itemStack : recipe.mFluidInputs) {
                if (itemStack == null) continue;
                inputs.merge(FluidComponent.createWithNbt((FluidStack)itemStack), itemStack.amount, Integer::sum);
            }
            HashMap<Component, Integer> outputs = new HashMap<Component, Integer>();
            ItemStack[] itemStackArray = recipe.mOutputs;
            int n = itemStackArray.length;
            boolean bl = false;
            while (var6_11 < n) {
                ItemStack itemStack = itemStackArray[var6_11];
                if (itemStack != null) {
                    ItemStack unified = GT_OreDictUnificator.get_nocopy((ItemStack)itemStack);
                    outputs.merge(ItemComponent.createWithNbt(unified), itemStack.field_77994_a, Integer::sum);
                }
                ++var6_11;
            }
            itemStackArray = recipe.mFluidOutputs;
            n = itemStackArray.length;
            boolean bl2 = false;
            while (var6_13 < n) {
                ItemStack itemStack = itemStackArray[var6_13];
                if (itemStack != null) {
                    outputs.merge(FluidComponent.createWithNbt((FluidStack)itemStack), itemStack.amount, Integer::sum);
                }
                ++var6_13;
            }
            return new AutoValue_RecipeHandler_Recipe(recipeMap, (ImmutableMap<Component, Integer>)ImmutableMap.copyOf(inputs), (ImmutableMap<Component, Integer>)ImmutableMap.copyOf(outputs), (ImmutableList<DisplayComponent>)ImmutableList.copyOf(GregTechRecipeUtil.buildComponentsFromInputs(recipe)), (ImmutableList<DisplayComponent>)ImmutableList.copyOf(GregTechRecipeUtil.buildComponentsFromOutputs(recipe)));
        }

        abstract RecipeMap recipeMap();

        abstract ImmutableMap<Component, Integer> inputs();

        abstract ImmutableMap<Component, Integer> outputs();

        abstract ImmutableList<DisplayComponent> displayInputs();

        abstract ImmutableList<DisplayComponent> displayOutputs();
    }

    static enum RecipeMap {
        ORE_WASHING_PLANT(GT_Recipe.GT_Recipe_Map.sOreWasherRecipes, ItemList.Machine_HV_OreWasher, "orewashingplantlabel"),
        THERMAL_CENTRIFUGE(GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes, ItemList.Machine_HV_ThermalCentrifuge, "thermalcentrifugelabel"),
        COMPRESSOR(GT_Recipe.GT_Recipe_Map.sCompressorRecipes, ItemList.Machine_HV_Compressor, "compressorlabel"),
        EXTRACTOR(GT_Recipe.GT_Recipe_Map.sExtractorRecipes, ItemList.Machine_HV_Extractor, "extractorlabel"),
        PRINTER(GT_Recipe.GT_Recipe_Map.sPrinterRecipes, ItemList.Machine_HV_Printer, "printerlabel"),
        SIFTER(GT_Recipe.GT_Recipe_Map.sSifterRecipes, ItemList.Machine_HV_Sifter, "sifterlabel"),
        FORMING_PRESS(GT_Recipe.GT_Recipe_Map.sPressRecipes, ItemList.Machine_HV_Press, "formingpresslabel"),
        PRECISION_LASER_ENGRAVER(GT_Recipe.GT_Recipe_Map.sLaserEngraverRecipes, ItemList.Machine_HV_LaserEngraver, "precisionlaserengraverlabel"),
        MIXER(GT_Recipe.GT_Recipe_Map.sMixerRecipes, ItemList.Machine_HV_Mixer, "mixerlabel"),
        AUTOCLAVE(GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes, ItemList.Machine_HV_Autoclave, "autoclavelabel"),
        ELECTROMAGNETIC_SEPARATOR(GT_Recipe.GT_Recipe_Map.sElectroMagneticSeparatorRecipes, ItemList.Machine_HV_ElectromagneticSeparator, "electromagneticseparatorlabel"),
        POLARIZER(GT_Recipe.GT_Recipe_Map.sPolarizerRecipes, ItemList.Machine_HV_Polarizer, "polarizerlabel"),
        MACERATOR(GT_Recipe.GT_Recipe_Map.sMaceratorRecipes, ItemList.Machine_HV_Macerator, "maceratorlabel"),
        CHEMICAL_BATH(GT_Recipe.GT_Recipe_Map.sChemicalBathRecipes, ItemList.Machine_HV_ChemicalBath, "chemicalbathlabel"),
        FLUID_CANNER(GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes, ItemList.Machine_HV_FluidCanner, "fluidcannerlabel"),
        BREWERY(GT_Recipe.GT_Recipe_Map.sBrewingRecipes, ItemList.Machine_HV_Brewery, "brewerylabel"),
        FLUID_HEATER(GT_Recipe.GT_Recipe_Map.sFluidHeaterRecipes, ItemList.Machine_HV_FluidHeater, "fluidheaterlabel"),
        DISTILLERY(GT_Recipe.GT_Recipe_Map.sDistilleryRecipes, ItemList.Machine_HV_Distillery, "distillerylabel"),
        FERMENTER(GT_Recipe.GT_Recipe_Map.sFermentingRecipes, ItemList.Machine_HV_Fermenter, "fermenterlabel"),
        FLUID_EXTRACTOR(GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes, ItemList.Machine_HV_FluidExtractor, "fluidextractorlabel"),
        PACKAGER(GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes, ItemList.Machine_HV_Boxinator, "packagerlabel"),
        UNPACKAGER(GT_Recipe.GT_Recipe_Map.sUnboxinatorRecipes, ItemList.Machine_HV_Unboxinator, "unpackagerlabel"),
        FUSION_REACTOR(GT_Recipe.GT_Recipe_Map.sFusionRecipes, ItemList.FusionComputer_LuV, "fusionreactorlabel"),
        CENTRIFUGE(GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes, ItemList.Machine_HV_Centrifuge, "centrifugelabel"),
        ELECTROLYZER(GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes, ItemList.Machine_HV_Electrolyzer, "electrolyzerlabel"),
        ELECTRIC_BLAST_FURNACE(GT_Recipe.GT_Recipe_Map.sBlastRecipes, ItemList.Machine_Multi_BlastFurnace, "electricblastfurnacelabel"),
        BRICKED_BLAST_FURNACE(GT_Recipe.GT_Recipe_Map.sPrimitiveBlastRecipes, ItemList.Machine_Bricked_BlastFurnace, "brickedblastfurnacelabel"),
        IMPLOSION_COMPRESSOR(GT_Recipe.GT_Recipe_Map.sImplosionRecipes, ItemList.Machine_Multi_ImplosionCompressor, "implosioncompressorlabel"),
        VACUUM_FREEZER(GT_Recipe.GT_Recipe_Map.sVacuumRecipes, ItemList.Machine_Multi_VacuumFreezer, "vacuumfreezerlabel"),
        CHEMICAL_REACTOR(GT_Recipe.GT_Recipe_Map.sChemicalRecipes, ItemList.Machine_HV_ChemicalReactor, "chemicalreactorlabel"),
        LARGE_CHEMICAL_REACTOR(GT_Recipe.GT_Recipe_Map.sMultiblockChemicalRecipes, ItemList.Machine_Multi_LargeChemicalReactor, "largechemicalreactorlabel"),
        DISTILLATION_TOWER(GT_Recipe.GT_Recipe_Map.sDistillationRecipes, ItemList.Distillation_Tower, "distillationtowerlabel"),
        OIL_CRACKER((GT_Recipe.GT_Recipe_Map)GT_Recipe.GT_Recipe_Map.sCrackingRecipes, ItemList.OilCracker, "oilcrackerlabel"),
        PYROLYSE_OVEN(GT_Recipe.GT_Recipe_Map.sPyrolyseRecipes, ItemList.PyrolyseOven, "pyrolyseovenlabel"),
        WIREMILL(GT_Recipe.GT_Recipe_Map.sWiremillRecipes, ItemList.Machine_HV_Wiremill, "wiremilllabel"),
        BENDING_MACHINE(GT_Recipe.GT_Recipe_Map.sBenderRecipes, ItemList.Machine_HV_Bender, "bendingmachinelabel"),
        ALLOY_SMELTER(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes, ItemList.Machine_HV_AlloySmelter, "alloysmelterlabel"),
        ASSEMBLING_MACHINE(GT_Recipe.GT_Recipe_Map.sAssemblerRecipes, ItemList.Machine_HV_Assembler, "assemblingmachinelabel"),
        CIRCUIT_ASSEMBLING_MACHINE(GT_Recipe.GT_Recipe_Map.sCircuitAssemblerRecipes, ItemList.Machine_HV_CircuitAssembler, "circuitassemblingmachinelabel"),
        CANNING_MACHINE(GT_Recipe.GT_Recipe_Map.sCannerRecipes, ItemList.Machine_HV_Canner, "canningmachinelabel"),
        LATHE(GT_Recipe.GT_Recipe_Map.sLatheRecipes, ItemList.Machine_HV_Lathe, "lathelabel"),
        CUTTING_MACHINE(GT_Recipe.GT_Recipe_Map.sCutterRecipes, ItemList.Machine_HV_Cutter, "cuttingmachinelabel"),
        SLICING_MACHINE(GT_Recipe.GT_Recipe_Map.sSlicerRecipes, ItemList.Machine_HV_Slicer, "slicingmachinelabel"),
        EXTRUDER(GT_Recipe.GT_Recipe_Map.sExtruderRecipes, ItemList.Machine_HV_Extruder, "extruderlabel"),
        FORGE_HAMMER(GT_Recipe.GT_Recipe_Map.sHammerRecipes, ItemList.Machine_HV_Hammer, "forgehammerlabel");

        final GT_Recipe.GT_Recipe_Map recipeMap;
        final ItemList item;
        final String tooltipKey;

        private RecipeMap(GT_Recipe.GT_Recipe_Map recipeMap, ItemList item, String tooltipKey) {
            this.recipeMap = recipeMap;
            this.item = item;
            this.tooltipKey = tooltipKey;
        }
    }
}

