/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.main;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGenerator;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.generators.debug.ruler.DebugRuler;
import com.github.dcysteine.neicustomdiagram.generators.enderstorage.chestoverview.EnderStorageChestOverview;
import com.github.dcysteine.neicustomdiagram.generators.enderstorage.tankoverview.EnderStorageTankOverview;
import com.github.dcysteine.neicustomdiagram.generators.forge.fluidcontainers.ForgeFluidContainers;
import com.github.dcysteine.neicustomdiagram.generators.forge.oredictionary.ForgeOreDictionary;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.GregTechCircuits;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses.GregTechLenses;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialparts.GregTechMaterialParts;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialtools.GregTechMaterialTools;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oredictionary.GregTechOreDictionary;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprefixes.GregTechOrePrefixes;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing.GregTechOreProcessing;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.GregTechRecipeDebugger;
import com.github.dcysteine.neicustomdiagram.main.AutoValue_Registry_RegistryEntry;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import com.github.dcysteine.neicustomdiagram.main.config.DiagramGroupVisibility;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum Registry {
    INSTANCE;

    public static final String GROUP_ID_PREFIX = "neicustomdiagram.diagramgroup.";
    private static final ImmutableList<RegistryEntry> entries;
    private ImmutableList<DiagramGenerator> generators;
    private ImmutableList<DiagramGroupInfo> infoList;

    public void initialize() {
        Logger.MOD.info("Initializing diagram groups...");
        ImmutableSet hardDisabledDiagramGroups = ImmutableSet.copyOf((Object[])ConfigOptions.HARD_DISABLED_DIAGRAM_GROUPS.get());
        ImmutableList.Builder generatorsBuilder = ImmutableList.builder();
        ImmutableList.Builder infoListBuilder = ImmutableList.builder();
        for (RegistryEntry entry : entries) {
            List<ModDependency> missingDependencies = entry.missingDependencies();
            if (!missingDependencies.isEmpty()) {
                Logger.MOD.warn("Diagram group [{}] is missing dependencies: {}", new Object[]{entry.groupId(), missingDependencies});
                continue;
            }
            if (hardDisabledDiagramGroups.contains((Object)entry.groupId())) {
                Logger.MOD.warn("Diagram group [{}] is hard-disabled.", new Object[]{entry.groupId()});
                continue;
            }
            DiagramGenerator generator = entry.get();
            infoListBuilder.add((Object)generator.info());
            generatorsBuilder.add((Object)generator);
            Logger.MOD.info("Initialized diagram group [{}]!", new Object[]{entry.groupId()});
        }
        this.generators = generatorsBuilder.build();
        this.infoList = infoListBuilder.build();
        Logger.MOD.info("Initialization complete!");
    }

    public ImmutableList<DiagramGroupInfo> infoList() {
        return this.infoList;
    }

    public void generateDiagramGroups() {
        Logger.MOD.info("Generating diagram groups...");
        for (DiagramGenerator generator : this.generators) {
            DiagramGroupInfo info = generator.info();
            if (ConfigOptions.getDiagramGroupVisibility(info) == DiagramGroupVisibility.DISABLED) {
                Logger.MOD.info("Diagram group [{}] disabled by config.", new Object[]{info.groupId()});
                continue;
            }
            Logger.MOD.info("Generating diagram group [{}]...", new Object[]{info.groupId()});
            DiagramGroup diagramGroup = generator.generate();
            API.registerRecipeHandler((ICraftingHandler)diagramGroup);
            API.registerUsageHandler((IUsageHandler)diagramGroup);
            Logger.MOD.info("Generated diagram group [{}]!", new Object[]{info.groupId()});
        }
        Logger.MOD.info("Generation complete!");
    }

    public void cleanUp() {
        this.generators = null;
    }

    static {
        ImmutableList.Builder entriesBuilder = ImmutableList.builder();
        entriesBuilder.add((Object)RegistryEntry.create("debug.ruler", DebugRuler::new, new ModDependency[0]));
        entriesBuilder.add((Object)RegistryEntry.create("enderstorage.chestoverview", EnderStorageChestOverview::new, ModDependency.ENDER_STORAGE));
        entriesBuilder.add((Object)RegistryEntry.create("enderstorage.tankoverview", EnderStorageTankOverview::new, ModDependency.ENDER_STORAGE));
        entriesBuilder.add((Object)RegistryEntry.create("forge.fluidcontainers", ForgeFluidContainers::new, new ModDependency[0]));
        entriesBuilder.add((Object)RegistryEntry.create("forge.oredictionary", ForgeOreDictionary::new, new ModDependency[0]));
        entriesBuilder.add((Object)RegistryEntry.create("gregtech.circuits", GregTechCircuits::new, ModDependency.GREGTECH_5));
        entriesBuilder.add((Object)RegistryEntry.create("gregtech.lenses", GregTechLenses::new, ModDependency.GREGTECH_5));
        entriesBuilder.add((Object)RegistryEntry.create("gregtech.materialparts", GregTechMaterialParts::new, ModDependency.GREGTECH_5));
        entriesBuilder.add((Object)RegistryEntry.create("gregtech.materialtools", GregTechMaterialTools::new, ModDependency.GREGTECH_5));
        entriesBuilder.add((Object)RegistryEntry.create("gregtech.oredictionary", GregTechOreDictionary::new, ModDependency.GREGTECH_5));
        entriesBuilder.add((Object)RegistryEntry.create("gregtech.oreprefixes", GregTechOrePrefixes::new, ModDependency.GREGTECH_5));
        entriesBuilder.add((Object)RegistryEntry.create("gregtech.oreprocessing", GregTechOreProcessing::new, ModDependency.GREGTECH_5));
        entriesBuilder.add((Object)RegistryEntry.create("gregtech.recipedebugger", GregTechRecipeDebugger::new, ModDependency.GREGTECH_5));
        entries = entriesBuilder.build();
    }

    @AutoValue
    protected static abstract class RegistryEntry {
        protected RegistryEntry() {
        }

        protected static RegistryEntry create(String groupIdSuffix, Function<String, DiagramGenerator> generatorConstructor, ModDependency ... hardDependencies) {
            return new AutoValue_Registry_RegistryEntry(Registry.GROUP_ID_PREFIX + groupIdSuffix, generatorConstructor, (ImmutableSet<ModDependency>)ImmutableSet.copyOf((Object[])hardDependencies));
        }

        protected abstract String groupId();

        protected abstract Function<String, DiagramGenerator> generatorConstructor();

        protected abstract ImmutableSet<ModDependency> hardDependencies();

        protected DiagramGenerator get() {
            return this.generatorConstructor().apply(this.groupId());
        }

        protected List<ModDependency> missingDependencies() {
            return this.hardDependencies().stream().filter(modDependency -> !modDependency.isLoaded()).collect(Collectors.toList());
        }
    }

    public static enum ModDependency {
        ENDER_STORAGE("EnderStorage"),
        GTNH_CORE_MOD("dreamcraft"),
        GREGTECH_5("gregtech"){

            @Override
            public boolean isLoaded() {
                if (super.isLoaded()) {
                    return !this.getVersion().startsWith("GT6");
                }
                return false;
            }
        }
        ,
        BARTWORKS("bartworks"),
        GT_PLUS_PLUS("miscutils"),
        DETRAV_SCANNER("detravscannermod"),
        GREGTECH_6("gregtech"){

            @Override
            public boolean isLoaded() {
                if (super.isLoaded()) {
                    return this.getVersion().startsWith("GT6");
                }
                return false;
            }
        };

        public final String modId;

        private ModDependency(String modId) {
            this.modId = modId;
        }

        public boolean isLoaded() {
            return Loader.isModLoaded((String)this.modId);
        }

        public String getVersion() {
            return this.getMod().getVersion();
        }

        public ModContainer getMod() {
            return (ModContainer)Loader.instance().getIndexedModList().get(this.modId);
        }
    }
}

