/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.draw;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.guihook.GuiContainerManager;
import com.github.dcysteine.neicustomdiagram.api.Formatter;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Grid;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TooltipLine;
import com.github.dcysteine.neicustomdiagram.api.draw.AutoValue_Draw_TextureData;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.google.auto.value.AutoValue;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public final class Draw {
    public static final int ICON_WIDTH = 16;
    public static final int TEXT_HEIGHT = 8;

    private Draw() {
    }

    public static void drawLine(Point a, Point b, int colour) {
        int x = Math.min(a.x(), b.x()) - 1;
        int y = Math.min(a.y(), b.y()) - 1;
        int w = Math.abs(a.x() - b.x()) + 2;
        int h = Math.abs(a.y() - b.y()) + 2;
        GL11.glDisable((int)2896);
        GuiDraw.drawRect((int)x, (int)y, (int)w, (int)h, (int)colour);
        GL11.glEnable((int)2896);
    }

    public static void drawArrowhead(Point a, Point b, int colour) {
        int diffX = Integer.signum(a.x() - b.x());
        int diffY = Integer.signum(a.y() - b.y());
        GL11.glDisable((int)2896);
        Point currPos = b;
        for (int i = 0; i < 3; ++i) {
            Draw.drawLine(currPos.translate(i * diffY, i * diffX), currPos.translate(-i * diffY, -i * diffX), colour);
            currPos = currPos.translate(diffX, diffY);
        }
        GL11.glEnable((int)2896);
    }

    public static void drawText(String text, Point pos, int colour, boolean small, boolean shadow) {
        int y;
        int x;
        int width = GuiDraw.getStringWidth((String)text);
        int height = 8;
        if (small) {
            width /= 2;
            height /= 2;
        }
        if (small) {
            x = 2 * pos.x() - width;
            y = 2 * pos.y() - height;
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            x = pos.x() - width / 2;
            y = pos.y() - height / 2;
        }
        GL11.glDisable((int)2896);
        GuiDraw.drawString((String)text, (int)x, (int)y, (int)colour, (boolean)shadow);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (small) {
            GL11.glPopMatrix();
        }
    }

    public static void drawStackSize(int stackSize, Point pos) {
        String text = Formatter.smartFormatInteger(stackSize);
        boolean small = stackSize >= 100;
        Draw.drawTextOverIcon(text, pos, Grid.Direction.SE, -1, small, true);
    }

    public static void drawAdditionalInfo(String text, Point pos, boolean small) {
        Draw.drawTextOverIcon(text, pos, Grid.Direction.NW, -256, small, true);
    }

    public static void drawTextOverIcon(String text, Point pos, Grid.Direction dir, int colour, boolean small, boolean shadow) {
        int textWidth = GuiDraw.getStringWidth((String)text);
        int textHeight = 8;
        if (small) {
            textWidth /= 2;
            textHeight /= 2;
        }
        Point textCenter = pos.translate(dir.xFactor * (16 - textWidth) / 2, dir.yFactor * (16 - textHeight) / 2);
        Draw.drawText(text, textCenter, colour, small, shadow);
    }

    public static void drawTooltip(Tooltip tooltip, Point mousePos) {
        if (tooltip.lines().isEmpty()) {
            return;
        }
        int width = tooltip.width();
        int height = tooltip.height();
        int x = mousePos.x() + 12;
        int y = mousePos.y() - 12;
        if (x + width > GuiDraw.displaySize().width - 8) {
            x -= tooltip.width() + 24;
        }
        if (y + height > GuiDraw.displaySize().height - 8) {
            y = GuiDraw.displaySize().height - (height + 8);
        }
        x = Math.max(8, x);
        y = Math.max(8, y);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
        GuiDraw.gui.incZLevel(300.0f);
        GuiDraw.drawTooltipBox((int)(x - 4), (int)(y - 4), (int)(tooltip.width() + 8), (int)(tooltip.height() + 8));
        int currY = y;
        for (TooltipLine line : tooltip.lines()) {
            line.draw(x, currY);
            currY += 2 + line.height();
        }
        GuiDraw.gui.incZLevel(-300.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-300.0f);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    public static void drawSlot(Point pos) {
        Draw.drawTexture(TextureData.SLOT, pos);
    }

    public static void drawBigSlot(Point pos) {
        Draw.drawTexture(TextureData.BIG_SLOT, pos);
    }

    public static void drawRaisedSlot(Point pos) {
        Draw.drawTexture(TextureData.RAISED_SLOT, pos);
    }

    public static void drawTexture(TextureData texture, Point pos) {
        GL11.glDisable((int)2896);
        GuiDraw.changeTexture((String)"neicustomdiagram:textures/slots.png");
        GuiDraw.drawTexturedModalRect((int)(pos.x() - texture.width() / 2), (int)(pos.y() - texture.height() / 2), (int)texture.x(), (int)texture.y(), (int)texture.width(), (int)texture.height());
        GL11.glEnable((int)2896);
    }

    public static void drawItem(ItemStack itemStack, Point pos) {
        GL11.glDisable((int)2896);
        GuiContainerManager.drawItem((int)(pos.x() - 8), (int)(pos.y() - 8), (ItemStack)itemStack);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawFluid(Fluid fluid, Point pos) {
        IIcon icon = fluid.getIcon();
        if (icon == null) {
            return;
        }
        int colour = fluid.getColor();
        GL11.glColor3ub((byte)((byte)((colour & 0xFF0000) >> 16)), (byte)((byte)((colour & 0xFF00) >> 8)), (byte)((byte)(colour & 0xFF)));
        GL11.glDisable((int)2896);
        GuiDraw.changeTexture((ResourceLocation)TextureMap.field_110575_b);
        GuiDraw.gui.func_94065_a(pos.x() - 8, pos.y() - 8, icon, 16, 16);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawOverlay(Point pos, int colour) {
        GL11.glDisable((int)2896);
        GuiDraw.drawRect((int)(pos.x() - 8), (int)(pos.y() - 8), (int)16, (int)16, (int)colour);
        GL11.glEnable((int)2896);
    }

    @AutoValue
    public static abstract class TextureData {
        private static final String TEXTURE_PATH = "neicustomdiagram:textures/slots.png";
        public static final TextureData SLOT = TextureData.create(0, 0, 18, 18);
        public static final TextureData BIG_SLOT = TextureData.create(18, 0, 26, 26);
        public static final TextureData RAISED_SLOT = TextureData.create(0, 18, 18, 18);

        private static TextureData create(int x, int y, int w, int h) {
            return new AutoValue_Draw_TextureData(x, y, w, h);
        }

        abstract int x();

        abstract int y();

        abstract int width();

        abstract int height();
    }

    public static final class Colour {
        public static final int BLACK = -16777216;
        public static final int WHITE = -1;
        public static final int GREY = -12566464;
        public static final int RED = -65536;
        public static final int GREEN = -16744448;
        public static final int BLUE = -16776961;
        public static final int CYAN = -16711681;
        public static final int YELLOW = -256;
        public static final int MAGENTA = -65281;
        public static final int GUI_BG = -3750202;
        public static final int SLOT_BG = -7631989;
        public static final int OVERLAY_WHITE = -2130706433;
        public static final int OVERLAY_BLUE = -2147483393;

        private Colour() {
        }
    }
}

