/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.tooltip;

import codechicken.lib.gui.GuiDraw;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.AutoOneOf_TooltipElement;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TextFormatting;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.google.auto.value.AutoOneOf;

@AutoOneOf(value=ElementType.class)
public abstract class TooltipElement {
    public static TooltipElement ofSpacing(int spacing) {
        return AutoOneOf_TooltipElement.spacing(spacing);
    }

    public static TooltipElement ofText(String text) {
        return AutoOneOf_TooltipElement.text(text);
    }

    public static TooltipElement ofDisplayComponentIcon(DisplayComponent displayComponent) {
        return AutoOneOf_TooltipElement.displayComponentIcon(displayComponent);
    }

    public static TooltipElement ofComponentIcon(Component component) {
        return AutoOneOf_TooltipElement.displayComponentIcon(DisplayComponent.builder(component).build());
    }

    public static TooltipElement ofComponentDescription(Component component) {
        return AutoOneOf_TooltipElement.componentDescription(component);
    }

    public static TooltipElement ofFormatting(TextFormatting formatting) {
        return AutoOneOf_TooltipElement.formatting(formatting);
    }

    public abstract ElementType type();

    public abstract int spacing();

    public abstract String text();

    public abstract DisplayComponent displayComponentIcon();

    public abstract Component componentDescription();

    public abstract TextFormatting formatting();

    public int width(TextFormatting formatting) {
        switch (this.type()) {
            case SPACING: {
                return this.spacing();
            }
            case TEXT: {
                if (formatting.small()) {
                    return GuiDraw.getStringWidth((String)formatting.format(this.text())) / 2;
                }
                return GuiDraw.getStringWidth((String)formatting.format(this.text()));
            }
            case DISPLAY_COMPONENT_ICON: {
                return 18;
            }
            case COMPONENT_DESCRIPTION: {
                return GuiDraw.getStringWidth((String)this.componentDescription().description());
            }
            case FORMATTING: {
                return 0;
            }
        }
        throw new IllegalStateException("Unhandled element type: " + this);
    }

    public int height(TextFormatting formatting) {
        switch (this.type()) {
            case SPACING: 
            case FORMATTING: {
                return 0;
            }
            case TEXT: 
            case COMPONENT_DESCRIPTION: {
                if (formatting.small()) {
                    return 4;
                }
                return 8;
            }
            case DISPLAY_COMPONENT_ICON: {
                return 18;
            }
        }
        throw new IllegalStateException("Unhandled element type: " + this);
    }

    public void draw(int x, int y, TextFormatting formatting) {
        Point center = Point.create(x + this.width(formatting) / 2, y + this.height(formatting) / 2);
        switch (this.type()) {
            case TEXT: {
                Draw.drawText(formatting.format(this.text()), center, -1, formatting.small(), true);
                break;
            }
            case DISPLAY_COMPONENT_ICON: {
                Draw.drawSlot(center);
                this.displayComponentIcon().draw(center);
                break;
            }
            case COMPONENT_DESCRIPTION: {
                Draw.drawText(formatting.format(this.componentDescription().description()), center, -1, formatting.small(), true);
            }
        }
    }

    public static enum ElementType {
        SPACING,
        TEXT,
        DISPLAY_COMPONENT_ICON,
        COMPONENT_DESCRIPTION,
        FORMATTING;

    }
}

