/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.util;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class ComponentTransformer {
    private ComponentTransformer() {
    }

    public static boolean equals(DisplayComponent displayComponent, Component component) {
        return displayComponent.component().equals(component);
    }

    public static DisplayComponent transformToDisplay(Component component) {
        return DisplayComponent.builder(component).build();
    }

    public static Component transformFromDisplay(DisplayComponent displayComponent) {
        return displayComponent.component();
    }

    public static List<DisplayComponent> transformToDisplay(Collection<? extends Component> components) {
        return components.stream().map(ComponentTransformer::transformToDisplay).collect(Collectors.toList());
    }

    public static List<Component> transformFromDisplay(Collection<DisplayComponent> displayComponents) {
        return displayComponents.stream().map(ComponentTransformer::transformFromDisplay).distinct().collect(Collectors.toList());
    }

    public static boolean containsComponent(Collection<DisplayComponent> displayComponents, Component component) {
        return displayComponents.stream().anyMatch(displayComponent -> ComponentTransformer.equals(displayComponent, component));
    }

    public static boolean containsDisplayComponent(Collection<? extends Component> components, DisplayComponent displayComponent) {
        return components.stream().anyMatch(component -> ComponentTransformer.equals(displayComponent, component));
    }

    public static boolean containsAllComponents(Collection<DisplayComponent> displayComponents, Iterable<? extends Component> components) {
        for (Component component : components) {
            if (ComponentTransformer.containsComponent(displayComponents, component)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAllDisplayComponents(Collection<? extends Component> components, Iterable<DisplayComponent> displayComponents) {
        for (DisplayComponent displayComponent : displayComponents) {
            if (ComponentTransformer.containsDisplayComponent(components, displayComponent)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAllComponents(Collection<DisplayComponent> displayComponents, Component ... components) {
        return ComponentTransformer.containsAllComponents(displayComponents, Arrays.asList(components));
    }

    public static boolean containsAllDisplayComponents(Collection<? extends Component> components, DisplayComponent ... displayComponents) {
        return ComponentTransformer.containsAllDisplayComponents(components, Arrays.asList(displayComponents));
    }

    public static boolean removeComponent(Collection<DisplayComponent> displayComponents, Component component) {
        return displayComponents.removeIf(displayComponent -> ComponentTransformer.equals(displayComponent, component));
    }

    public static boolean removeDisplayComponent(Collection<? extends Component> components, DisplayComponent displayComponent) {
        return components.removeIf(component -> ComponentTransformer.equals(displayComponent, component));
    }

    public static boolean removeAllComponents(Collection<DisplayComponent> displayComponents, Iterable<? extends Component> components) {
        boolean anythingRemoved = false;
        for (Component component : components) {
            anythingRemoved |= ComponentTransformer.removeComponent(displayComponents, component);
        }
        return anythingRemoved;
    }

    public static boolean removeAllDisplayComponents(Collection<? extends Component> components, Iterable<DisplayComponent> displayComponents) {
        boolean anythingRemoved = false;
        for (DisplayComponent displayComponent : displayComponents) {
            anythingRemoved |= ComponentTransformer.removeDisplayComponent(components, displayComponent);
        }
        return anythingRemoved;
    }

    public static boolean removeAllComponents(Collection<DisplayComponent> displayComponents, Component ... components) {
        return ComponentTransformer.removeAllComponents(displayComponents, Arrays.asList(components));
    }

    public static boolean removeAllDisplayComponents(Collection<? extends Component> components, DisplayComponent ... displayComponents) {
        return ComponentTransformer.removeAllDisplayComponents(components, Arrays.asList(displayComponents));
    }
}

