/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.draw.scroll;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.recipe.GuiRecipe;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.api.draw.scroll.MouseButton;
import com.github.dcysteine.neicustomdiagram.api.draw.scroll.ScrollDirection;
import com.github.dcysteine.neicustomdiagram.api.draw.scroll.ScrollOrientation;
import com.github.dcysteine.neicustomdiagram.api.draw.scroll.Scrollbar;
import com.github.dcysteine.neicustomdiagram.main.Reflection;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import java.nio.FloatBuffer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public final class ScrollManager {
    static final int TOP_MARGIN = 31;
    static final int BOTTOM_MARGIN = 5;
    static final int SIDE_MARGIN = 4;
    static final int SCISSOR_MODELVIEW_OFFSET_X = -2;
    static final int SCISSOR_MODELVIEW_OFFSET_Y = 32;
    private final Scrollbar verticalScrollbar = new Scrollbar(this, ScrollOrientation.VERTICAL);
    private final Scrollbar horizontalScrollbar = new Scrollbar(this, ScrollOrientation.HORIZONTAL);

    public boolean keyboardScroll(Dimension diagramDimension, ScrollDirection direction) {
        boolean handled = this.verticalScrollbar.scroll(direction, ConfigOptions.KEYBOARD_SCROLL_SPEED.get());
        return handled |= this.horizontalScrollbar.scroll(direction, ConfigOptions.KEYBOARD_SCROLL_SPEED.get());
    }

    public boolean mouseScroll(ScrollDirection direction) {
        if (this.horizontalScrollbar.mouseInScrollBounds()) {
            ScrollDirection horizontalDirection;
            switch (direction) {
                case UP: {
                    horizontalDirection = ScrollDirection.LEFT;
                    break;
                }
                case DOWN: {
                    horizontalDirection = ScrollDirection.RIGHT;
                    break;
                }
                default: {
                    horizontalDirection = direction;
                }
            }
            return this.horizontalScrollbar.scroll(horizontalDirection, ConfigOptions.MOUSE_SCROLL_SPEED.get());
        }
        if (this.verticalScrollbar.mouseInScrollBounds() || this.mouseInDiagramBounds()) {
            return this.verticalScrollbar.scroll(direction, ConfigOptions.MOUSE_SCROLL_SPEED.get());
        }
        return false;
    }

    public boolean mouseClickScrollbar(MouseButton button) {
        boolean handled = this.verticalScrollbar.mouseClickScrollbar(button);
        return handled |= this.horizontalScrollbar.mouseClickScrollbar(button);
    }

    public boolean mouseInDiagramBounds() {
        Point mousePos = this.getAbsoluteMousePosition();
        Point viewportPos = this.getViewportPosition();
        int xDiff = mousePos.x() - viewportPos.x();
        int yDiff = mousePos.y() - viewportPos.y();
        Dimension viewportDim = this.getViewportDimension();
        return xDiff >= 0 && xDiff <= viewportDim.width() && yDiff >= 0 && yDiff <= viewportDim.height();
    }

    public Point getAbsoluteMousePosition() {
        java.awt.Point mouse = GuiDraw.getMousePosition();
        return Point.create(mouse.x, mouse.y);
    }

    public Point getRelativeMousePosition(int recipe) {
        Optional<GuiRecipe<?>> guiOptional = this.getGui();
        if (!guiOptional.isPresent()) {
            return Point.create(0, 0);
        }
        GuiRecipe<?> gui = guiOptional.get();
        if (gui.isLimitedToOneRecipe()) {
            return Point.create(0, 0);
        }
        java.awt.Point mouse = GuiDraw.getMousePosition();
        java.awt.Point offset = gui.getRecipePosition(recipe);
        int x = mouse.x + this.horizontalScrollbar.getScroll() - (Reflection.GUI_LEFT.get((GuiContainer)gui) + offset.x);
        int y = mouse.y + this.verticalScrollbar.getScroll() - (Reflection.GUI_TOP.get((GuiContainer)gui) + offset.y);
        return Point.create(x, y);
    }

    Point getViewportPosition() {
        Optional<GuiRecipe<?>> guiOptional = this.getGui();
        if (!guiOptional.isPresent()) {
            return Point.create(0, 0);
        }
        GuiRecipe<?> gui = guiOptional.get();
        return Point.create(Reflection.GUI_LEFT.get((GuiContainer)gui) + 4, Reflection.GUI_TOP.get((GuiContainer)gui) + 31);
    }

    Dimension getViewportDimension() {
        Optional<GuiRecipe<?>> guiOptional = this.getGui();
        if (!guiOptional.isPresent()) {
            return Dimension.create(0, 0);
        }
        GuiRecipe<?> gui = guiOptional.get();
        return Dimension.create(Reflection.X_SIZE.get((GuiContainer)gui) - 8, Reflection.Y_SIZE.get((GuiContainer)gui) - 36);
    }

    private void setScissor() {
        Optional<GuiRecipe<?>> guiOptional = this.getGui();
        if (!guiOptional.isPresent()) {
            return;
        }
        GuiRecipe<?> gui = guiOptional.get();
        FloatBuffer matBuf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)matBuf);
        int guiLeft = (int)matBuf.get(12);
        int guiTop = (int)matBuf.get(13);
        int left = guiLeft + 4 + -2;
        int bottom = gui.field_146295_m - (guiTop + Reflection.Y_SIZE.get((GuiContainer)gui)) + 5 + 32;
        Minecraft minecraft = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        int scaleFactor = res.func_78325_e();
        Dimension viewportDim = this.getViewportDimension();
        GL11.glScissor((int)(left * scaleFactor), (int)(bottom * scaleFactor), (int)(viewportDim.width() * scaleFactor), (int)(viewportDim.height() * scaleFactor));
    }

    private Optional<GuiRecipe<?>> getGui() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(screen instanceof GuiRecipe)) {
            return Optional.empty();
        }
        return Optional.of((GuiRecipe)screen);
    }

    public void tick() {
        this.verticalScrollbar.tick();
        this.horizontalScrollbar.tick();
    }

    public void refreshState(Dimension diagramDimension) {
        this.horizontalScrollbar.refreshState(diagramDimension);
        this.verticalScrollbar.refreshState(diagramDimension);
    }

    public void beforeDraw() {
        GL11.glPushMatrix();
        this.setScissor();
        GL11.glTranslatef((float)(-this.horizontalScrollbar.getScroll()), (float)(-this.verticalScrollbar.getScroll()), (float)0.0f);
        GL11.glEnable((int)3089);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void afterDraw() {
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
    }

    public void drawScrollbars() {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GuiDraw.gui.incZLevel(300.0f);
        this.horizontalScrollbar.draw();
        this.verticalScrollbar.draw();
        GuiDraw.gui.incZLevel(-300.0f);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }
}

