/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.layout;

import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.AutoValue_SlotGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Grid;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Slot;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Drawable;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.toprettystring.ToPrettyString;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@AutoValue
public abstract class SlotGroup
implements Drawable {
    public static Slot.Builder slotBuilder() {
        return Slot.builder(Point.create(0, 0));
    }

    public abstract int width();

    public abstract int height();

    public abstract ImmutableList<Slot> slots();

    public Slot slot(int x, int y) {
        return (Slot)this.slots().get(x + y * this.width());
    }

    @Override
    public Dimension maxDimension() {
        return Drawable.computeMaxDimension(this.slots());
    }

    @Override
    public void draw(DiagramState diagramState) {
        this.slots().forEach(slot -> slot.draw(diagramState));
    }

    @ToPrettyString
    public abstract String toPrettyString();

    public static Builder builder(int width, int height, Point pos, Grid.Direction dir) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (String)"Width too small: %d", (Object[])new Object[]{width});
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (String)"Height too small: %d", (Object[])new Object[]{height});
        return new Builder(width, height, pos, dir);
    }

    public static final class Builder {
        private final int width;
        private final int height;
        private final Point position;
        private final Grid.Direction direction;
        private int slotWidth;
        private Tooltip defaultTooltip;
        private BiConsumer<DiagramState, Point> defaultDrawFunction;
        private final Slot[][] slots;

        private Builder(int width, int height, Point position, Grid.Direction direction) {
            this.width = width;
            this.height = height;
            this.position = position;
            this.direction = direction;
            this.slotWidth = 18;
            this.defaultTooltip = Tooltip.EMPTY_TOOLTIP;
            this.defaultDrawFunction = (ticker, point) -> Draw.drawSlot(point);
            this.slots = new Slot[width][height];
        }

        public Builder setSlotWidth(int slotWidth) {
            Preconditions.checkArgument((slotWidth > 0 ? 1 : 0) != 0, (String)"Slot width too small: %d", (Object[])new Object[]{slotWidth});
            this.slotWidth = slotWidth;
            return this;
        }

        public Builder setDefaultTooltip(Tooltip tooltip) {
            this.defaultTooltip = tooltip;
            return this;
        }

        public Builder setDefaultDrawFunction(BiConsumer<DiagramState, Point> defaultDrawFunction) {
            this.defaultDrawFunction = defaultDrawFunction;
            return this;
        }

        public Builder setDefaultDrawFunction(Consumer<Point> defaultDrawFunction) {
            this.defaultDrawFunction = (ticker, point) -> defaultDrawFunction.accept((Point)point);
            return this;
        }

        public Builder setSlot(int x, int y, Slot slot) {
            this.slots[x][y] = slot;
            return this;
        }

        public SlotGroup build() {
            ImmutableList.Builder slotsBuilder = ImmutableList.builder();
            int offsetX = (this.direction.xFactor - 1) * (this.width - 1) * this.slotWidth / 2;
            int offsetY = (this.direction.yFactor - 1) * (this.height - 1) * this.slotWidth / 2;
            Point topLeft = this.position.translate(offsetX, offsetY);
            for (int j = 0; j < this.height; ++j) {
                for (int i = 0; i < this.width; ++i) {
                    Point currPos = topLeft.translate(i * this.slotWidth, j * this.slotWidth);
                    Slot.Builder slotBuilder = this.slots[i][j] != null ? this.slots[i][j].toBuilder().setPosition(currPos) : Slot.builder(currPos).setSlotWidth(this.slotWidth).setTooltip(this.defaultTooltip).setDrawFunction(this.defaultDrawFunction);
                    slotsBuilder.add((Object)slotBuilder.build());
                }
            }
            return new AutoValue_SlotGroup(this.width, this.height, (ImmutableList<Slot>)slotsBuilder.build());
        }
    }
}

