/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.main;

import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.main.NeiIntegration;
import com.github.dcysteine.neicustomdiagram.main.Registry;
import com.github.dcysteine.neicustomdiagram.main.config.Config;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigGuiFactory;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="neicustomdiagram", name="NEI Custom Diagram", version="1.7.10", dependencies="required-after:NotEnoughItems;after:dreamcraft;after:gregtech;after:bartworks;after:miscutils;after:detravscannermod;after:MineTweaker3;", guiFactory="com.github.dcysteine.neicustomdiagram.main.config.ConfigGuiFactory")
public final class NeiCustomDiagram {
    public static final String MOD_ID = "neicustomdiagram";
    public static final String MOD_NAME = "NEI Custom Diagram";
    public static final String MOD_VERSION = "1.7.10";
    public static final String MOD_DEPENDENCIES = "required-after:NotEnoughItems;after:dreamcraft;after:gregtech;after:bartworks;after:miscutils;after:detravscannermod;after:MineTweaker3;";
    @Mod.Instance(value="neicustomdiagram")
    public static NeiCustomDiagram instance;
    private boolean hasGenerated = false;

    @Mod.EventHandler
    public void onInitialization(FMLInitializationEvent event) {
        if (event.getSide() != Side.CLIENT) {
            return;
        }
        Logger.MOD.info("Mod initialization starting...");
        ConfigGuiFactory.checkClassName();
        Config.initialize();
        Registry.INSTANCE.initialize();
        Config.initializeDiagramGroupVisibility(Registry.INSTANCE.infoList());
        Config.saveConfig();
        NeiIntegration.INSTANCE.initialize((List<DiagramGroupInfo>)Registry.INSTANCE.infoList());
        MinecraftForge.EVENT_BUS.register((Object)NeiIntegration.INSTANCE);
        if (ConfigOptions.GENERATE_DIAGRAMS_ON_CLIENT_CONNECT.get().booleanValue()) {
            FMLCommonHandler.instance().bus().register((Object)this);
        }
        Logger.MOD.info("Mod initialization complete!");
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        if (event.getSide() != Side.CLIENT || ConfigOptions.GENERATE_DIAGRAMS_ON_CLIENT_CONNECT.get().booleanValue()) {
            return;
        }
        Logger.MOD.info("Mod post-load starting...");
        Registry.INSTANCE.generateDiagramGroups();
        Registry.INSTANCE.cleanUp();
        this.hasGenerated = true;
        Logger.MOD.info("Mod post-load complete!");
    }

    @SubscribeEvent
    public void onClientConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!ConfigOptions.GENERATE_DIAGRAMS_ON_CLIENT_CONNECT.get().booleanValue() || this.hasGenerated) {
            return;
        }
        Logger.MOD.info("Mod pre-connect starting...");
        Registry.INSTANCE.generateDiagramGroups();
        Registry.INSTANCE.cleanUp();
        this.hasGenerated = true;
        Logger.MOD.info("Mod pre-connect complete!");
    }
}

