/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.draw;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.main.Reflection;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.opengl.GL11;

public final class GuiManager {
    private static final int TOP_MARGIN = 31;
    private static final int BOTTOM_MARGIN = 5;
    private static final int SIDE_MARGIN = 4;
    private static final int VERTICAL_PADDING = 2;
    private static final int SCROLLBAR_MOUSEOVER_PADDING = 2;
    private static final int SCROLLBAR_FADE_TICKS = 24;
    private static final int SCROLLBAR_FOREGROUND_COLOUR = 1334688;
    private static final int SCROLLBAR_FOREGROUND_SELECTED_COLOUR = 3050432;
    private static final int SCROLLBAR_BACKGROUND_COLOUR = 11654368;
    private static final int SCROLLBAR_FOREGROUND_COLOUR_OPACITY = 240;
    private static final int SCROLLBAR_BACKGROUND_COLOUR_OPACITY = 144;
    private int scrollX = 0;
    private int scrollY = 0;
    private boolean scrollbarSelected = false;
    private int scrollbarFade = 24;

    public void tick() {
        if (this.scrollbarFade > 0) {
            --this.scrollbarFade;
        }
    }

    public void checkScrollState(Dimension diagramDimension) {
        int scrollableHeight = this.computeScrollableHeight(diagramDimension);
        if (scrollableHeight <= 0) {
            this.scrollY = 0;
            this.scrollbarSelected = false;
            this.scrollbarFade = 0;
            return;
        }
        if (this.mouseInScrollBounds()) {
            this.scrollbarFade = 24;
        }
        if (this.scrollbarSelected) {
            this.scrollToMouse(diagramDimension);
        }
        if (this.scrollY > scrollableHeight) {
            this.scrollY = scrollableHeight;
        } else if (this.scrollY < 0) {
            this.scrollY = 0;
        }
    }

    public void beforeDraw(Dimension diagramDimension) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-this.scrollX), (float)(-this.scrollY), (float)0.0f);
        this.setScissor();
        GL11.glEnable((int)3089);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void afterDraw(Dimension diagramDimension) {
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
    }

    public void drawScrollbar(Dimension diagramDimension) {
        if (this.scrollbarFade <= 0) {
            return;
        }
        int fade = Math.min(2 * this.scrollbarFade, 24);
        int fgOpacity = 240 * fade / 24;
        int bgOpacity = 144 * fade / 24;
        int fgColour = this.scrollbarSelected ? 3050432 : 1334688;
        fgColour |= fgOpacity << 24;
        int bgColour = 0xB1D4E0 | bgOpacity << 24;
        Point viewportPos = this.getViewportPosition();
        Dimension viewportDim = this.getViewportDimension();
        int scrollbarX = viewportPos.x() + viewportDim.width() + 7;
        int scrollbarY = viewportPos.y();
        int scrollbarCursorHeight = viewportDim.height() * viewportDim.height() / diagramDimension.height();
        int scrollbarCursorY = scrollbarY + this.scrollY * viewportDim.height() / diagramDimension.height();
        int scrollbarCursorBottom = --scrollbarCursorY + (scrollbarCursorHeight += 2);
        int scrollbarAboveHeight = scrollbarCursorY - scrollbarY;
        int scrollbarBelowHeight = scrollbarY + viewportDim.height() - scrollbarCursorBottom;
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GuiDraw.gui.incZLevel(300.0f);
        if (scrollbarAboveHeight > 0) {
            GuiDraw.drawRect((int)scrollbarX, (int)scrollbarY, (int)2, (int)scrollbarAboveHeight, (int)bgColour);
        }
        GuiDraw.drawRect((int)(scrollbarX - 2), (int)scrollbarCursorY, (int)6, (int)scrollbarCursorHeight, (int)fgColour);
        if (scrollbarBelowHeight > 0) {
            GuiDraw.drawRect((int)scrollbarX, (int)scrollbarCursorBottom, (int)2, (int)scrollbarBelowHeight, (int)bgColour);
        }
        GuiDraw.gui.incZLevel(-300.0f);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public boolean mouseInBounds() {
        Point mousePos = this.getAbsoluteMousePosition();
        Point viewportPos = this.getViewportPosition();
        int xDiff = mousePos.x() - viewportPos.x();
        int yDiff = mousePos.y() - viewportPos.y();
        Dimension viewportDim = this.getViewportDimension();
        return xDiff >= 0 && xDiff <= viewportDim.width() && yDiff >= 0 && yDiff <= viewportDim.height();
    }

    public boolean mouseInScrollBounds() {
        Point viewportPos = this.getViewportPosition();
        Dimension viewportDim = this.getViewportDimension();
        int scrollbarX = viewportPos.x() + viewportDim.width() + 5 - 2;
        int scrollbarY = viewportPos.y() - 2;
        int scrollbarWidth = 8;
        int scrollbarHeight = viewportDim.height() + 4;
        Point mousePos = this.getAbsoluteMousePosition();
        int xDiff = mousePos.x() - scrollbarX;
        int yDiff = mousePos.y() - scrollbarY;
        return xDiff >= 0 && xDiff <= scrollbarWidth && yDiff >= 0 && yDiff <= scrollbarHeight;
    }

    public Point getAbsoluteMousePosition() {
        java.awt.Point mouse = GuiDraw.getMousePosition();
        return Point.create(mouse.x, mouse.y);
    }

    public Point getRelativeMousePosition(int recipe) {
        GuiRecipe gui = this.getGui();
        java.awt.Point mouse = GuiDraw.getMousePosition();
        java.awt.Point offset = gui.getRecipePosition(recipe);
        int x = mouse.x + this.scrollX - (Reflection.GUI_LEFT.get((GuiContainer)gui) + offset.x);
        int y = mouse.y + this.scrollY - (Reflection.GUI_TOP.get((GuiContainer)gui) + offset.y);
        return Point.create(x, y);
    }

    public boolean isScrollable(Dimension diagramDimension) {
        return this.computeScrollableHeight(diagramDimension) > 0;
    }

    public void scroll(ScrollDirection direction) {
        int scrollAmount = direction.factor * ConfigOptions.SCROLL_SPEED.get();
        this.scrollY += scrollAmount;
        this.scrollbarFade = 24;
    }

    public boolean mouseClickScrollbar(MouseButton button, Dimension diagramDimension) {
        if (!this.mouseInScrollBounds() && !this.scrollbarSelected) {
            return false;
        }
        switch (button) {
            case LEFT: {
                this.scrollbarSelected = !this.scrollbarSelected;
                return true;
            }
            case RIGHT: {
                this.scrollToMouse(diagramDimension);
                return true;
            }
        }
        return false;
    }

    public void scrollToMouse(Dimension diagramDimension) {
        Dimension viewportDim = this.getViewportDimension();
        int scrollbarCursorHeight = viewportDim.height() * viewportDim.height() / diagramDimension.height();
        int mouseOffset = this.getAbsoluteMousePosition().y() - (this.getViewportPosition().y() + scrollbarCursorHeight / 2);
        int scrollbarHeight = viewportDim.height() - scrollbarCursorHeight;
        this.scrollY = mouseOffset * this.computeScrollableHeight(diagramDimension) / scrollbarHeight;
        this.scrollbarFade = 24;
    }

    public Point getViewportPosition() {
        GuiRecipe gui = this.getGui();
        return Point.create(Reflection.GUI_LEFT.get((GuiContainer)gui) + 4, Reflection.GUI_TOP.get((GuiContainer)gui) + 31);
    }

    public Dimension getViewportDimension() {
        GuiRecipe gui = this.getGui();
        return Dimension.create(Reflection.X_SIZE.get((GuiContainer)gui) - 8, Reflection.Y_SIZE.get((GuiContainer)gui) - 36);
    }

    private int computeScrollableHeight(Dimension diagramDimension) {
        return diagramDimension.height() + 2 - this.getViewportDimension().height();
    }

    private void setScissor() {
        GuiRecipe gui = this.getGui();
        int left = Reflection.GUI_LEFT.get((GuiContainer)gui) + 4;
        int bottom = gui.field_146295_m - (Reflection.GUI_TOP.get((GuiContainer)gui) + Reflection.Y_SIZE.get((GuiContainer)gui)) + 5;
        Minecraft minecraft = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        int scaleFactor = res.func_78325_e();
        Dimension viewportDim = this.getViewportDimension();
        GL11.glScissor((int)(left * scaleFactor), (int)(bottom * scaleFactor), (int)(viewportDim.width() * scaleFactor), (int)(viewportDim.height() * scaleFactor));
    }

    private GuiRecipe getGui() {
        return (GuiRecipe)GuiContainerManager.getManager().window;
    }

    public static enum MouseButton {
        LEFT,
        RIGHT;

    }

    public static enum ScrollDirection {
        UP(-1),
        DOWN(1);

        public final int factor;

        private ScrollDirection(int factor) {
            this.factor = factor;
        }
    }
}

