/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.layout;

import com.github.dcysteine.neicustomdiagram.api.diagram.layout.AutoValue_Grid;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class Grid {
    public static final Grid GRID = Grid.create(0, 0);
    public static final int TOTAL_WIDTH = 166;
    public static final int TOTAL_HEIGHT = 332;
    public static final int STACK_WIDTH = 16;
    public static final int SLOT_WIDTH = 18;
    public static final int BIG_SLOT_WIDTH = 26;
    public static final int MARGIN_WIDTH = 6;
    public static final int SIDE_MARGIN_WIDTH = 2;
    public static final int GRID_WIDTH = 7;
    public static final int GRID_HEIGHT = 14;

    public static Grid create(int offsetX, int offsetY) {
        return Grid.create(Point.create(offsetX, offsetY));
    }

    public static Grid create(Point offset) {
        return new AutoValue_Grid(offset);
    }

    public abstract Point offset();

    public Point grid(int x, int y) {
        int gridX = 2 + (18 + x * 24) / 2;
        int gridY = 2 + (18 + y * 24) / 2;
        return this.offset().translate(gridX, gridY);
    }

    public Point margin(int x, int y, Direction dir) {
        return Grid.margin(this.grid(x, y), dir);
    }

    public Point edge(int x, int y, Direction dir) {
        return Grid.edge(this.grid(x, y), dir);
    }

    public Point bigEdge(int x, int y, Direction dir) {
        return Grid.bigEdge(this.grid(x, y), dir);
    }

    public static Point margin(Point pos, Direction dir) {
        int offsetX = dir.xFactor * 24 / 2;
        int offsetY = dir.yFactor * 24 / 2;
        return pos.translate(offsetX, offsetY);
    }

    public static Point edge(Point pos, Direction dir) {
        int offsetX = dir.xFactor * 18 / 2;
        int offsetY = dir.yFactor * 18 / 2;
        return pos.translate(offsetX, offsetY);
    }

    public static Point bigEdge(Point pos, Direction dir) {
        int offsetX = dir.xFactor * 26 / 2;
        int offsetY = dir.yFactor * 26 / 2;
        return pos.translate(offsetX, offsetY);
    }

    public static enum Direction {
        NW(-1, -1),
        N(0, -1),
        NE(1, -1),
        W(-1, 0),
        C(0, 0),
        E(1, 0),
        SW(-1, 1),
        S(0, 1),
        SE(1, 1);

        public final int xFactor;
        public final int yFactor;

        private Direction(int xFactor, int yFactor) {
            this.xFactor = xFactor;
            this.yFactor = yFactor;
        }
    }
}

