/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.crafting;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import net.bdew.neiaddons.BaseAddon;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.crafting.AddonCraftingTablesClient;
import net.minecraft.client.gui.inventory.GuiContainer;

@Mod(modid="NEIAddons|CraftingTables", name="NEI Addons: Crafting Tables", version="GRADLETOKEN_VERSION", dependencies="after:NEIAddons")
public class AddonCraftingTables
extends BaseAddon {
    public static Collection<Class<? extends GuiContainer>> craftingTables;

    @Override
    public String getName() {
        return "Crafting Tables";
    }

    @Override
    public boolean checkSide(Side side) {
        return side.isClient();
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        this.doPreInit(ev);
    }

    public void tryLoadTableClass(String modId, String className, String humanName) {
        try {
            if (this.verifyModVersion(modId)) {
                craftingTables.add(Utils.getAndCheckClass(className, GuiContainer.class));
                this.logInfo("Registered %s", humanName);
            } else {
                this.logInfo("Not registering %s", humanName);
            }
        }
        catch (Throwable e) {
            this.logWarningExc(e, "Registering %s failed", humanName);
        }
    }

    @Override
    public void init(Side side) throws Exception {
        craftingTables = new ArrayList<Class<? extends GuiContainer>>();
        this.tryLoadTableClass("EE3", "com.pahimar.ee3.client.gui.inventory.GuiPortableCrafting", "EE3 Minium Stone");
        this.tryLoadTableClass("BuildCraft|Factory", "buildcraft.factory.gui.GuiAutoCrafting", "BC Autorcrafting Table");
        this.tryLoadTableClass("powersuitaddons", "com.qmxtech.powersuitaddons.client.PortableCraftingGui", "MPSA In-Place Assembler");
        this.tryLoadTableClass("ProjectE", "moze_intel.projecte.gameObjs.gui.GUIPhilosStone", "ProjectE Philosopher Stone");
        this.tryLoadTableClass("BiblioCraft", "jds.bibliocraft.gui.GuiFancyWorkbench", "BiblioCraft Fancy Workbench");
        this.tryLoadTableClass("RIO", "remoteio.client.gui.GuiIntelligentWorkbench", "RemoteIO Intelligent Workbench");
        this.tryLoadTableClass("Railcraft", "mods.railcraft.client.gui.GuiCartWork", "Railcraft Work Cart");
        if (craftingTables.size() > 0) {
            this.logInfo("%d crafting tables registered", craftingTables.size());
            this.active = true;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void loadClient() {
        AddonCraftingTablesClient.load();
    }
}

