/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import yalter.mousetweaks.Config;
import yalter.mousetweaks.Constants;
import yalter.mousetweaks.DeobfuscationLayer;
import yalter.mousetweaks.ModCompatibility;

public class Main
extends DeobfuscationLayer {
    public static boolean DisableRMBTweak = false;
    public static int RMBTweak = 0;
    public static int LMBTweakWithItem = 0;
    public static int LMBTweakWithoutItem = 0;
    public static int WheelTweak = 0;
    public static int WheelSearchOrder = 1;
    public static Config mainConfig;
    private static GuiScreen oldGuiScreen;
    private static Object container;
    private static Slot oldSelectedSlot;
    private static Slot firstSlot;
    private static ItemStack oldStackOnMouse;
    private static boolean firstSlotClicked;
    private static boolean shouldClick;
    private static boolean disableForThisContainer;
    private static boolean disableWheelForThisContainer;
    private static int guiContainerID;
    private static boolean readConfig;

    public static void initialise() {
        mc = Minecraft.func_71410_x();
        mainConfig = new Config(Main.mc.field_71412_D + File.separator + "config" + File.separator + "MouseTweaks.cfg");
        Main.readConfigFile();
        ModCompatibility.initialize();
        Constants.LOGGER.info("Mouse Tweaks has been initialised.");
    }

    public static void readConfigFile() {
        boolean loadedConfig = mainConfig.readConfig();
        RMBTweak = mainConfig.getOrCreateIntProperty("RMBTweak", 1);
        LMBTweakWithItem = mainConfig.getOrCreateIntProperty("LMBTweakWithItem", 1);
        LMBTweakWithoutItem = mainConfig.getOrCreateIntProperty("LMBTweakWithoutItem", 1);
        WheelTweak = mainConfig.getOrCreateIntProperty("WheelTweak", 1);
        WheelSearchOrder = mainConfig.getOrCreateIntProperty("WheelSearchOrder", 1);
        boolean savedConfig = Main.saveConfigFile();
        if (savedConfig && !loadedConfig) {
            Constants.LOGGER.info("Mouse Tweaks config file was created.");
        }
    }

    public static boolean saveConfigFile() {
        mainConfig.setIntProperty("RMBTweak", RMBTweak);
        mainConfig.setIntProperty("LMBTweakWithItem", LMBTweakWithItem);
        mainConfig.setIntProperty("LMBTweakWithoutItem", LMBTweakWithoutItem);
        mainConfig.setIntProperty("WheelTweak", WheelTweak);
        mainConfig.setIntProperty("WheelSearchOrder", WheelSearchOrder);
        return mainConfig.saveConfig();
    }

    public static void onUpdateInGame() {
        GuiScreen currentScreen = Main.getCurrentScreen();
        if (currentScreen == null) {
            oldGuiScreen = null;
            container = null;
            oldSelectedSlot = null;
            firstSlot = null;
            oldStackOnMouse = null;
            firstSlotClicked = false;
            shouldClick = true;
            disableForThisContainer = false;
            disableWheelForThisContainer = false;
            readConfig = true;
            guiContainerID = -1;
        } else {
            if (readConfig) {
                readConfig = false;
                Main.readConfigFile();
            }
            if (guiContainerID == -1) {
                guiContainerID = Main.getGuiContainerID(currentScreen);
            }
            Main.onUpdateInGui(currentScreen);
        }
    }

    public static void onUpdateInGui(GuiScreen currentScreen) {
        int wheel;
        if (oldGuiScreen != currentScreen) {
            oldGuiScreen = currentScreen;
            guiContainerID = Main.getGuiContainerID(currentScreen);
            if (guiContainerID == 0) {
                return;
            }
            container = Main.getContainerWithID(currentScreen);
            disableForThisContainer = Main.isDisabledForThisContainer(currentScreen);
            Constants.LOGGER.debug("You have just opened a " + Main.getGuiContainerNameFromID(currentScreen) + " container (" + currentScreen.getClass().getSimpleName() + (container == null ? "" : "; ") + (container == null ? "" : container.getClass().getSimpleName()) + "), which has " + Main.getSlotCountWithID(currentScreen) + " slots!");
            disableWheelForThisContainer = Main.isWheelDisabledForThisContainer(currentScreen);
        }
        if (guiContainerID == 0) {
            return;
        }
        if ((DisableRMBTweak || RMBTweak == 0) && LMBTweakWithoutItem == 0 && LMBTweakWithItem == 0 && WheelTweak == 0) {
            return;
        }
        if (disableForThisContainer) {
            return;
        }
        int slotCount = Main.getSlotCountWithID(currentScreen);
        if (slotCount == 0) {
            return;
        }
        int n = wheel = WheelTweak == 1 && !disableWheelForThisContainer ? Mouse.getDWheel() / 120 : 0;
        if (!Mouse.isButtonDown((int)1)) {
            firstSlotClicked = false;
            firstSlot = null;
            shouldClick = true;
        }
        Slot selectedSlot = Main.getSelectedSlotWithID(currentScreen, slotCount);
        ItemStack stackOnMouse = Main.copyItemStack(Main.getStackOnMouse());
        ItemStack targetStack = Main.copyItemStack(Main.getSlotStack(selectedSlot));
        if (Mouse.isButtonDown((int)1) && oldStackOnMouse != stackOnMouse && oldStackOnMouse == null) {
            shouldClick = false;
        }
        if (oldSelectedSlot != selectedSlot) {
            boolean shiftIsDown;
            if (Mouse.isButtonDown((int)1) && !firstSlotClicked && firstSlot == null && oldSelectedSlot != null) {
                if (!Main.areStacksCompatible(stackOnMouse, Main.getSlotStack(oldSelectedSlot))) {
                    shouldClick = false;
                }
                firstSlot = oldSelectedSlot;
            }
            if (Mouse.isButtonDown((int)1) && oldSelectedSlot == null && !firstSlotClicked && firstSlot == null) {
                shouldClick = false;
            }
            if (selectedSlot == null) {
                oldSelectedSlot = selectedSlot;
                if (firstSlot != null && !firstSlotClicked) {
                    firstSlotClicked = true;
                    Main.disableRMBDragWithID(currentScreen);
                    firstSlot = null;
                }
                return;
            }
            Constants.LOGGER.debug("You have selected a new slot, it's slot number is " + Main.getSlotNumber(selectedSlot));
            boolean bl = shiftIsDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (Mouse.isButtonDown((int)1)) {
                if (RMBTweak == 1 && !DisableRMBTweak && stackOnMouse != null && Main.areStacksCompatible(stackOnMouse, targetStack) && !Main.isCraftingOutputSlot(currentScreen, selectedSlot)) {
                    if (firstSlot != null && !firstSlotClicked) {
                        firstSlotClicked = true;
                        Main.disableRMBDragWithID(currentScreen);
                        firstSlot = null;
                    } else {
                        shouldClick = false;
                        Main.disableRMBDragWithID(currentScreen);
                    }
                    Main.clickSlot(currentScreen, selectedSlot, 1, false);
                }
            } else if (Mouse.isButtonDown((int)0)) {
                if (stackOnMouse != null) {
                    if (LMBTweakWithItem == 1 && targetStack != null && Main.areStacksCompatible(stackOnMouse, targetStack)) {
                        if (shiftIsDown) {
                            Main.clickSlot(currentScreen, selectedSlot, 0, true);
                        } else if (Main.getItemStackSize(stackOnMouse) + Main.getItemStackSize(targetStack) <= Main.getMaxItemStackSize(stackOnMouse)) {
                            Main.clickSlot(currentScreen, selectedSlot, 0, false);
                            if (!Main.isCraftingOutputSlot(currentScreen, selectedSlot)) {
                                Main.clickSlot(currentScreen, selectedSlot, 0, false);
                            }
                        }
                    }
                } else if (LMBTweakWithoutItem == 1 && targetStack != null && shiftIsDown) {
                    Main.clickSlot(currentScreen, selectedSlot, 0, true);
                }
            }
            oldSelectedSlot = selectedSlot;
        }
        if (wheel != 0 && selectedSlot != null) {
            int numItemsToMove = Math.abs(wheel);
            Constants.LOGGER.debug("numItemsToMove: " + numItemsToMove);
            if (slotCount > 36) {
                ItemStack originalStack = Main.getSlotStack(selectedSlot);
                boolean isCraftingOutput = Main.isCraftingOutputSlot(currentScreen, selectedSlot);
                if (originalStack != null && (stackOnMouse == null || (isCraftingOutput ? Main.areStacksCompatible(originalStack, stackOnMouse) : !Main.areStacksCompatible(originalStack, stackOnMouse)))) {
                    do {
                        int i;
                        ItemStack stackSl;
                        Slot sl;
                        int i2;
                        Slot applicableSlot = null;
                        int slotCounter = 0;
                        int countUntil = slotCount - 36;
                        if (Main.getSlotNumber(selectedSlot) < countUntil) {
                            slotCounter = countUntil;
                            countUntil = slotCount;
                        }
                        if (wheel < 0 || WheelSearchOrder == 0) {
                            for (i2 = slotCounter; i2 < countUntil; ++i2) {
                                sl = Main.getSlotWithID(currentScreen, i2);
                                stackSl = Main.getSlotStack(sl);
                                if (stackSl == null) {
                                    if (applicableSlot != null || wheel >= 0 || !sl.func_75214_a(originalStack) || Main.isCraftingOutputSlot(currentScreen, sl)) continue;
                                    applicableSlot = sl;
                                    continue;
                                }
                                if (!Main.areStacksCompatible(originalStack, stackSl)) continue;
                                if (wheel < 0 && stackSl.field_77994_a < stackSl.func_77976_d()) {
                                    applicableSlot = sl;
                                } else {
                                    if (wheel <= 0) continue;
                                    applicableSlot = sl;
                                }
                                break;
                            }
                        } else {
                            for (i2 = countUntil - 1; i2 >= slotCounter; --i2) {
                                sl = Main.getSlotWithID(currentScreen, i2);
                                stackSl = Main.getSlotStack(sl);
                                if (stackSl == null) {
                                    if (applicableSlot != null || wheel >= 0 || !sl.func_75214_a(originalStack)) continue;
                                    applicableSlot = sl;
                                    continue;
                                }
                                if (!Main.areStacksCompatible(originalStack, stackSl)) continue;
                                if (wheel < 0 && stackSl.field_77994_a < stackSl.func_77976_d()) {
                                    applicableSlot = sl;
                                } else {
                                    if (wheel <= 0) continue;
                                    applicableSlot = sl;
                                }
                                break;
                            }
                        }
                        if (isCraftingOutput) {
                            if (wheel >= 0) break;
                            boolean mouseWasEmpty = stackOnMouse == null;
                            for (int i3 = 0; i3 < numItemsToMove; ++i3) {
                                Main.clickSlot(currentScreen, selectedSlot, 0, false);
                            }
                            if (applicableSlot == null || !mouseWasEmpty) break;
                            Main.clickSlot(currentScreen, applicableSlot, 0, false);
                            break;
                        }
                        if (applicableSlot == null) break;
                        Slot slotTo = wheel < 0 ? applicableSlot : selectedSlot;
                        Slot slotFrom = wheel < 0 ? selectedSlot : applicableSlot;
                        ItemStack stackTo = Main.getSlotStack(slotTo) != null ? Main.copyItemStack(Main.getSlotStack(slotTo)) : null;
                        ItemStack stackFrom = Main.copyItemStack(Main.getSlotStack(slotFrom));
                        if (wheel < 0) {
                            numItemsToMove = Math.min(numItemsToMove, Main.getItemStackSize(stackFrom));
                            if (stackTo != null && Main.getMaxItemStackSize(stackTo) - Main.getItemStackSize(stackTo) <= numItemsToMove) {
                                Main.clickSlot(currentScreen, slotFrom, 0, false);
                                Main.clickSlot(currentScreen, slotTo, 0, false);
                                Main.clickSlot(currentScreen, slotFrom, 0, false);
                                numItemsToMove -= Main.getMaxItemStackSize(stackTo) - Main.getItemStackSize(stackTo);
                                continue;
                            }
                            Main.clickSlot(currentScreen, slotFrom, 0, false);
                            if (Main.getItemStackSize(stackFrom) <= numItemsToMove) {
                                Main.clickSlot(currentScreen, slotTo, 0, false);
                            } else {
                                for (i = 0; i < numItemsToMove; ++i) {
                                    Main.clickSlot(currentScreen, slotTo, 1, false);
                                }
                            }
                            Main.clickSlot(currentScreen, slotFrom, 0, false);
                            numItemsToMove = 0;
                            continue;
                        }
                        if (Main.getMaxItemStackSize(stackTo) - Main.getItemStackSize(stackTo) <= numItemsToMove) {
                            Main.clickSlot(currentScreen, slotFrom, 0, false);
                            Main.clickSlot(currentScreen, slotTo, 0, false);
                            Main.clickSlot(currentScreen, slotFrom, 0, false);
                        } else {
                            Main.clickSlot(currentScreen, slotFrom, 0, false);
                            if (Main.getItemStackSize(stackFrom) <= numItemsToMove) {
                                Main.clickSlot(currentScreen, slotTo, 0, false);
                                numItemsToMove -= Main.getMaxItemStackSize(stackFrom);
                            } else {
                                for (i = 0; i < numItemsToMove; ++i) {
                                    Main.clickSlot(currentScreen, slotTo, 1, false);
                                }
                                numItemsToMove = 0;
                            }
                            Main.clickSlot(currentScreen, slotFrom, 0, false);
                        }
                        if (Main.getMaxItemStackSize(stackTo) != Main.getMaxItemStackSize(stackTo)) continue;
                        numItemsToMove = 0;
                    } while (numItemsToMove != 0);
                }
            }
        }
        oldStackOnMouse = stackOnMouse;
    }

    public static int getGuiContainerID(GuiScreen currentScreen) {
        int containerID = ModCompatibility.getModGuiContainerID(currentScreen);
        if (containerID == 0) {
            return Main.isGuiContainer(currentScreen) && Main.isValidGuiContainer(currentScreen) ? 1 : 0;
        }
        return containerID;
    }

    public static Object getContainerWithID(GuiScreen currentScreen) {
        if (guiContainerID == 1) {
            return Main.getContainer(Main.asGuiContainer(currentScreen));
        }
        return ModCompatibility.getModContainer(guiContainerID, currentScreen);
    }

    public static int getSlotCountWithID(GuiScreen currentScreen) {
        if (guiContainerID == 1) {
            return Main.getSlots(Main.asContainer(container)).size();
        }
        return ModCompatibility.getModSlotCount(guiContainerID, currentScreen, container);
    }

    public static String getGuiContainerNameFromID(GuiScreen currentScreen) {
        switch (guiContainerID) {
            case -1: {
                return "Unknown";
            }
            case 0: {
                return "Wrong";
            }
            case 1: {
                return "Vanilla Minecraft";
            }
        }
        return ModCompatibility.getModNameFromModGuiContainerID(guiContainerID, currentScreen);
    }

    public static boolean isDisabledForThisContainer(GuiScreen currentScreen) {
        if (guiContainerID == 1) {
            return false;
        }
        return ModCompatibility.isDisabledForThisModContainer(guiContainerID, currentScreen, container);
    }

    public static boolean isWheelDisabledForThisContainer(GuiScreen currentScreen) {
        if (guiContainerID == 1) {
            return false;
        }
        return ModCompatibility.isWheelDisabledForThisModContainer(guiContainerID, currentScreen);
    }

    public static Slot getSelectedSlotWithID(GuiScreen currentScreen, int slotCount) {
        if (guiContainerID == 1) {
            return Main.getSelectedSlot(Main.asGuiContainer(currentScreen), Main.asContainer(container), slotCount);
        }
        return ModCompatibility.getModSelectedSlot(guiContainerID, currentScreen, container, slotCount);
    }

    public static void clickSlot(GuiScreen currentScreen, Slot targetSlot, int mouseButton, boolean shiftPressed) {
        if (guiContainerID == 1) {
            Main.windowClick(Main.getWindowId(Main.asContainer(container)), Main.getSlotNumber(targetSlot), mouseButton, shiftPressed ? 1 : 0);
        } else {
            ModCompatibility.modClickSlot(guiContainerID, currentScreen, container, targetSlot, mouseButton, shiftPressed);
        }
    }

    public static boolean isCraftingOutputSlot(GuiScreen currentScreen, Slot targetSlot) {
        if (guiContainerID == 1) {
            return Main.isVanillaCraftingOutputSlot(Main.asContainer(container), targetSlot);
        }
        return ModCompatibility.modIsCraftingOutputSlot(guiContainerID, currentScreen, container, targetSlot);
    }

    public static Slot getSlotWithID(GuiScreen currentScreen, int slotNumber) {
        if (guiContainerID == 1) {
            return Main.getSlot(Main.asContainer(container), slotNumber);
        }
        return ModCompatibility.modGetSlot(guiContainerID, currentScreen, container, slotNumber);
    }

    public static void disableRMBDragWithID(GuiScreen currentScreen) {
        if (guiContainerID == 1) {
            Main.disableVanillaRMBDrag(Main.asGuiContainer(currentScreen));
            if (shouldClick) {
                Main.clickSlot(currentScreen, firstSlot, 1, false);
            }
        } else {
            ModCompatibility.disableRMBDragIfRequired(guiContainerID, currentScreen, container, firstSlot, shouldClick);
        }
    }

    static {
        oldGuiScreen = null;
        container = null;
        oldSelectedSlot = null;
        firstSlot = null;
        oldStackOnMouse = null;
        firstSlotClicked = false;
        shouldClick = true;
        disableForThisContainer = false;
        disableWheelForThisContainer = false;
        guiContainerID = 0;
        readConfig = false;
    }
}

