/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mekanism.handlers;

import java.util.HashMap;
import java.util.Map;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IngredientAny;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mekanism.MekanismHelper;
import modtweaker2.mods.mekanism.gas.IGasStack;
import modtweaker2.mods.mekanism.gas.MCGasStack;
import modtweaker2.mods.mekanism.util.AddMekanismRecipe;
import modtweaker2.mods.mekanism.util.RemoveMekanismRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.SolarNeutronActivator")
public class SolarNeutronActivator {
    public static final String name = "Mekanism Solar Evaporation";

    @ZenMethod
    public static void addRecipe(IGasStack gasInput, IGasStack gasOutput) {
        if (gasInput == null || gasOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        SolarNeutronRecipe recipe = new SolarNeutronRecipe(MekanismHelper.toGas(gasInput), MekanismHelper.toGas(gasOutput));
        MineTweakerAPI.apply((IUndoableAction)new AddMekanismRecipe(name, (Map<MachineInput, MachineRecipe>)RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get(), (MachineRecipe)recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient gasInput, @Optional IIngredient gasOutput) {
        if (gasInput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (gasOutput == null) {
            gasOutput = IngredientAny.INSTANCE;
        }
        HashMap<MachineInput, MachineRecipe> recipes = new HashMap<MachineInput, MachineRecipe>();
        for (Map.Entry entry : RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get().entrySet()) {
            MCGasStack inputGas = new MCGasStack(((GasInput)entry.getKey()).ingredient);
            MCGasStack outputGas = new MCGasStack(((GasOutput)((SolarNeutronRecipe)entry.getValue()).recipeOutput).output);
            if (!StackHelper.matches(gasInput, inputGas) || !StackHelper.matches(gasOutput, outputGas)) continue;
            recipes.put((MachineInput)entry.getKey(), (MachineRecipe)entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMekanismRecipe(name, RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get(), (Map<MachineInput, MachineRecipe>)recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipe found for %s and %s. Command ignored!", name, gasInput.toString(), gasOutput.toString()));
        }
    }
}

