/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.botania.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

@ZenClass(value="mods.botania.Apothecary")
public class Apothecary {
    protected static final String name = "Botania Petal";

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] input) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new RecipePetals(InputHelper.toStack(output), InputHelper.toObjects(input))));
    }

    @ZenMethod
    public static void addRecipe(String output, IIngredient[] input) {
        Apothecary.addRecipe(InputHelper.toIItemStack(ItemBlockSpecialFlower.ofType((String)output)), input);
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<RecipePetals> result = new LinkedList<RecipePetals>();
        for (RecipePetals entry : BotaniaAPI.petalRecipes) {
            if (entry == null || entry.getOutput() == null || !StackHelper.matches(output, InputHelper.toIItemStack(entry.getOutput()))) continue;
            result.add(entry);
        }
        if (!result.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(result));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    @ZenMethod
    public static void removeRecipe(String output) {
        Apothecary.removeRecipe((IIngredient)InputHelper.toIItemStack(ItemBlockSpecialFlower.ofType((String)output)));
    }

    private static class Remove
    extends BaseListRemoval<RecipePetals> {
        public Remove(List<RecipePetals> recipes) {
            super(Apothecary.name, BotaniaAPI.petalRecipes, recipes);
        }

        @Override
        public String getRecipeInfo(RecipePetals recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }

    private static class Add
    extends BaseListAddition<RecipePetals> {
        public Add(RecipePetals recipe) {
            super(Apothecary.name, BotaniaAPI.petalRecipes);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(RecipePetals recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }
}

