/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames.worldgen;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import eu.usrv.lootgames.LootGames;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Queue;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;

public class LootGamesRetroGen {
    public static LootGamesRetroGen instance = new LootGamesRetroGen();
    public static HashMap<Integer, Queue<ChunkInfo>> _mRetroChunk = new HashMap();
    private static String NBTMODID = "lootgames";
    private static String NBTGENERATED = "generated";

    public static void initRetroGen() {
        if (LootGames.ModConfig.RetroGenDungeons) {
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
    }

    @SubscribeEvent
    public void worldTickEvent(TickEvent.WorldTickEvent pEvent) {
        if (pEvent.side != Side.SERVER) {
            return;
        }
        World tWorld = pEvent.world;
        int tDimensionID = tWorld.field_73011_w.field_76574_g;
        if (pEvent.phase == TickEvent.Phase.END) {
            Queue<ChunkInfo> tChunks = _mRetroChunk.get(tDimensionID);
            if (tChunks != null && !tChunks.isEmpty()) {
                ChunkInfo tChunkInfo = tChunks.poll();
                LootGames.WorldGen.generate(null, tChunkInfo.mChunkX, tChunkInfo.mChunkZ, tWorld, null, null);
                _mRetroChunk.put(tDimensionID, tChunks);
            } else if (tChunks != null) {
                _mRetroChunk.remove(tDimensionID);
            }
        }
    }

    @SubscribeEvent
    public void chunkLoadEvent(ChunkDataEvent.Load pEvent) {
        int tDimensionID = pEvent.world.field_73011_w.field_76574_g;
        NBTTagCompound tTagCompound = (NBTTagCompound)pEvent.getData().func_74781_a(NBTMODID);
        boolean tRetronGen = false;
        if (tTagCompound != null && !tTagCompound.func_74764_b(NBTGENERATED)) {
            tRetronGen = true;
        }
        if (tRetronGen) {
            Queue<ChunkInfo> tChunks = _mRetroChunk.get(tDimensionID);
            if (tChunks == null) {
                _mRetroChunk.put(tDimensionID, new ArrayDeque());
                tChunks = _mRetroChunk.get(tDimensionID);
            }
            if (tChunks != null) {
                tChunks.add(new ChunkInfo(pEvent.getChunk().field_76635_g, pEvent.getChunk().field_76647_h));
                _mRetroChunk.put(tDimensionID, tChunks);
            }
        }
    }

    @SubscribeEvent
    public void chunkSaveEvent(ChunkDataEvent.Save pEvent) {
        NBTTagCompound tagCompound = pEvent.getData().func_74775_l(NBTMODID);
        if (!tagCompound.func_74764_b(NBTGENERATED)) {
            tagCompound.func_74757_a(NBTGENERATED, true);
        }
        pEvent.getData().func_74782_a(NBTMODID, (NBTBase)tagCompound);
    }

    public static class ChunkInfo {
        public int mChunkX;
        public int mChunkZ;

        public ChunkInfo(int pChunkX, int pChunkZ) {
            this.mChunkX = pChunkX;
            this.mChunkZ = pChunkZ;
        }
    }
}

