/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames.config;

import eu.usrv.lootgames.LootGames;
import eu.usrv.yamcore.auxiliary.IntHelper;
import eu.usrv.yamcore.config.ConfigManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class LootGamesConfig
extends ConfigManager {
    public boolean RetroGenDungeons;
    public boolean WorldGenEnabled;
    public String DungeonLoggerLogLevel;
    public boolean MinigamesEnabled;
    public GOLConfig GolConfig;
    private HashMap<Integer, Integer> DimensionWhitelist = new HashMap();
    private boolean disableDonorListDownloading;

    public LootGamesConfig(File pConfigBaseDirectory, String pModCollectionDirectory, String pModID) {
        super(pConfigBaseDirectory, pModCollectionDirectory, pModID);
    }

    public boolean isDimensionEnabledForWG(int pDimensionID) {
        return this.DimensionWhitelist.containsKey(pDimensionID);
    }

    public boolean isDonorListEnabled() {
        return !this.disableDonorListDownloading;
    }

    public int getWorldGenRhombusSize(int pDimensionID) {
        if (!this.isDimensionEnabledForWG(pDimensionID)) {
            return -1;
        }
        return this.DimensionWhitelist.get(pDimensionID);
    }

    private void parseDimensionConfig(String[] pDimensionList) {
        this.DimensionWhitelist = new HashMap();
        for (String tEntry : pDimensionList) {
            if (tEntry.length() == 0) {
                return;
            }
            String[] tArray = tEntry.split(";");
            if (tArray.length == 2) {
                if (IntHelper.tryParse((String)tArray[0]) && IntHelper.tryParse((String)tArray[1])) {
                    Integer tDimID = Integer.parseInt(tArray[0]);
                    Integer tRhombSize = Integer.parseInt(tArray[1]);
                    if (tRhombSize < 5 || tRhombSize > 100) {
                        LootGames.mLog.error((Object)String.format("Invalid DimensionWhitelist entry found: [%s;]; RhombusSize must be between 5 and 100", tEntry));
                        continue;
                    }
                    if (!this.DimensionWhitelist.containsKey(tDimID)) {
                        this.DimensionWhitelist.put(tDimID, tRhombSize);
                        LootGames.mLog.info((Object)String.format("Worldgen enabled in DimensionID %d with Rhombus Size %d", tDimID, tRhombSize));
                        continue;
                    }
                    LootGames.mLog.error((Object)String.format("Invalid DimensionWhitelist entry found: [%s;]; DimensionID is already defined", tEntry));
                    continue;
                }
                LootGames.mLog.error((Object)String.format("Invalid DimensionWhitelist entry found: [%s;]; DimensionID or Rhombus Size is not an Integer", tEntry));
                continue;
            }
            LootGames.mLog.error((Object)String.format("Invalid DimensionWhitelist entry found: [%s;]; Syntax is <DimensionID>;<Rhombus Size>", tEntry));
        }
    }

    protected void PreInit() {
        this.GolConfig = new GOLConfig(this._mainConfig);
        this.WorldGenEnabled = false;
        this.DungeonLoggerLogLevel = Level.INFO.toString();
        this.RetroGenDungeons = false;
    }

    protected void Init() {
        this.GolConfig.Init();
        this.MinigamesEnabled = this._mainConfig.getBoolean("MinigamesEnabled", "main", this.MinigamesEnabled, "Switch to enable or disable the Master-Blocks. If disabled, no minigames will spawn. You can change this ingame");
        this.RetroGenDungeons = this._mainConfig.getBoolean("RetroGenDungeons", "worldgen", this.RetroGenDungeons, "Enable or disable RetroGen");
        this.WorldGenEnabled = this._mainConfig.getBoolean("WorldGenEnabled", "worldgen", this.WorldGenEnabled, "Enable or disable WorldGen");
        String[] tDimConfig = this._mainConfig.getStringList("DimensionWhitelist", "worldgen", new String[]{"0; 20"}, "List DimensionIDs where LootGame Dungeons are allowed to spawn, with Rhombus Size. Syntax is <DimensionID>:<Rhombus Size>");
        this.parseDimensionConfig(tDimConfig);
        this.DungeonLoggerLogLevel = this._mainConfig.getString("DungeonLoggerLogLevel", "debug", this.DungeonLoggerLogLevel, "LogLevel for the separate DungeonGenerator Logger. Valid options: info, debug, trace", new String[]{"INFO", "DEBUG", "TRACE"});
        this.initNewConfigs();
    }

    private List<Integer> parseStringListToIntList(String[] pSource) {
        ArrayList<Integer> tLst = new ArrayList<Integer>();
        for (String tEntry : pSource) {
            if (!IntHelper.tryParse((String)tEntry)) continue;
            tLst.add(Integer.parseInt(tEntry));
        }
        return tLst;
    }

    public void reload() {
        this.GolConfig.Init();
        this.MinigamesEnabled = this._mainConfig.getBoolean("MinigamesEnabled", "main", this.MinigamesEnabled, "Switch to enable or disable the Master-Blocks. If disabled, no minigames will spawn.");
        this.WorldGenEnabled = this._mainConfig.getBoolean("WorldGenEnabled", "worldgen", this.WorldGenEnabled, "Enable or disable WorldGen");
        String[] tDimConfig = this._mainConfig.getStringList("DimensionWhitelist", "worldgen", new String[]{"0; 20"}, "List DimensionIDs where LootGame Dungeons are allowed to spawn");
        this.parseDimensionConfig(tDimConfig);
        this.DungeonLoggerLogLevel = this._mainConfig.getString("DungeonLoggerLogLevel", "debug", this.DungeonLoggerLogLevel, "LogLevel for the separate DungeonGenerator Logger. Valid options: info, debug, trace", new String[]{"INFO", "DEBUG", "TRACE"});
        this.initNewConfigs();
    }

    private void initNewConfigs() {
        this.disableDonorListDownloading = this._mainConfig.getBoolean("disableDonorListDownloading", "main", false, "Disables downloading of donors list. It will speed-up mod loading, when you don't have an access to the Pastebin or play offline.");
    }

    protected void PostInit() {
    }

    public static class LootStageConfig {
        public int MinItems;
        public int MaxItems;
        public int DisplayTime;
        public boolean RandomizeSequence;
        public int LevelID;
        public HashMap<Integer, DimensionalConfig> DimensionalLoots = null;
        private int MinDigitsRequired;
        private String LootTable;

        LootStageConfig(int pLevel) {
            this.LevelID = pLevel;
        }

        public String GetLootTable(World pWorldObject) {
            if (this.DimensionalLoots.containsKey(pWorldObject.field_73011_w.field_76574_g)) {
                return this.DimensionalLoots.get((Object)Integer.valueOf((int)pWorldObject.field_73011_w.field_76574_g)).LootTable;
            }
            return this.LootTable;
        }

        public int getMinDigitsRequired(World pWorldObject) {
            int tRet = this.MinDigitsRequired;
            if (this.DimensionalLoots.containsKey(pWorldObject.field_73011_w.field_76574_g)) {
                tRet += this.DimensionalLoots.get((Object)Integer.valueOf((int)pWorldObject.field_73011_w.field_76574_g)).AdditionalDigits;
            }
            return tRet;
        }

        public void SetDimensionalLootConfig(String[] pConfigList) {
            this.DimensionalLoots = new HashMap();
            for (String tEntry : pConfigList) {
                if (tEntry.length() == 0) {
                    return;
                }
                String[] tArray = tEntry.split(";");
                if (tArray.length == 3) {
                    if (IntHelper.tryParse((String)tArray[0]) && IntHelper.tryParse((String)tArray[2])) {
                        Integer tDimID = Integer.parseInt(tArray[0]);
                        Integer tAddDig = Integer.parseInt(tArray[2]);
                        if (!this.DimensionalLoots.containsKey(tDimID)) {
                            this.DimensionalLoots.put(tDimID, new DimensionalConfig(tArray[1], tAddDig));
                            continue;
                        }
                        LootGames.mLog.error((Object)String.format("Invalid DimensionalLootConfig entry found: [%s;] DimensionID is already defined", tEntry));
                        continue;
                    }
                    LootGames.mLog.error((Object)String.format("Invalid DimensionalLootConfig entry found: [%s;]; DimensionID is not an Integer", tEntry));
                    continue;
                }
                LootGames.mLog.error((Object)String.format("Invalid DimensionalLootConfig entry found: [%s;]; Syntax is <DimensionID>;<LootTableName>;<AdditionalDigitsRequired> ", tEntry));
            }
            LootGames.mLog.info((Object)String.format("Loaded %d DimensionID based LootTables for StageID %d", this.DimensionalLoots.size(), this.LevelID));
        }

        public static class DimensionalConfig {
            public String LootTable;
            public int AdditionalDigits;

            DimensionalConfig(String pLootTable, int pAddDigits) {
                this.LootTable = pLootTable;
                this.AdditionalDigits = pAddDigits;
            }
        }
    }

    public static class GOLConfig {
        public LootStageConfig GameStageI;
        public LootStageConfig GameStageII;
        public LootStageConfig GameStageIII;
        public LootStageConfig GameStageIV;
        public int StartDigits;
        public int MaxGameTries;
        public int ExpandPlayFieldAtStage;
        public int Timeout;
        public boolean Debug;
        public boolean GameFail_Explode;
        public boolean GameFail_Spawn;
        public boolean GameFail_Lava;
        private Configuration _mMainConfig;

        public GOLConfig(Configuration pMainConfig) {
            this._mMainConfig = pMainConfig;
            this.GameStageI = new LootStageConfig(1);
            this.GameStageII = new LootStageConfig(2);
            this.GameStageIII = new LootStageConfig(3);
            this.GameStageIV = new LootStageConfig(4);
            this.GameStageI.LootTable = "dungeonChest";
            this.GameStageI.MinItems = 2;
            this.GameStageI.MaxItems = 2;
            this.GameStageI.MinDigitsRequired = 5;
            this.GameStageI.DisplayTime = 1200;
            this.GameStageI.RandomizeSequence = false;
            this.GameStageII.LootTable = "mineshaftCorridor";
            this.GameStageII.MinItems = 4;
            this.GameStageII.MaxItems = 4;
            this.GameStageII.MinDigitsRequired = 10;
            this.GameStageII.DisplayTime = 800;
            this.GameStageII.RandomizeSequence = false;
            this.GameStageIII.LootTable = "pyramidJungleChest";
            this.GameStageIII.MinItems = 6;
            this.GameStageIII.MaxItems = 6;
            this.GameStageIII.MinDigitsRequired = 15;
            this.GameStageIII.DisplayTime = 600;
            this.GameStageIII.RandomizeSequence = false;
            this.GameStageIV.LootTable = "strongholdCorridor";
            this.GameStageIV.MinItems = 8;
            this.GameStageIV.MaxItems = 8;
            this.GameStageIV.MinDigitsRequired = 20;
            this.GameStageIV.DisplayTime = 500;
            this.GameStageIV.RandomizeSequence = true;
            this.StartDigits = 2;
            this.MaxGameTries = 3;
            this.ExpandPlayFieldAtStage = 2;
            this.GameFail_Explode = true;
            this.GameFail_Spawn = true;
            this.GameFail_Lava = true;
            this.Timeout = 60;
        }

        protected void Init() {
            this.loadStage(this._mMainConfig, this.GameStageI, "StageI");
            this.loadStage(this._mMainConfig, this.GameStageII, "StageII");
            this.loadStage(this._mMainConfig, this.GameStageIII, "StageIII");
            this.loadStage(this._mMainConfig, this.GameStageIV, "StageIV");
            this.StartDigits = this._mMainConfig.getInt("StartDigits", "games.gol", this.StartDigits, 1, 256, "How many digits should be randomly choosen at game-start?");
            this.MaxGameTries = this._mMainConfig.getInt("MaxGameTries", "games.gol", this.MaxGameTries, 1, 256, "How many attempts does a player have? 1 means the struct will fail after the first misclicked block");
            this.ExpandPlayFieldAtStage = this._mMainConfig.getInt("ExpandPlayFieldAtStage", "games.gol", this.ExpandPlayFieldAtStage, 0, 4, "At which stage should the playfield become a full 3x3 pattern? Set 0 to disable and keep the 4-block size; set 1 to always start with 3x3");
            this.Timeout = this._mMainConfig.getInt("Timeout", "games.gol", this.Timeout, 5, 600, "How long does it take to timeout a game? Value is in seconds. If no player input is done in that time, the game will go to sleep. The next player will start fresh");
            this.Debug = this._mMainConfig.getBoolean("Debug", "games.gol", this.Debug, "Enable or disable Debugging of this game (Only enable this if you expect a bug. This will blow up your logfile...)");
            this.GameFail_Explode = this._mMainConfig.getBoolean("ExplodeEvent", "games", this.GameFail_Explode, "Enable or disable struct exploding on max failed attempts");
            this.GameFail_Spawn = this._mMainConfig.getBoolean("MobEvent", "games", this.GameFail_Spawn, "Enable or disable struct filling with monsters on max failed attempts");
            this.GameFail_Lava = this._mMainConfig.getBoolean("LavaEvent", "games", this.GameFail_Lava, "Enable or disable struct filling with lava on max failed attempts");
        }

        private void loadStage(Configuration pConfig, LootStageConfig pConfObject, String pSection) {
            pConfObject.LootTable = pConfig.getString("LootTable", String.format("games.gol.gamestages.%s", pSection), pConfObject.LootTable, "The loottable for the chest in this stage");
            pConfObject.MinItems = pConfig.getInt("MinItems", String.format("games.gol.gamestages.%s", pSection), pConfObject.MinItems, 1, 256, "Minimum amount of items to be spawned");
            pConfObject.MaxItems = pConfig.getInt("MaxItems", String.format("games.gol.gamestages.%s", pSection), pConfObject.MaxItems, 1, 256, "Maximum amount of items to be spawned");
            pConfObject.MinDigitsRequired = pConfig.getInt("MinDigitsRequired", String.format("games.gol.gamestages.%s", pSection), pConfObject.MinDigitsRequired, 1, 256, "Minimum correct digits required to complete this stage and unlock the chest. This can be adjusted per-Dimension in S:DimensionalConfig");
            pConfObject.DisplayTime = pConfig.getInt("DisplayTime", String.format("games.gol.gamestages.%s", pSection), pConfObject.DisplayTime, 100, 2000, "The amount of time (in milliseconds; 1000ms = 1s) to wait at playback before moving to the next color");
            pConfObject.RandomizeSequence = pConfig.getBoolean("RandomizeSequence", String.format("games.gol.gamestages.%s", pSection), pConfObject.RandomizeSequence, "If true, the pattern will randomize on each level in this stage");
            String[] tDimConfig = pConfig.getStringList("DimensionalConfig", String.format("games.gol.gamestages.%s", pSection), new String[]{""}, "Syntax: <DimensionID>;<LootTableName>;<AdditionalDigitsRequired>; one line for each Dimension. If you use AdditionalDigitsRequired, make sure to use the same or an higher number on each stage");
            if (tDimConfig.length > 0) {
                pConfObject.SetDimensionalLootConfig(tDimConfig);
            }
        }
    }
}

