/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames.chess.entities;

import eu.usrv.lootgames.LootGames;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;

public class FiguresData {
    private EntityLiving _mEntity;
    private ResourceLocation[] _mTextures;
    private boolean _mUpdateTextures;
    private float _mRenderScale;
    private boolean _mIsWhite;

    public FiguresData(EntityLiving pEntity, ResourceLocation ... pBaseTextures) {
        this._mEntity = pEntity;
        this._mTextures = pBaseTextures;
    }

    public void setIsWhite(boolean pFlag) {
        this._mIsWhite = pFlag;
    }

    public boolean isWhite() {
        return this._mIsWhite;
    }

    public float getRenderScale() {
        return this._mRenderScale;
    }

    public void setRenderScale(float pScale) {
        this._mRenderScale = pScale;
    }

    public int getTextureCount() {
        return this._mTextures.length;
    }

    public ResourceLocation getTexture() {
        return this._mTextures[0];
    }

    public ResourceLocation getTexture(int index) {
        return this._mTextures[index];
    }

    public ResourceLocation[] getTextures() {
        return this._mTextures;
    }

    public void setTextures(ResourceLocation ... tex) {
        this._mTextures = tex;
    }

    public void loadTextures(String ... tex) {
        try {
            ResourceLocation[] newTextures = new ResourceLocation[this._mTextures.length];
            int i = newTextures.length;
            while (i-- > 0) {
                if (!this._mTextures[i].toString().equals(tex[i])) {
                    this._mUpdateTextures = true;
                    newTextures[i] = new ResourceLocation(tex[i]);
                    continue;
                }
                newTextures[i] = this._mTextures[i];
            }
            if (this._mUpdateTextures) {
                this.setTextures(newTextures);
            }
        }
        catch (Exception ex) {
            LootGames.mLog.error((Object)"Failed to load textures");
        }
    }
}

