/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames.chess;

import com.jamesswafford.chess4j.exceptions.IllegalMoveException;
import com.jamesswafford.chess4j.exceptions.ParseException;
import com.jamesswafford.chess4j.io.InputParser;
import eu.usrv.lootgames.LootGames;
import eu.usrv.lootgames.chess.IChessEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ChessEngineProxy {
    private static ChessEngineProxy _mInstance;
    private UUID _mCurrentAttachedChessGame = null;
    private List<IChessEventListener> listeners = new ArrayList<IChessEventListener>();

    private ChessEngineProxy() {
    }

    public static ChessEngineProxy getInstance() {
        if (_mInstance == null) {
            _mInstance = new ChessEngineProxy();
        }
        return _mInstance;
    }

    public UUID getEngineToken() {
        if (this._mCurrentAttachedChessGame != null) {
            return null;
        }
        this._mCurrentAttachedChessGame = UUID.randomUUID();
        return this._mCurrentAttachedChessGame;
    }

    public void resetEngine() {
        this.sendCommand("force");
        this.sendCommand("new");
        this.sendCommand("level 10 99 0");
        this.sendCommand("easy");
    }

    private boolean sendCommand(String pCommand) {
        try {
            InputParser.getInstance().parseCommand(pCommand);
        }
        catch (IllegalMoveException ime) {
            LootGames.mLog.error((Object)"Illegal move");
        }
        catch (ParseException pe) {
            LootGames.mLog.error((Object)("Parse error: " + pe.getMessage()));
        }
        catch (Exception e) {
            LootGames.mLog.debug((Object)("Caught (hopefully recoverable) exception: " + e.getMessage()));
        }
        return true;
    }

    public void addListener(IChessEventListener toAdd) {
        this.listeners.add(toAdd);
    }

    public void publishAnswer(String pMessage) {
        for (IChessEventListener hl : this.listeners) {
            hl.chessEngineMessage(this._mCurrentAttachedChessGame, pMessage);
        }
    }
}

