/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eu.usrv.lootgames.LootGames;
import eu.usrv.lootgames.auxiliary.RandHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DungeonBrick
extends Block {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] mIcons;

    public DungeonBrick() {
        super(Material.field_151576_e);
        this.func_149663_c("dungeonBrick");
        this.func_149647_a((CreativeTabs)LootGames.CreativeTab);
        this.func_149711_c(10.0f);
        this.func_149752_b(6.0f);
        this.func_149672_a(field_149769_e);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 5));
        list.add(new ItemStack(item, 1, 6));
    }

    public int func_149692_a(int meta) {
        int tRetMeta = meta;
        if (meta == eDungeonBricks.CEILING.ordinal() || meta == eDungeonBricks.FLOOR.ordinal() || meta == eDungeonBricks.WALL.ordinal()) {
            tRetMeta = meta + RandHelper.flipCoin(0, 3);
        }
        return tRetMeta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.mIcons = new IIcon[7];
        this.mIcons[0] = register.func_94245_a(String.format("LootGames:dungeonWall", new Object[0]));
        this.mIcons[1] = register.func_94245_a(String.format("LootGames:dungeonCeiling", new Object[0]));
        this.mIcons[2] = register.func_94245_a(String.format("LootGames:dungeonFloor", new Object[0]));
        this.mIcons[3] = register.func_94245_a(String.format("LootGames:dungeonWallCrack", new Object[0]));
        this.mIcons[4] = register.func_94245_a(String.format("LootGames:dungeonCeilingCrack", new Object[0]));
        this.mIcons[5] = register.func_94245_a(String.format("LootGames:dungeonFloorCrack", new Object[0]));
        this.mIcons[6] = register.func_94245_a(String.format("LootGames:dungeonFloorGameLayer", new Object[0]));
    }

    public int getHarvestLevel(int metadata) {
        int tHarvestLevel = super.getHarvestLevel(metadata);
        if (metadata == eDungeonBricks.CEILING.ordinal() || metadata == eDungeonBricks.FLOOR.ordinal() || metadata == eDungeonBricks.WALL.ordinal()) {
            tHarvestLevel = 4;
        } else if (metadata == eDungeonBricks.CEILING_CRACKED.ordinal() || metadata == eDungeonBricks.FLOOR_CRACKED.ordinal() || metadata == eDungeonBricks.WALL_CRACKED.ordinal()) {
            tHarvestLevel = 2;
        }
        return tHarvestLevel;
    }

    public String getHarvestTool(int metadata) {
        return "pickaxe";
    }

    public float func_149712_f(World pWorld, int pX, int pY, int pZ) {
        int tMeta = pWorld.func_72805_g(pX, pY, pZ);
        float tBlockHardness = super.func_149712_f(pWorld, pX, pY, pZ);
        if (tMeta == eDungeonBricks.FLOOR_SHIELDED.ordinal()) {
            tBlockHardness = -1.0f;
        } else if (tMeta == eDungeonBricks.CEILING_CRACKED.ordinal() || tMeta == eDungeonBricks.FLOOR_CRACKED.ordinal() || tMeta == eDungeonBricks.WALL_CRACKED.ordinal()) {
            tBlockHardness = 2.0f;
        }
        return tBlockHardness;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int pSide, int pMeta) {
        return this.mIcons[pMeta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        return this.mIcons[iBlockAccess.func_72805_g(x, y, z)];
    }

    public static enum eDungeonBricks {
        WALL,
        CEILING,
        FLOOR,
        WALL_CRACKED,
        CEILING_CRACKED,
        FLOOR_CRACKED,
        FLOOR_SHIELDED;

    }
}

