/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames.auxiliary;

import eu.usrv.lootgames.LootGames;
import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.IntHelper;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public final class LGDonorController {
    private final String donorSourceURL;
    private ArrayList<Donor> donorList = new ArrayList();
    private final CompletableFuture<ArrayList<Donor>> donorListFuture = new CompletableFuture();

    public LGDonorController(String pDonorSourceURL) {
        this.donorSourceURL = pDonorSourceURL;
    }

    public void loadDonors() {
        if (LootGames.ModConfig.isDonorListEnabled()) {
            Thread thread = new Thread(this::loadDonorsInternally);
            thread.setDaemon(true);
            thread.start();
        }
    }

    private void loadDonorsInternally() {
        ArrayList<Donor> donorList = new ArrayList<Donor>();
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(500).setConnectTimeout(2000).setSocketTimeout(7000).build();
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
            try (CloseableHttpResponse response = httpClient.execute(new HttpGet(new URI(this.donorSourceURL)));){
                if (response.getEntity() != null) {
                    String[] lines;
                    InputStream content = response.getEntity().getContent();
                    String tDonorDefinition = IOUtils.toString((InputStream)content);
                    for (String line : lines = tDonorDefinition.split("\\r?\\n")) {
                        Donor tDonor = Donor.tryLoad(line);
                        if (tDonor == null) continue;
                        donorList.add(tDonor);
                    }
                }
            }
            this.donorListFuture.complete(donorList);
        }
        catch (Exception e) {
            this.donorListFuture.completeExceptionally(e);
        }
    }

    public void fetchDonors() {
        if (LootGames.ModConfig.isDonorListEnabled()) {
            try {
                this.donorList = this.donorListFuture.get(7L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                String error = String.format("Unable to connect to %s. DonorController will not do anything!", this.donorSourceURL);
                if (!YAMCore.isDebug()) {
                    LootGames.mLog.warn((Object)error);
                }
                LootGames.mLog.warn(error, (Object)e);
            }
        }
    }

    public boolean isDonor(EntityPlayer pPlayer) {
        return this.isDonor(pPlayer.func_110124_au());
    }

    public boolean isDonor(EntityPlayerMP pPlayer) {
        return this.isDonor(pPlayer.func_110124_au());
    }

    public int getLevel(EntityPlayer pPlayer) {
        return this.getLevel(pPlayer.func_110124_au());
    }

    public int getLevel(EntityPlayerMP pPlayer) {
        return this.getLevel(pPlayer.func_110124_au());
    }

    public boolean hasExtraArg(EntityPlayer pPlayer, String pDonorArg) {
        return this.hasExtraArg(pPlayer.func_110124_au(), pDonorArg);
    }

    public boolean hasExtraArg(EntityPlayerMP pPlayer, String pDonorArg) {
        return this.hasExtraArg(pPlayer.func_110124_au(), pDonorArg);
    }

    private Donor getDonor(UUID pPlayerUUID) {
        for (Donor d : this.donorList) {
            if (!d.getUUID().equals(pPlayerUUID)) continue;
            return d;
        }
        return null;
    }

    public boolean isDonor(UUID pPlayerUUID) {
        return this.getDonor(pPlayerUUID) != null;
    }

    public boolean hasExtraArg(UUID pPlayerUUID, String pDonorArg) {
        Donor d = this.getDonor(pPlayerUUID);
        return d != null && d._mDonorExtraArgs.contains(pDonorArg);
    }

    public int getLevel(UUID pPlayerUUID) {
        Donor d = this.getDonor(pPlayerUUID);
        return d != null ? d.getLevel() : -1;
    }

    private static final class Donor {
        private final UUID _mUUID;
        private final int _mLevel;
        private final List<String> _mDonorExtraArgs;

        public UUID getUUID() {
            return this._mUUID;
        }

        public int getLevel() {
            return this._mLevel;
        }

        public List<String> getDonorArgs() {
            return Collections.unmodifiableList(this._mDonorExtraArgs);
        }

        public static Donor tryLoad(String pDonorLine) {
            ArrayList<String> tArgs;
            String[] lineArgs = pDonorLine.split("#");
            UUID tUUID = null;
            int tLevel = 0;
            try {
                if (lineArgs.length > 0) {
                    tUUID = UUID.fromString(lineArgs[0]);
                }
            }
            catch (Exception e) {
                YAMCore.instance.getLogger().error((Object)String.format("Invalid PlayerUUID found in DonorFile: %s", lineArgs[0]));
            }
            try {
                if (lineArgs.length > 1) {
                    if (!IntHelper.tryParse((String)lineArgs[1])) {
                        YAMCore.instance.getLogger().error((Object)String.format("Second argument in DonorLine is not an integer: %s DonorLevel will default to 0", lineArgs[1]));
                    } else {
                        tLevel = Integer.parseInt(lineArgs[1]);
                    }
                }
            }
            catch (Exception e) {
                tLevel = 0;
            }
            try {
                tArgs = lineArgs.length > 2 ? new ArrayList<String>(Arrays.asList(lineArgs[2].split("!"))) : new ArrayList();
            }
            catch (Exception e) {
                tArgs = new ArrayList<String>();
            }
            if (tUUID != null) {
                return new Donor(tUUID, tLevel, tArgs);
            }
            return null;
        }

        private Donor(UUID pUserUUID, int pDonationLevel, ArrayList<String> pExtraArgs) {
            this._mUUID = pUserUUID;
            this._mLevel = pDonationLevel;
            this._mDonorExtraArgs = pExtraArgs;
        }
    }
}

