/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames.auxiliary;

public enum ExtendedDirections {
    DOWN(0, -1, 0),
    UP(0, 1, 0),
    NORTH(0, 0, -1),
    SOUTH(0, 0, 1),
    WEST(-1, 0, 0),
    EAST(1, 0, 0),
    NORTHEAST(1, 0, -1),
    NORTHWEST(-1, 0, -1),
    SOUTHEAST(1, 0, 1),
    SOUTHWEST(-1, 0, 1),
    UNKNOWN(0, 0, 0);

    public static final ExtendedDirections[] VALID_DIRECTIONS;
    public static final int[] OPPOSITES;
    public final int offsetX;
    public final int offsetY;
    public final int offsetZ;
    public final int flag;

    private ExtendedDirections(int x, int y, int z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        this.flag = 1 << this.ordinal();
    }

    public static ExtendedDirections getOrientation(int id) {
        if (id >= 0 && id < VALID_DIRECTIONS.length) {
            return VALID_DIRECTIONS[id];
        }
        return UNKNOWN;
    }

    public ExtendedDirections getOpposite() {
        return ExtendedDirections.getOrientation(OPPOSITES[this.ordinal()]);
    }

    static {
        VALID_DIRECTIONS = new ExtendedDirections[]{DOWN, UP, NORTH, SOUTH, WEST, EAST, NORTHEAST, NORTHWEST, SOUTHEAST, SOUTHWEST};
        OPPOSITES = new int[]{1, 0, 3, 2, 5, 4, 9, 8, 7, 6, 10};
    }
}

