/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames.achievements;

import eu.usrv.lootgames.LootGames;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.AchievementPage;

public enum LootGameAchievement {
    FIND_MINIDUNGEON("lootgames.find_dungeon", LootGames.MasterBlock, 0, 0),
    BEAT_A_GAME("lootgames.win", Items.field_151156_bN, -1, -2, FIND_MINIDUNGEON),
    LOOSE_A_GAME("lootgames.fail", Items.field_151144_bL, 1, -2, FIND_MINIDUNGEON),
    GOL_MASTER_LEVEL3("lootgames.gol.level3", Items.field_151045_i, -2, -4, true, BEAT_A_GAME),
    GOL_MASTER_LEVEL4("lootgames.gol.level4", Items.field_151166_bC, 0, -4, true, BEAT_A_GAME);

    private String _mName;
    private ItemStack _mItemStack;
    private Achievement _mAchievement;

    private LootGameAchievement(String pName, ItemStack pItem, int pPosX, int pPosY, boolean pSpecial, LootGameAchievement pPreReq) {
        this._mName = pName;
        this._mItemStack = pItem;
        if (StaticFields.AchievementList.containsKey(pName)) {
            throw new IllegalArgumentException("You derp! Achievement %s already exists!");
        }
        this._mAchievement = new Achievement(this._mName, this._mName, pPosX, pPosY, this._mItemStack, pPreReq != null ? pPreReq.getAchievement() : null).func_75971_g();
        if (pPreReq == null) {
            this._mAchievement.func_75966_h();
        }
        if (pSpecial) {
            this._mAchievement.func_75987_b();
        }
        StaticFields.AchievementList.put(this._mName, this._mAchievement);
    }

    private LootGameAchievement(String pName, Item pItem, int pPosX, int pPosY, boolean pSpecial) {
        this(pName, new ItemStack(pItem), pPosX, pPosY, pSpecial, null);
    }

    private LootGameAchievement(String pName, Item pItem, int pPosX, int pPosY, boolean pSpecial, LootGameAchievement pPreReq) {
        this(pName, new ItemStack(pItem), pPosX, pPosY, pSpecial, pPreReq);
    }

    private LootGameAchievement(String pName, Block pBlock, int pPosX, int pPosY, boolean pSpecial, LootGameAchievement pPreReq) {
        this(pName, new ItemStack(pBlock), pPosX, pPosY, pSpecial, pPreReq);
    }

    private LootGameAchievement(String pName, Item pItem, int pPosX, int pPosY, LootGameAchievement pPreReq) {
        this(pName, new ItemStack(pItem), pPosX, pPosY, false, pPreReq);
    }

    private LootGameAchievement(String pName, Item pItem, int pPosX, int pPosY) {
        this(pName, new ItemStack(pItem), pPosX, pPosY, false, null);
    }

    private LootGameAchievement(String pName, Block pBlock, int pPosX, int pPosY, boolean pSpecial) {
        this(pName, new ItemStack(pBlock), pPosX, pPosY, pSpecial, null);
    }

    private LootGameAchievement(String pName, Block pBlock, int pPosX, int pPosY, LootGameAchievement pPreReq) {
        this(pName, new ItemStack(pBlock), pPosX, pPosY, false, pPreReq);
    }

    private LootGameAchievement(String pName, Block pBlock, int pPosX, int pPosY) {
        this(pName, new ItemStack(pBlock), pPosX, pPosY, false, null);
    }

    public static void registerAchievementPage() {
        StaticFields.AchievementsPage = new AchievementPage(StatCollector.func_74838_a((String)"lootgames.achievementPage.name"), StaticFields.AchievementList.values().toArray(new Achievement[0]));
        AchievementPage.registerAchievementPage((AchievementPage)StaticFields.AchievementsPage);
    }

    public Achievement getAchievement() {
        return this._mAchievement;
    }

    public String getName() {
        return this._mName;
    }

    public ItemStack getItemStack() {
        return this._mItemStack;
    }

    public void triggerAchievement(EntityPlayer pPlayer) {
        if (this._mAchievement != null && pPlayer != null) {
            pPlayer.func_71029_a((StatBase)this._mAchievement);
        }
    }

    private static final class StaticFields {
        private static AchievementPage AchievementsPage;
        private static HashMap<String, Achievement> AchievementList;

        private StaticFields() {
        }

        static {
            AchievementList = new HashMap();
        }
    }
}

