/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames;

import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.lootgames.LootGames;
import eu.usrv.lootgames.auxiliary.RandHelper;
import eu.usrv.lootgames.blocks.DungeonBrick;
import eu.usrv.lootgames.blocks.DungeonLightSource;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class StructureGenerator {
    public static int PUZZLEROOM_CENTER_TO_BORDER = 10;
    public static int PUZZLEROOM_HEIGHT = 8;
    public static int PUZZLEROOM_SURFACE_DISTANCE = 2;
    public static int PUZZLEROOM_MASTER_TE_OFFSET = 3;
    private World _mWorldObj;
    private int _mCenterX;
    private int _mCenterZ;
    private int _mSurface = -1;
    private int _mDungeonTop = -1;
    private int _mDungeonBottom = -1;
    private Material[] _mValidMaterials = new Material[]{Material.field_151575_d, Material.field_151586_h, Material.field_151570_A, Material.field_151597_y, Material.field_151577_b, Material.field_151584_j, Material.field_151585_k, Material.field_151579_a, Material.field_151587_i, Material.field_151567_E};

    public static void resetUnbreakablePlayfield(World pWorldObject, int pCoordX, int pCoordY, int pCoordZ) {
        for (int axisX = PUZZLEROOM_CENTER_TO_BORDER * -1; axisX <= PUZZLEROOM_CENTER_TO_BORDER; ++axisX) {
            for (int axisZ = PUZZLEROOM_CENTER_TO_BORDER * -1; axisZ <= PUZZLEROOM_CENTER_TO_BORDER; ++axisZ) {
                if (pWorldObject.func_147439_a(pCoordX + axisX, pCoordY, pCoordZ + axisZ) != LootGames.DungeonWallBlock || pWorldObject.func_72805_g(pCoordX + axisX, pCoordY, pCoordZ + axisZ) != 6) continue;
                pWorldObject.func_72921_c(pCoordX + axisX, pCoordY, pCoordZ + axisZ, 2, 2);
            }
        }
    }

    private boolean isValidSurfaceBlock(Block pBlock) {
        boolean tState = true;
        for (Material m : this._mValidMaterials) {
            if (pBlock.func_149688_o() != m) continue;
            tState = false;
            break;
        }
        LootGames.DungeonLogger.trace("StructureGenerator => isValidSurfaceBlock() Result is: %s", tState);
        return tState;
    }

    private boolean setSurfaceLevel(int pLocationX, int pLocationZ) {
        boolean tYLevelCheckPassed = true;
        for (int tSurfaceY = 128; tSurfaceY > 20; --tSurfaceY) {
            tYLevelCheckPassed = true;
            LootGames.DungeonLogger.trace("StructureGenerator => setSurfaceLevel(): Scanning y=%d", tSurfaceY);
            for (int axisX = PUZZLEROOM_CENTER_TO_BORDER * -1; axisX <= PUZZLEROOM_CENTER_TO_BORDER; ++axisX) {
                for (int axisZ = PUZZLEROOM_CENTER_TO_BORDER * -1; axisZ <= PUZZLEROOM_CENTER_TO_BORDER; ++axisZ) {
                    if (!this.isValidSurfaceBlock(this._mWorldObj.func_147439_a(axisX + pLocationX, tSurfaceY, axisZ + pLocationZ))) {
                        LootGames.DungeonLogger.trace("StructureGenerator => setSurfaceLevel(): y=%d has failed. Block is not valid: %s", tSurfaceY, GameRegistry.findUniqueIdentifierFor((Block)this._mWorldObj.func_147439_a(axisX, tSurfaceY, axisZ)).toString());
                        tYLevelCheckPassed = false;
                    }
                    if (!tYLevelCheckPassed) break;
                }
                if (!tYLevelCheckPassed) break;
            }
            if (!tYLevelCheckPassed) continue;
            LootGames.DungeonLogger.trace("StructureGenerator => setSurfaceLevel(): y=%d has passed", tSurfaceY);
            this._mSurface = tSurfaceY;
            this._mDungeonTop = this._mSurface - PUZZLEROOM_SURFACE_DISTANCE;
            this._mDungeonBottom = this._mSurface - (PUZZLEROOM_HEIGHT + PUZZLEROOM_SURFACE_DISTANCE);
            break;
        }
        return tYLevelCheckPassed;
    }

    public boolean generatePuzzleMicroDungeon(World pWorldObj, int pLocationX, int pLocationZ) {
        long tStart = System.currentTimeMillis();
        boolean tResult = this.doGenDungeon(pWorldObj, pLocationX, pLocationZ);
        long tStop = System.currentTimeMillis();
        LootGames.Profiler.AddTimeToList("WorldGen => generatePuzzleMicroDungeon()", tStop - tStart);
        return tResult;
    }

    public boolean doGenDungeon(World pWorldObj, int pLocationX, int pLocationZ) {
        LootGames.DungeonLogger.trace("StructureGenerator => generatePuzzleMicroDungeon()");
        this._mWorldObj = pWorldObj;
        this._mCenterX = pLocationX;
        this._mCenterZ = pLocationZ;
        if (!this.setSurfaceLevel(pLocationX, pLocationZ)) {
            LootGames.DungeonLogger.debug("Can't spawn PuzzleDungeon. Y level not found");
            return false;
        }
        LootGames.DungeonLogger.trace("StructureGenerator => generatePuzzleMicroDungeon() : Surface level found. Dungeon bottom at: y= %d", this._mDungeonBottom);
        if (this.checkForFreeSpace()) {
            int axisY;
            int axisZ;
            for (int axisX = PUZZLEROOM_CENTER_TO_BORDER * -1; axisX <= PUZZLEROOM_CENTER_TO_BORDER; ++axisX) {
                for (axisZ = PUZZLEROOM_CENTER_TO_BORDER * -1; axisZ <= PUZZLEROOM_CENTER_TO_BORDER; ++axisZ) {
                    for (axisY = this._mDungeonBottom; axisY <= this._mDungeonTop; ++axisY) {
                        this._mWorldObj.func_147468_f(axisX + this._mCenterX, axisY, axisZ + this._mCenterZ);
                        if (axisX == 0 && axisZ == 0 && axisY == this._mDungeonBottom + PUZZLEROOM_MASTER_TE_OFFSET) {
                            this._mWorldObj.func_147449_b(axisX + this._mCenterX, axisY, axisZ + this._mCenterZ, (Block)LootGames.MasterBlock);
                            continue;
                        }
                        if (axisY == this._mDungeonBottom) {
                            this._mWorldObj.func_147465_d(axisX + this._mCenterX, axisY, axisZ + this._mCenterZ, (Block)LootGames.DungeonWallBlock, RandHelper.chance(10, DungeonBrick.eDungeonBricks.FLOOR_CRACKED.ordinal(), DungeonBrick.eDungeonBricks.FLOOR.ordinal()).intValue(), 2);
                            continue;
                        }
                        if (axisY == this._mDungeonTop) {
                            this._mWorldObj.func_147465_d(axisX + this._mCenterX, axisY, axisZ + this._mCenterZ, (Block)LootGames.DungeonWallBlock, RandHelper.chance(10, DungeonBrick.eDungeonBricks.CEILING_CRACKED.ordinal(), DungeonBrick.eDungeonBricks.CEILING.ordinal()).intValue(), 2);
                            continue;
                        }
                        if (axisY == this._mDungeonBottom + 1) {
                            this._mWorldObj.func_147465_d(axisX + this._mCenterX, axisY, axisZ + this._mCenterZ, (Block)LootGames.DungeonWallBlock, DungeonBrick.eDungeonBricks.FLOOR_SHIELDED.ordinal(), 2);
                            continue;
                        }
                        if (axisX != PUZZLEROOM_CENTER_TO_BORDER * -1 && axisX != PUZZLEROOM_CENTER_TO_BORDER && axisZ != PUZZLEROOM_CENTER_TO_BORDER * -1 && axisZ != PUZZLEROOM_CENTER_TO_BORDER) continue;
                        if (axisY == this._mDungeonTop - (int)Math.floor(PUZZLEROOM_HEIGHT / 2)) {
                            this._mWorldObj.func_147465_d(axisX + this._mCenterX, axisY, axisZ + this._mCenterZ, (Block)LootGames.DungeonLightBlock, RandHelper.chance(10, DungeonLightSource.eState.BROKEN.ordinal(), DungeonLightSource.eState.NORMAL.ordinal()).intValue(), 2);
                            continue;
                        }
                        this._mWorldObj.func_147465_d(axisX + this._mCenterX, axisY, axisZ + this._mCenterZ, (Block)LootGames.DungeonWallBlock, RandHelper.chance(10, DungeonBrick.eDungeonBricks.WALL_CRACKED.ordinal(), DungeonBrick.eDungeonBricks.WALL.ordinal()).intValue(), 2);
                    }
                }
            }
            LootGames.DungeonLogger.info(String.format("PuzzleDungeon spawned at %d %d %d in Dimension %d", this._mCenterX, this._mDungeonBottom, this._mCenterZ, pWorldObj.field_73011_w.field_76574_g));
            Block tEntrance = Blocks.field_150350_a;
            axisZ = PUZZLEROOM_CENTER_TO_BORDER;
            axisY = this._mDungeonBottom + 2;
            int axisX = this._mCenterX;
            do {
                ++axisZ;
                for (axisX = this._mCenterX; axisX <= this._mCenterX; ++axisX) {
                    Block tCurrentBlock;
                    for (axisY = this._mDungeonBottom + 2; axisY <= this._mDungeonBottom + 4 && (tCurrentBlock = this._mWorldObj.func_147439_a(axisX, axisY + (axisZ - PUZZLEROOM_CENTER_TO_BORDER), axisZ + this._mCenterZ)).func_149688_o().func_76220_a(); ++axisY) {
                        this._mWorldObj.func_147468_f(axisX, axisY + (axisZ - PUZZLEROOM_CENTER_TO_BORDER), axisZ + this._mCenterZ);
                    }
                }
                tEntrance = this._mWorldObj.func_147439_a(this._mCenterX, axisY + (axisZ - PUZZLEROOM_CENTER_TO_BORDER), axisZ + this._mCenterZ);
            } while (axisZ - PUZZLEROOM_CENTER_TO_BORDER < 15 && (tEntrance != Blocks.field_150350_a || !this._mWorldObj.func_72937_j(this._mCenterX, axisY + (axisZ - PUZZLEROOM_CENTER_TO_BORDER), axisZ + this._mCenterZ)));
            return true;
        }
        LootGames.DungeonLogger.debug(String.format("PuzzleDungeon not spawned, location at X/Z %d %d is not suitable", pLocationX, pLocationZ));
        return false;
    }

    private boolean checkForFreeSpace() {
        boolean tResult = true;
        LootGames.DungeonLogger.trace("StructureGenerator => checkForFreeSpace()");
        for (int axisX = PUZZLEROOM_CENTER_TO_BORDER * -1; axisX <= PUZZLEROOM_CENTER_TO_BORDER; ++axisX) {
            block1: for (int axisZ = PUZZLEROOM_CENTER_TO_BORDER * -1; axisZ <= PUZZLEROOM_CENTER_TO_BORDER; ++axisZ) {
                for (int axisY = this._mDungeonBottom; axisY <= this._mDungeonTop; ++axisY) {
                    TileEntity tTE;
                    Block tBlock = this._mWorldObj.func_147439_a(axisX + this._mCenterX, axisY, axisZ + this._mCenterZ);
                    GameRegistry.UniqueIdentifier tBlockID = GameRegistry.findUniqueIdentifierFor((Block)tBlock);
                    if (tBlockID.modId.equalsIgnoreCase("gregtech") && tBlockID.name.toLowerCase().contains("blockores") || (tTE = this._mWorldObj.func_147438_o(axisX + this._mCenterX, axisY, axisZ + this._mCenterZ)) == null) continue;
                    LootGames.DungeonLogger.debug(String.format("Block at %d %d %d is a TileEntitiy. Skipping dungeon generator", axisX + this._mCenterX, axisY, axisZ + this._mCenterZ));
                    tResult = false;
                    continue block1;
                }
            }
        }
        LootGames.DungeonLogger.trace("StructureGenerator => checkForFreeSpace() : Result is %s", tResult);
        return tResult;
    }
}

