/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.lootgames.LootGamesDungeonLogger;
import eu.usrv.lootgames.achievements.LootGameAchievement;
import eu.usrv.lootgames.auxiliary.CheaterHandler;
import eu.usrv.lootgames.auxiliary.GameManager;
import eu.usrv.lootgames.auxiliary.LGDonorController;
import eu.usrv.lootgames.auxiliary.ProfilingStorage;
import eu.usrv.lootgames.blocks.DungeonBrick;
import eu.usrv.lootgames.blocks.DungeonLightSource;
import eu.usrv.lootgames.blocks.LootGamesMasterBlock;
import eu.usrv.lootgames.command.LootGamesCommand;
import eu.usrv.lootgames.command.PeacefulEntityCommand;
import eu.usrv.lootgames.command.ProfilingCommand;
import eu.usrv.lootgames.config.LootGamesConfig;
import eu.usrv.lootgames.items.ItemBlockMetaBlock;
import eu.usrv.lootgames.network.NetDispatcher;
import eu.usrv.lootgames.tiles.TELootGamesMasterBlock;
import eu.usrv.lootgames.worldgen.LootGamesWorldGen;
import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.creativetabs.ModCreativeTab;
import java.io.IOException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;

@Mod(modid="lootgames", dependencies="required-after:Forge@[10.13.4.1614,);required-after:YAMCore@[0.5.76,);", name="LootGames", version="1.0.20", certificateFingerprint="1cca375192a26693475fb48268f350a462208dce")
public class LootGames {
    public static final String MODID = "lootgames";
    public static final String MODNAME = "LootGames";
    public static final String VERSION = "1.0.20";
    public static Random Rnd = new Random();
    public static ModCreativeTab CreativeTab;
    public static LootGamesDungeonLogger DungeonLogger;
    public static CheaterHandler CheatHandler;
    public static ProfilingStorage Profiler;
    public static LootGamesMasterBlock MasterBlock;
    public static final LGDonorController DONOR_CONTROLLER;
    public static DungeonBrick DungeonWallBlock;
    public static DungeonLightSource DungeonLightBlock;
    public static GameManager GameMgr;
    public static LogHelper mLog;
    public static NetDispatcher NW;
    public static LootGamesConfig ModConfig;
    public static LootGamesWorldGen WorldGen;
    @Mod.Instance(value="lootgames")
    public static LootGames INSTANCE;

    @Mod.EventHandler
    public void PreLoad(FMLPreInitializationEvent PreEvent) {
        ModConfig = new LootGamesConfig(PreEvent.getModConfigurationDirectory(), MODNAME, MODID);
        if (!ModConfig.LoadConfig()) {
            mLog.error((Object)String.format("%s could not load its config file. Things are going to be weird!", MODID));
        }
        DONOR_CONTROLLER.loadDonors();
        Profiler = new ProfilingStorage();
        CheatHandler = new CheaterHandler();
        DungeonLogger = new LootGamesDungeonLogger();
        try {
            DungeonLogger.setup();
        }
        catch (IOException e) {
            mLog.error((Object)"Unable to open DungeonLogger logfile. Spawned dungeons will not get recorded!");
            e.printStackTrace();
        }
        CreativeTab = new ModCreativeTab(MODNAME, Items.field_151122_aG);
        WorldGen = new LootGamesWorldGen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)WorldGen, (int)Integer.MAX_VALUE);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.initBaseBlocks();
        GameMgr = new GameManager();
        GameMgr.initGames();
        NW = new NetDispatcher();
        NW.registerPackets();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LootGameAchievement.registerAchievementPage();
    }

    @Mod.EventHandler
    public void onComplete(FMLLoadCompleteEvent event) {
        DONOR_CONTROLLER.fetchDonors();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent pEvent) {
        pEvent.registerServerCommand((ICommand)new LootGamesCommand());
        pEvent.registerServerCommand((ICommand)new ProfilingCommand());
        if (YAMCore.isDebug()) {
            pEvent.registerServerCommand((ICommand)new PeacefulEntityCommand());
        }
    }

    private void initBaseBlocks() {
        DungeonWallBlock = new DungeonBrick();
        DungeonLightBlock = new DungeonLightSource();
        MasterBlock = new LootGamesMasterBlock();
        GameRegistry.registerTileEntity(TELootGamesMasterBlock.class, (String)"LOOTGAMES_MASTER_TE");
        GameRegistry.registerBlock((Block)MasterBlock, (String)"LootGamesMasterBlock");
        GameRegistry.registerBlock((Block)DungeonWallBlock, ItemBlockMetaBlock.class, (String)"LootGamesDungeonWall");
        GameRegistry.registerBlock((Block)DungeonLightBlock, ItemBlockMetaBlock.class, (String)"LootGamesDungeonLight");
    }

    static {
        DONOR_CONTROLLER = new LGDonorController("https://pastebin.com/raw/x1K80mwb");
        mLog = new LogHelper(MODNAME);
    }
}

