/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.search;

import com.jamesswafford.chess4j.ChessEngineApp;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.board.MoveGen;
import com.jamesswafford.chess4j.book.BookMove;
import com.jamesswafford.chess4j.hash.PawnTranspositionTable;
import com.jamesswafford.chess4j.hash.TranspositionTable;
import com.jamesswafford.chess4j.io.PrintGameResult;
import com.jamesswafford.chess4j.io.PrintLine;
import com.jamesswafford.chess4j.search.Search;
import com.jamesswafford.chess4j.search.SearchStats;
import com.jamesswafford.chess4j.utils.GameStatus;
import com.jamesswafford.chess4j.utils.GameStatusChecker;
import com.jamesswafford.chess4j.utils.MoveUtils;
import com.jamesswafford.chess4j.utils.TimeUtils;
import eu.usrv.lootgames.chess.ChessEngineProxy;
import eu.usrv.yamcore.auxiliary.LogHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SearchIterator {
    public static final Object ponderMutex = new Object();
    private static final SearchIterator INSTANCE = new SearchIterator();
    public static boolean useOpeningBook = false;
    public static boolean ponderEnabled;
    public static int maxDepth;
    public static int remainingTimeMS;
    public static int incrementMS;
    public static int maxTime;
    public static boolean showThinking;
    public static boolean abortIterator;
    private static LogHelper mLog;
    private static boolean pondering;
    private static Move ponderMove;

    private SearchIterator() {
    }

    public static SearchIterator getInstance() {
        return INSTANCE;
    }

    public static Thread think() {
        abortIterator = false;
        Board searchPos = Board.INSTANCE.deepCopy();
        class Thinker
        implements Runnable {
            final /* synthetic */ Board val$searchPos;

            Thinker(Board board) {
                this.val$searchPos = board;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                pondering = false;
                List<Move> pv = SearchIterator.iterate(this.val$searchPos, false);
                assert (Board.INSTANCE.equals(this.val$searchPos));
                Board.INSTANCE.applyMove(pv.get(0));
                ChessEngineProxy.getInstance().publishAnswer("move " + pv.get(0));
                GameStatus gs = GameStatusChecker.getGameStatus();
                boolean ponderSuccess = true;
                while (!abortIterator && gs == GameStatus.INPROGRESS && ponderEnabled && pv.size() > 1 && ponderSuccess) {
                    ponderMove = pv.get(1);
                    mLog.info((Object)("### START PONDERING: " + ponderMove));
                    pondering = true;
                    this.val$searchPos.applyMove(pv.get(0));
                    this.val$searchPos.applyMove(ponderMove);
                    pv = SearchIterator.iterate(this.val$searchPos, false);
                    mLog.info((Object)("# ponder search terminated.  analysis mode?: " + Search.analysisMode));
                    Object object = ponderMutex;
                    synchronized (object) {
                        if (!pondering) {
                            assert (Board.INSTANCE.equals(this.val$searchPos));
                            Board.INSTANCE.applyMove(pv.get(0));
                            ChessEngineProxy.getInstance().publishAnswer("move " + pv.get(0));
                            gs = GameStatusChecker.getGameStatus();
                        } else {
                            pondering = false;
                            ponderSuccess = false;
                        }
                    }
                }
                mLog.info((Object)"### exiting search thread");
                if (gs != GameStatus.INPROGRESS) {
                    PrintGameResult.printResult(gs);
                }
            }
        }
        Thread thinkThread = new Thread(new Thinker(searchPos));
        thinkThread.start();
        return thinkThread;
    }

    public static void calculateSearchTimes() {
        maxTime = TimeUtils.getSearchTime(remainingTimeMS, incrementMS);
        Search.stopTime = Search.startTime + (long)maxTime;
        mLog.debug((Object)("# calculated search time: " + maxTime));
    }

    public static List<Move> iterate(Board board, boolean testSuiteMode) {
        BookMove bookMove;
        if (!testSuiteMode && !pondering && useOpeningBook && ChessEngineApp.getOpeningBook() != null && (bookMove = ChessEngineApp.getOpeningBook().getMoveWeightedRandomByFrequency(board)) != null) {
            mLog.debug((Object)("# book move: " + bookMove));
            return Arrays.asList(bookMove.getMove());
        }
        List<Move> moves = MoveGen.genLegalMoves(board);
        mLog.debug((Object)("# position has " + moves.size() + " move(s)"));
        if (!testSuiteMode && moves.size() == 1) {
            return Arrays.asList(moves.get(0));
        }
        TranspositionTable.getInstance().clear();
        ArrayList<Move> pv = new ArrayList<Move>();
        SearchStats stats = new SearchStats();
        Search.analysisMode = pondering;
        Search.abortSearch = false;
        Search.startTime = System.currentTimeMillis();
        if (testSuiteMode) {
            Search.stopTime = Search.startTime + (long)maxTime;
        } else {
            SearchIterator.calculateSearchTimes();
        }
        int depth = 0;
        boolean stopSearching = false;
        int score = 0;
        do {
            int alphaBound = -50000;
            int betaBound = 50000;
            if (++depth > 2) {
                alphaBound = score - 33;
                betaBound = score + 33;
            }
            if (!((score = Search.search(pv, alphaBound, betaBound, board, depth, stats, true)) > alphaBound && score < betaBound || Search.abortSearch)) {
                mLog.debug((Object)("# research depth " + depth + "! alpha=" + alphaBound + ", beta=" + betaBound + ", score=" + score));
                score = Search.search(pv, -50000, 50000, board, depth, stats, true);
            }
            assert (pv.size() > 0);
            if (Search.abortSearch) break;
            if (showThinking) {
                PrintLine.printLine(pv, depth, score, Search.startTime, stats.getNodes());
            }
            stats.setLastPV(pv);
            if (Math.abs(score) > 29500) {
                mLog.debug((Object)"# stopping iterative search because mate found");
                stopSearching = true;
            }
            if (maxDepth > 0 && depth >= maxDepth) {
                mLog.debug((Object)"# stopping iterative search on depth");
                stopSearching = true;
            }
            long elapsedTime = System.currentTimeMillis() - Search.startTime;
            if (pondering || testSuiteMode || elapsedTime <= (long)(maxTime / 2)) continue;
            mLog.debug((Object)"# stopping iterative search because half time expired.");
            stopSearching = true;
        } while (!stopSearching);
        assert (pv.size() > 0);
        assert (MoveUtils.isLineValid(pv, board));
        SearchIterator.printSearchSummary(stats);
        return pv;
    }

    private static void printSearchSummary(SearchStats stats) {
        DecimalFormat df = new DecimalFormat("0.00");
        DecimalFormat df2 = new DecimalFormat("#,###,##0");
        long totalNodes = stats.getNodes() + stats.getQNodes();
        double interiorPct = (double)stats.getNodes() / ((double)totalNodes / 100.0);
        double qnodePct = (double)stats.getQNodes() / ((double)totalNodes / 100.0);
        mLog.info((Object)"\n");
        mLog.info((Object)("# nodes: " + df2.format(totalNodes) + ", interior: " + df2.format(stats.getNodes()) + " (" + df.format(interiorPct) + "%), quiescense: " + df2.format(stats.getQNodes()) + " (" + df.format(qnodePct) + "%)"));
        long totalSearchTime = System.currentTimeMillis() - Search.startTime;
        mLog.info((Object)("# search time: " + (double)totalSearchTime / 1000.0 + " seconds, rate: " + df2.format((double)totalNodes / ((double)totalSearchTime / 1000.0)) + " nodes per second"));
        long hashHits = TranspositionTable.getInstance().getNumHits();
        long hashProbes = TranspositionTable.getInstance().getNumProbes();
        long hashCollisions = TranspositionTable.getInstance().getNumCollisions();
        double hashHitPct = (double)hashHits / ((double)hashProbes / 100.0);
        double hashCollisionPct = (double)hashCollisions / ((double)hashProbes / 100.0);
        mLog.info((Object)("# hash probes: " + df2.format(hashProbes) + ", hits: " + df2.format(hashHits) + " (" + df.format(hashHitPct) + "%), collisions: " + df2.format(hashCollisions) + " (" + df.format(hashCollisionPct) + "%)"));
        double failHighPct = (double)stats.getFailHighs() / ((double)hashProbes / 100.0);
        double failLowPct = (double)stats.getFailLows() / ((double)hashProbes / 100.0);
        double exactScorePct = (double)stats.getHashExactScores() / ((double)hashProbes / 100.0);
        mLog.info((Object)("# fail highs: " + df2.format(stats.getFailHighs()) + " (" + df.format(failHighPct) + "%), fail lows: " + df2.format(stats.getFailLows()) + " (" + df.format(failLowPct) + "%), exact scores: " + df2.format(stats.getHashExactScores()) + " (" + df.format(exactScorePct) + "%)"));
        long pawnHashHits = PawnTranspositionTable.getInstance().getNumHits();
        long pawnHashProbes = PawnTranspositionTable.getInstance().getNumProbes();
        long pawnHashCollisions = PawnTranspositionTable.getInstance().getNumCollisions();
        double pawnHashHitPct = (double)pawnHashHits / ((double)pawnHashProbes / 100.0);
        double pawnHashCollisionPct = (double)pawnHashCollisions / ((double)pawnHashProbes / 100.0);
        mLog.info((Object)("# pawn hash probes: " + df2.format(pawnHashProbes) + ", hits: " + df2.format(pawnHashHits) + " (" + df.format(pawnHashHitPct) + "%), collisions: " + df2.format(pawnHashCollisions) + " (" + df.format(pawnHashCollisionPct) + "%)"));
    }

    public static Move getPonderMove() {
        return ponderMove;
    }

    public static boolean isPondering() {
        return pondering;
    }

    public static void stopPondering() {
        pondering = false;
        Search.analysisMode = false;
    }

    static {
        showThinking = true;
        abortIterator = false;
        mLog = new LogHelper("LootGames - ChessEngine");
    }
}

