/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.hash;

import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.hash.TranspositionTableEntryType;

public class TranspositionTableEntry {
    private TranspositionTableEntryType type;
    private long zobristKey;
    private int score;
    private int depth;
    private Move move;

    public TranspositionTableEntry(TranspositionTableEntryType type, long zobristKey, int score, int depth, Move move) {
        this.type = type;
        this.zobristKey = zobristKey;
        this.score = score;
        this.depth = depth;
        this.move = move;
    }

    public TranspositionTableEntryType getType() {
        return this.type;
    }

    public long getZobristKey() {
        return this.zobristKey;
    }

    public int getScore() {
        return this.score;
    }

    public Move getMove() {
        return this.move;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TranspositionTableEntry)) {
            return false;
        }
        TranspositionTableEntry that = (TranspositionTableEntry)obj;
        if (this.getZobristKey() != that.getZobristKey()) {
            return false;
        }
        if (this.getScore() != that.getScore()) {
            return false;
        }
        if (this.getDepth() != that.getDepth()) {
            return false;
        }
        if (this.getMove() == null) {
            return that.getMove() == null;
        }
        return this.getMove().equals(that.getMove());
    }

    public int hashCode() {
        int hc = (int)this.getZobristKey();
        hc = hc * 31 + this.getScore();
        hc = hc * 17 + this.getDepth();
        hc = hc * 31 + (this.getMove() == null ? 0 : this.getMove().hashCode());
        return hc;
    }
}

