/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames.gol.tiles;

import cpw.mods.fml.common.network.NetworkRegistry;
import eu.usrv.lootgames.LootGames;
import eu.usrv.lootgames.StructureGenerator;
import eu.usrv.lootgames.achievements.LootGameAchievement;
import eu.usrv.lootgames.auxiliary.ExtendedDirections;
import eu.usrv.lootgames.blocks.DungeonLightSource;
import eu.usrv.lootgames.config.LootGamesConfig;
import eu.usrv.lootgames.gol.GameOfLightGame;
import eu.usrv.lootgames.network.msg.SpawnParticleFXMessage;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.event.world.NoteBlockEvent;

public class TELightGameBlock
extends TileEntity {
    private Vec3 mNorthPos;
    private Vec3 mSouthPos;
    private Vec3 mWestPos;
    private Vec3 mEastPos;
    private Vec3 mNorthWestPos;
    private Vec3 mNorthEastPos;
    private Vec3 mSouthWestPos;
    private Vec3 mSouthEastPos;
    private Vec3 mMasterPos;
    private HashMap<ExtendedDirections, Long> _mActiveBlocks = new HashMap();
    private TELightGameBlock _mGameBlockNorth;
    private TELightGameBlock _mGameBlockWest;
    private TELightGameBlock _mGameBlockSouth;
    private TELightGameBlock _mGameBlockEast;
    private TELightGameBlock _mGameBlockNE;
    private TELightGameBlock _mGameBlockNW;
    private TELightGameBlock _mGameBlockSE;
    private TELightGameBlock _mGameBlockSW;
    private TELightGameBlock _mMasterTE;
    private ExtendedDirections mTEDirection = ExtendedDirections.UP;
    private boolean mIsMaster;
    private boolean mIsActive;
    private int mFailedAttempts;
    private int mCurrentLevel = 1;
    private int mMaxLevelReached = 1;
    private ArrayList<Integer> mCurrentGameSequence = new ArrayList();
    private ArrayList<Integer> mCurrentEnteredSequence = new ArrayList();
    private UUID mCurrentPlayer = null;
    private long mLastGameClickTime = -1L;
    private long mLastGameReplayTime = -1L;
    private int mLastPlayedDigitIndex = -1;
    private eGameStage mGameStage = eGameStage.UNDEPLOYED;
    private int mNumCheatAttemptsDetected = 0;
    private static String NBTTAG_ISACTIVE = "mIsActive";
    private static String NBTTAG_ISMASTER = "mIsMaster";
    private static String NBTTAG_DIRECTION = "mTEDirection";
    private static String NBTTAG_BLOCK_NORTH = "mGameBlockNorth";
    private static String NBTTAG_BLOCK_SOUTH = "mGameBlockSouth";
    private static String NBTTAG_BLOCK_WEST = "mGameBlockEast";
    private static String NBTTAG_BLOCK_EAST = "mGameBlockWest";
    private static String NBTTAG_BLOCK_NW = "mGameBlockNW";
    private static String NBTTAG_BLOCK_NE = "mGameBlockNE";
    private static String NBTTAG_BLOCK_SW = "mGameBlockSW";
    private static String NBTTAG_BLOCK_SE = "mGameBlockSE";
    private static String NBTTAG_BLOCK_MASTER = "mMasterBlock";
    private static String NBTTAG_BLOCKPOS_X = "posX";
    private static String NBTTAG_BLOCKPOS_Y = "posY";
    private static String NBTTAG_BLOCKPOS_Z = "posZ";

    public boolean getIsActive() {
        return this.mIsActive;
    }

    public ExtendedDirections getDirection() {
        return this.mTEDirection;
    }

    private TELightGameBlock getBlockNorth() {
        if (this._mGameBlockNorth == null && this.mNorthPos != null) {
            this._mGameBlockNorth = (TELightGameBlock)this.field_145850_b.func_147438_o((int)this.mNorthPos.field_72450_a, (int)this.mNorthPos.field_72448_b, (int)this.mNorthPos.field_72449_c);
        }
        return this._mGameBlockNorth;
    }

    private TELightGameBlock getBlockWest() {
        if (this._mGameBlockWest == null && this.mWestPos != null) {
            this._mGameBlockWest = (TELightGameBlock)this.field_145850_b.func_147438_o((int)this.mWestPos.field_72450_a, (int)this.mWestPos.field_72448_b, (int)this.mWestPos.field_72449_c);
        }
        return this._mGameBlockWest;
    }

    private TELightGameBlock getBlockSouth() {
        if (this._mGameBlockSouth == null && this.mSouthPos != null) {
            this._mGameBlockSouth = (TELightGameBlock)this.field_145850_b.func_147438_o((int)this.mSouthPos.field_72450_a, (int)this.mSouthPos.field_72448_b, (int)this.mSouthPos.field_72449_c);
        }
        return this._mGameBlockSouth;
    }

    private TELightGameBlock getBlockEast() {
        if (this._mGameBlockEast == null && this.mEastPos != null) {
            this._mGameBlockEast = (TELightGameBlock)this.field_145850_b.func_147438_o((int)this.mEastPos.field_72450_a, (int)this.mEastPos.field_72448_b, (int)this.mEastPos.field_72449_c);
        }
        return this._mGameBlockEast;
    }

    private TELightGameBlock getBlockMaster() {
        if (this._mMasterTE == null && this.mMasterPos != null) {
            this._mMasterTE = (TELightGameBlock)this.field_145850_b.func_147438_o((int)this.mMasterPos.field_72450_a, (int)this.mMasterPos.field_72448_b, (int)this.mMasterPos.field_72449_c);
        }
        return this._mMasterTE;
    }

    private TELightGameBlock getBlockNW() {
        if (this._mGameBlockNW == null && this.mNorthWestPos != null) {
            this._mGameBlockNW = (TELightGameBlock)this.field_145850_b.func_147438_o((int)this.mNorthWestPos.field_72450_a, (int)this.mNorthWestPos.field_72448_b, (int)this.mNorthWestPos.field_72449_c);
        }
        return this._mGameBlockNW;
    }

    private TELightGameBlock getBlockNE() {
        if (this._mGameBlockNE == null && this.mNorthEastPos != null) {
            this._mGameBlockNE = (TELightGameBlock)this.field_145850_b.func_147438_o((int)this.mNorthEastPos.field_72450_a, (int)this.mNorthEastPos.field_72448_b, (int)this.mNorthEastPos.field_72449_c);
        }
        return this._mGameBlockNE;
    }

    private TELightGameBlock getBlockSW() {
        if (this._mGameBlockSW == null && this.mSouthWestPos != null) {
            this._mGameBlockSW = (TELightGameBlock)this.field_145850_b.func_147438_o((int)this.mSouthWestPos.field_72450_a, (int)this.mSouthWestPos.field_72448_b, (int)this.mSouthWestPos.field_72449_c);
        }
        return this._mGameBlockSW;
    }

    private TELightGameBlock getBlockSE() {
        if (this._mGameBlockSE == null && this.mSouthEastPos != null) {
            this._mGameBlockSE = (TELightGameBlock)this.field_145850_b.func_147438_o((int)this.mSouthEastPos.field_72450_a, (int)this.mSouthEastPos.field_72448_b, (int)this.mSouthEastPos.field_72449_c);
        }
        return this._mGameBlockSE;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void toggleMusicMode(EntityPlayer pPlayer) {
        if (this.mGameStage == eGameStage.PLAYMUSIC) {
            PlayerChatHelper.SendNotifyNormal((EntityPlayer)pPlayer, (String)"The Structure has woken up");
            this.mGameStage = eGameStage.SLEEP;
        } else {
            PlayerChatHelper.SendNotifyNormal((EntityPlayer)pPlayer, (String)"The Structure has fallen asleep");
            this.mGameStage = eGameStage.PLAYMUSIC;
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onBlockClickedByPlayer(ExtendedDirections pDirection, EntityPlayer pPlayer) {
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)"TE clicked");
        }
        if (this.getBlockEast() == null && this.getBlockNorth() == null && this.getBlockSouth() == null && this.getBlockWest() == null && !this.mIsMaster && this.getBlockMaster() == null && this.mGameStage == eGameStage.UNDEPLOYED) {
            if (LootGames.ModConfig.GolConfig.Debug) {
                LootGames.mLog.info((Object)"No master found, using *me*");
            }
            this._mMasterTE = this;
            this.mIsMaster = true;
        }
        if (this.mIsMaster) {
            if (LootGames.ModConfig.GolConfig.Debug) {
                LootGames.mLog.info((Object)String.format("...master GameStage is %s", this.mGameStage.toString()));
            }
            if (!this.checkAirSpaceAboveBlock()) {
                this.HandleCheatDetected(pPlayer);
            }
            switch (this.mGameStage) {
                case UNDEPLOYED: {
                    this.checkOrDeployStructure();
                    this.resetGame(pPlayer, true);
                    break;
                }
                case SLEEP: {
                    this.resetGame(pPlayer, true);
                    break;
                }
                case ACTIVE_PLAY_SEQUENCE: {
                    PlayerChatHelper.SendNotifyNormal((EntityPlayer)pPlayer, (String)"You feel that the structure is not yet ready...");
                    break;
                }
                case PLAYMUSIC: {
                    if (pDirection == null) break;
                    this.sendFeedbackSoundNote(pDirection);
                    this._mActiveBlocks.put(pDirection, System.currentTimeMillis());
                    this.toggleGameBlockActiveState(pDirection, true);
                    break;
                }
                case ACTIVE_WAIT_FOR_PLAYER: {
                    if (pDirection != null) {
                        this.mLastGameClickTime = System.currentTimeMillis();
                        this.handleBlockInput(pDirection, pPlayer);
                        break;
                    }
                    PlayerChatHelper.SendNotifyNormal((EntityPlayer)pPlayer, (String)"You should replay the colors now...");
                    break;
                }
                case PENDING_GAME_START: {
                    PlayerChatHelper.SendNotifyNormal((EntityPlayer)pPlayer, (String)"You feel that the structure is not yet ready...");
                }
            }
        } else {
            if (LootGames.ModConfig.GolConfig.Debug) {
                LootGames.mLog.info((Object)"...slave. Forwarding to master");
            }
            this.getBlockMaster().onBlockClickedByPlayer(this.mTEDirection, pPlayer);
        }
    }

    private void HandleCheatDetected(EntityPlayer pPlayer) {
        ++this.mNumCheatAttemptsDetected;
        this.clearPlayFieldAboveBlock();
        if (this.mNumCheatAttemptsDetected == 1) {
            PlayerChatHelper.SendWarn((EntityPlayer)pPlayer, (String)"Do not obstruct the playfield!");
        }
        if (this.mNumCheatAttemptsDetected == 2) {
            PlayerChatHelper.SendWarn((EntityPlayer)pPlayer, (String)"Last warning: Do-not-obstruct-the-playfield!");
        }
        if (this.mNumCheatAttemptsDetected > 2) {
            PlayerChatHelper.SendError((EntityPlayer)pPlayer, (String)"Cheater!");
            this.mGameStage = eGameStage.SLEEP;
            this.mNumCheatAttemptsDetected = 0;
            LootGames.CheatHandler.doRandomCheaterEvent(pPlayer);
        }
    }

    private void clearPlayFieldAboveBlock() {
        for (int offsetX = -3; offsetX <= 3; ++offsetX) {
            for (int offsetZ = -3; offsetZ <= 3; ++offsetZ) {
                for (int offsetY = 1; offsetY <= 4; ++offsetY) {
                    this.field_145850_b.func_147468_f(this.field_145851_c + offsetX, this.field_145848_d + offsetY, this.field_145849_e + offsetZ);
                }
            }
        }
    }

    private boolean checkAirSpaceAboveBlock() {
        boolean tState = true;
        for (int offsetX = -3; offsetX <= 3 && tState; ++offsetX) {
            for (int offsetZ = -3; offsetZ <= 3 && tState; ++offsetZ) {
                for (int offsetY = 1; offsetY <= 4 && tState; ++offsetY) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + offsetX, this.field_145848_d + offsetY, this.field_145849_e + offsetZ).func_149688_o() == Material.field_151579_a) continue;
                    tState = false;
                }
            }
        }
        return tState;
    }

    private static <T> String joinList(List<T> pSourceList, String pDelimiter) {
        String tRet = "";
        boolean tIsFirstRun = true;
        for (T element : pSourceList) {
            if (tIsFirstRun) {
                tIsFirstRun = false;
            } else {
                tRet = tRet + String.format("%s ", pDelimiter);
            }
            tRet = tRet + element.toString();
        }
        return tRet;
    }

    private void handleBlockInput(ExtendedDirections pDirection, EntityPlayer pPlayer) {
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)String.format("Received input for direction %s", pDirection.toString()));
        }
        if (!this.mCurrentPlayer.equals(pPlayer.func_110124_au())) {
            PlayerChatHelper.SendNotifyNormal((EntityPlayer)pPlayer, (String)"The structure doesn't seem to recognize you");
            if (LootGames.ModConfig.GolConfig.Debug) {
                LootGames.mLog.info((Object)String.format("Wrong playerID. ignoring %s", this.mGameStage.toString()));
            }
            return;
        }
        this.sendFeedbackSoundNote(pDirection);
        this._mActiveBlocks.put(pDirection, System.currentTimeMillis());
        this.toggleGameBlockActiveState(pDirection, true);
        if (this.mCurrentEnteredSequence.size() < this.mCurrentGameSequence.size()) {
            int tExpectedOrdinal = this.mCurrentGameSequence.get(this.mCurrentEnteredSequence.size());
            if (LootGames.ModConfig.GolConfig.Debug) {
                LootGames.mLog.info((Object)String.format("tExpectedOrdinal %d gotOrdinal %d", tExpectedOrdinal, pDirection.ordinal()));
            }
            if (tExpectedOrdinal == pDirection.ordinal()) {
                this.mCurrentEnteredSequence.add(pDirection.ordinal());
                if (LootGames.ModConfig.GolConfig.Debug) {
                    LootGames.mLog.info((Object)String.format("CurrSeq  [%s]", TELightGameBlock.joinList(this.mCurrentGameSequence, ",")));
                }
                if (LootGames.ModConfig.GolConfig.Debug) {
                    LootGames.mLog.info((Object)String.format("EnterSeq [%s]", TELightGameBlock.joinList(this.mCurrentEnteredSequence, ",")));
                }
                if (this.mCurrentEnteredSequence.size() == this.mCurrentGameSequence.size()) {
                    if (this.mCurrentGameSequence.size() >= LootGames.ModConfig.GolConfig.GameStageIV.getMinDigitsRequired(this.field_145850_b)) {
                        this.mMaxLevelReached = 5;
                        this.processGameOver(pPlayer);
                    } else {
                        this.sendFeedbackSound(eSoundType.SND_GAME_SEQUENCE_CORRECT);
                        this.mCurrentEnteredSequence.clear();
                        if (LootGames.ModConfig.GolConfig.Debug) {
                            LootGames.mLog.info((Object)String.format("Checking levelup Current: %d Stage: %d", this.mCurrentLevel, this.getCurrentGameStage().LevelID));
                        }
                        if (this.getCurrentGameStage().LevelID > this.mCurrentLevel) {
                            this.mMaxLevelReached = this.getCurrentGameStage().LevelID;
                            this.sendFeedbackParticles(eFXType.FX_GAME_WIN, this._mMasterTE);
                            this.sendFeedbackSound(eSoundType.SND_LEVELUP);
                            PlayerChatHelper.SendInfo((EntityPlayer)pPlayer, (String)"The Structure seems to acknowledge your efforts...");
                            if (LootGames.ModConfig.GolConfig.Debug) {
                                PlayerChatHelper.SendInfo((EntityPlayer)pPlayer, (String)String.format("LevelUp detected %d > %d", this.mCurrentLevel, this.getCurrentGameStage().LevelID));
                            }
                            if (LootGames.ModConfig.GolConfig.Debug) {
                                LootGames.mLog.info((Object)String.format("Levelup detected %d > %d", this.mCurrentLevel, this.getCurrentGameStage().LevelID));
                            }
                        }
                        this.mCurrentLevel = this.getCurrentGameStage().LevelID;
                        this.updateGameSequence();
                        this.mLastGameReplayTime = System.currentTimeMillis() + 2000L;
                        this.mLastPlayedDigitIndex = -1;
                        this.toggleGameBlockActiveState(ExtendedDirections.UP, false);
                        this.mGameStage = eGameStage.ACTIVE_PLAY_SEQUENCE;
                    }
                }
            } else if (++this.mFailedAttempts <= LootGames.ModConfig.GolConfig.MaxGameTries) {
                PlayerChatHelper.SendNotifyWarning((EntityPlayer)pPlayer, (String)"It appears you touched the wrong Block...");
                this.sendFeedbackSound(eSoundType.SND_GAME_SEQUENCE_WRONG);
                this.resetGame(pPlayer, 2000, false);
            } else {
                this.processGameOver(pPlayer);
            }
        }
    }

    private LootGamesConfig.LootStageConfig getCurrentGameStage() {
        LootGamesConfig.LootStageConfig tlst = this.mCurrentGameSequence.size() + 1 >= LootGames.ModConfig.GolConfig.GameStageIII.getMinDigitsRequired(this.field_145850_b) ? LootGames.ModConfig.GolConfig.GameStageIV : (this.mCurrentGameSequence.size() + 1 >= LootGames.ModConfig.GolConfig.GameStageII.getMinDigitsRequired(this.field_145850_b) ? LootGames.ModConfig.GolConfig.GameStageIII : (this.mCurrentGameSequence.size() + 1 >= LootGames.ModConfig.GolConfig.GameStageI.getMinDigitsRequired(this.field_145850_b) ? LootGames.ModConfig.GolConfig.GameStageII : LootGames.ModConfig.GolConfig.GameStageI));
        return tlst;
    }

    private boolean doFullColorSet(int pStageID) {
        return pStageID >= LootGames.ModConfig.GolConfig.ExpandPlayFieldAtStage;
    }

    private void updateGameSequence() {
        LootGamesConfig.LootStageConfig lsc = this.getCurrentGameStage();
        if (lsc.RandomizeSequence) {
            int tTargetAmount = this.mCurrentGameSequence.size() + 1;
            this.mCurrentGameSequence = new ArrayList();
            for (int i = 0; i < tTargetAmount; ++i) {
                this.mCurrentGameSequence.add(LootGames.Rnd.nextInt(this.doFullColorSet(lsc.LevelID) ? 8 : 4) + 2);
            }
        } else {
            this.mCurrentGameSequence.add(LootGames.Rnd.nextInt(this.doFullColorSet(lsc.LevelID) ? 8 : 4) + 2);
        }
    }

    private void setBlockDirectionTo(ExtendedDirections pDirection, Block pBlock) {
        this.setBlockDirectionTo(pDirection, pBlock, 0);
    }

    private void setBlockDirectionTo(ExtendedDirections pDirection, Block pBlock, int pMeta) {
        this.field_145850_b.func_147465_d(this.field_145851_c + pDirection.offsetX, this.field_145848_d + pDirection.offsetY, this.field_145849_e + pDirection.offsetZ, pBlock, pMeta, 3);
    }

    private void setBlockDirectionToAir(ExtendedDirections pDirection) {
        this.setBlockDirectionTo(pDirection, Blocks.field_150350_a);
    }

    private void processGameOver(EntityPlayer pPlayer) {
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)"Gameover, destroying TEs and blocks");
        }
        boolean tLostGame = false;
        if (this.mMaxLevelReached == 1 && this.mCurrentGameSequence.size() < LootGames.ModConfig.GolConfig.GameStageI.getMinDigitsRequired(this.field_145850_b)) {
            if (LootGames.ModConfig.GolConfig.Debug) {
                LootGames.mLog.info((Object)String.format("Game Lost. Current digits: %d MinRequired for StageI: %d", this.mCurrentGameSequence.size(), LootGames.ModConfig.GolConfig.GameStageI.getMinDigitsRequired(this.field_145850_b)));
            }
            tLostGame = true;
            LootGameAchievement.LOOSE_A_GAME.triggerAchievement(pPlayer);
            PlayerChatHelper.SendWarn((EntityPlayer)pPlayer, (String)"The Structure seems to be offended by your failure");
        } else {
            LootGameAchievement.BEAT_A_GAME.triggerAchievement(pPlayer);
            this.sendFeedbackSound(eSoundType.SND_GAME_END_WIN);
            this.sendFeedbackParticles(eFXType.FX_GAME_WIN, this.getBlockWest());
            this.sendFeedbackParticles(eFXType.FX_GAME_WIN, this.getBlockSouth());
            this.sendFeedbackParticles(eFXType.FX_GAME_WIN, this.getBlockNorth());
            this.sendFeedbackParticles(eFXType.FX_GAME_WIN, this.getBlockEast());
        }
        this.setBlockDirectionToAir(ExtendedDirections.NORTH);
        this.setBlockDirectionToAir(ExtendedDirections.EAST);
        this.setBlockDirectionToAir(ExtendedDirections.SOUTH);
        this.setBlockDirectionToAir(ExtendedDirections.WEST);
        this.setBlockDirectionTo(ExtendedDirections.NORTHEAST, LootGames.DungeonLightBlock, DungeonLightSource.eState.NORMAL.ordinal());
        this.setBlockDirectionTo(ExtendedDirections.NORTHWEST, LootGames.DungeonLightBlock, DungeonLightSource.eState.NORMAL.ordinal());
        this.setBlockDirectionTo(ExtendedDirections.SOUTHEAST, LootGames.DungeonLightBlock, DungeonLightSource.eState.NORMAL.ordinal());
        this.setBlockDirectionTo(ExtendedDirections.SOUTHWEST, LootGames.DungeonLightBlock, DungeonLightSource.eState.NORMAL.ordinal());
        this._mGameBlockNorth = null;
        this._mGameBlockEast = null;
        this._mGameBlockSouth = null;
        this._mGameBlockWest = null;
        this._mGameBlockNE = null;
        this._mGameBlockNW = null;
        this._mGameBlockSE = null;
        this._mGameBlockSW = null;
        this.func_145843_s();
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)"Spawn chests");
        }
        if (this.mMaxLevelReached >= 5) {
            this.spawnLootChest(ExtendedDirections.NORTH, LootGames.ModConfig.GolConfig.GameStageIV);
            LootGameAchievement.GOL_MASTER_LEVEL4.triggerAchievement(pPlayer);
        }
        if (this.mMaxLevelReached >= 4) {
            this.spawnLootChest(ExtendedDirections.SOUTH, LootGames.ModConfig.GolConfig.GameStageIII);
            LootGameAchievement.GOL_MASTER_LEVEL3.triggerAchievement(pPlayer);
        }
        if (this.mMaxLevelReached >= 3) {
            this.spawnLootChest(ExtendedDirections.WEST, LootGames.ModConfig.GolConfig.GameStageII);
        }
        if (this.mMaxLevelReached >= 2) {
            this.spawnLootChest(ExtendedDirections.EAST, LootGames.ModConfig.GolConfig.GameStageI);
        }
        if (tLostGame) {
            this.sendFeedbackSound(eSoundType.SND_GAME_END_LOOSE);
            this.processGameLostEvent();
        } else {
            PlayerChatHelper.SendInfo((EntityPlayer)pPlayer, (String)"The Structure is pleased and rewards you!");
            PlayerChatHelper.SendPlain((EntityPlayer)pPlayer, (String)String.format("Current Level: %d, Best attempt: %d", this.mCurrentLevel, this.mMaxLevelReached - 1));
        }
        StructureGenerator.resetUnbreakablePlayfield(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void processGameLostEvent() {
        ArrayList<String> tFailEffect = new ArrayList<String>();
        if (LootGames.ModConfig.GolConfig.GameFail_Explode) {
            tFailEffect.add("explode");
        }
        if (LootGames.ModConfig.GolConfig.GameFail_Lava) {
            tFailEffect.add("lava");
        }
        if (LootGames.ModConfig.GolConfig.GameFail_Spawn) {
            tFailEffect.add("spawn");
        }
        if (tFailEffect.size() == 0) {
            return;
        }
        if (tFailEffect.size() == 1) {
            this.executeFailEvent((String)tFailEffect.get(0));
        } else {
            this.executeFailEvent((String)tFailEffect.get(LootGames.Rnd.nextInt(tFailEffect.size())));
        }
    }

    private void executeFailEvent(String pEffect) {
        block5: {
            block6: {
                block4: {
                    if (!pEffect.equalsIgnoreCase("explode")) break block4;
                    this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 5.0f, true);
                    break block5;
                }
                if (!pEffect.equalsIgnoreCase("lava")) break block6;
                for (int tx = -5; tx <= 5; ++tx) {
                    for (int tz = -5; tz <= 5; ++tz) {
                        for (int ty = 1; ty < 3; ++ty) {
                            this.field_145850_b.func_147449_b(this.field_145851_c + tx, this.field_145848_d + ty, this.field_145849_e + tz, Blocks.field_150353_l);
                        }
                    }
                }
                break block5;
            }
            if (!pEffect.equalsIgnoreCase("spawn")) break block5;
            for (int i = 0; i < 6; ++i) {
                EntityZombie zombie = new EntityZombie(this.field_145850_b);
                zombie.func_70012_b((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, MathHelper.func_76142_g((float)(LootGames.Rnd.nextFloat() * 360.0f)), 0.0f);
                zombie.field_70759_as = zombie.field_70177_z;
                zombie.field_70761_aq = zombie.field_70177_z;
                this.field_145850_b.func_72838_d((Entity)zombie);
                zombie.func_70642_aH();
            }
        }
    }

    private void spawnLootChest(ExtendedDirections pDirection, LootGamesConfig.LootStageConfig pLootStage) {
        int x = this.field_145851_c + pDirection.offsetX;
        int y = this.field_145848_d + pDirection.offsetY;
        int z = this.field_145849_e + pDirection.offsetZ;
        String tLootTable = pLootStage.GetLootTable(this.field_145850_b);
        WeightedRandomChestContent[] tRandomLoot = ChestGenHooks.getItems((String)tLootTable, (Random)LootGames.Rnd);
        this.field_145850_b.func_147449_b(x, y, z, (Block)Blocks.field_150486_ae);
        IInventory entityChestInventory = (IInventory)this.field_145850_b.func_147438_o(x, y, z);
        if (entityChestInventory != null && !this.field_145850_b.field_72995_K) {
            if (tRandomLoot.length == 0) {
                LootGames.mLog.error((Object)"Received LootTable is empty. Skipping Chest-Gen to avoid NPE Crash");
                ItemDescriptor tSorryItem = ItemDescriptor.fromString((String)"minecraft:stone");
                ItemStack tSorryStack = tSorryItem.getItemStackwNBT(1, String.format("{display:{Name:\"The Sorry-Stone\",Lore:[\"The Admin failed to configure the LootTables properly.\",\"Please report that LootList [%s] for GameStageID [%d] is broken, thank you!\"]}}", tLootTable, pLootStage.LevelID));
                entityChestInventory.func_70299_a(0, tSorryStack);
            } else {
                int tNumItems = LootGames.Rnd.nextInt(pLootStage.MaxItems) + pLootStage.MinItems;
                WeightedRandomChestContent.func_76293_a((Random)LootGames.Rnd, (WeightedRandomChestContent[])tRandomLoot, (IInventory)entityChestInventory, (int)tNumItems);
            }
        }
    }

    private void resetGame(EntityPlayer pPlayer, boolean pResetMaxLevel) {
        this.resetGame(pPlayer, 0, pResetMaxLevel);
    }

    private void resetGame(EntityPlayer pPlayer, int pForcedDelay, boolean pResetMaxLevel) {
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)"resetGame()");
        }
        if (pResetMaxLevel) {
            this.mMaxLevelReached = 1;
        }
        this.mCurrentPlayer = pPlayer.func_110124_au();
        this.mCurrentLevel = 1;
        this.mCurrentGameSequence = new ArrayList();
        this.mCurrentEnteredSequence = new ArrayList();
        for (int i = 0; i < LootGames.ModConfig.GolConfig.StartDigits; ++i) {
            this.mCurrentGameSequence.add(LootGames.Rnd.nextInt(4) + 2);
        }
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)String.format("Playback will start soon. Delay: %d", pForcedDelay));
        }
        this.mLastGameReplayTime = System.currentTimeMillis() + (long)pForcedDelay;
        this.mGameStage = eGameStage.PENDING_GAME_START;
        this.mLastPlayedDigitIndex = -1;
        this.sendFeedbackSound(eSoundType.SND_GAME_START);
    }

    private boolean checkOrDeployStructure() {
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)"checkOrDeployStructure()");
        }
        if (this.mGameStage != eGameStage.SLEEP && this.mGameStage != eGameStage.UNDEPLOYED) {
            return false;
        }
        boolean tSpawnCheck = true;
        if (!this.isValidLocationForDeploy(ExtendedDirections.NORTH)) {
            tSpawnCheck = false;
        }
        if (!this.isValidLocationForDeploy(ExtendedDirections.NORTHEAST)) {
            tSpawnCheck = false;
        }
        if (!this.isValidLocationForDeploy(ExtendedDirections.NORTHWEST)) {
            tSpawnCheck = false;
        }
        if (!this.isValidLocationForDeploy(ExtendedDirections.SOUTH)) {
            tSpawnCheck = false;
        }
        if (!this.isValidLocationForDeploy(ExtendedDirections.SOUTHEAST)) {
            tSpawnCheck = false;
        }
        if (!this.isValidLocationForDeploy(ExtendedDirections.SOUTHWEST)) {
            tSpawnCheck = false;
        }
        if (!this.isValidLocationForDeploy(ExtendedDirections.EAST)) {
            tSpawnCheck = false;
        }
        if (!this.isValidLocationForDeploy(ExtendedDirections.WEST)) {
            tSpawnCheck = false;
        }
        if (tSpawnCheck) {
            this.mNorthPos = this.setAndReturnGameBlock(ExtendedDirections.NORTH);
            this.mSouthPos = this.setAndReturnGameBlock(ExtendedDirections.SOUTH);
            this.mWestPos = this.setAndReturnGameBlock(ExtendedDirections.WEST);
            this.mEastPos = this.setAndReturnGameBlock(ExtendedDirections.EAST);
            this.mNorthEastPos = this.setAndReturnGameBlock(ExtendedDirections.NORTHEAST);
            this.mNorthWestPos = this.setAndReturnGameBlock(ExtendedDirections.NORTHWEST);
            this.mSouthEastPos = this.setAndReturnGameBlock(ExtendedDirections.SOUTHEAST);
            this.mSouthWestPos = this.setAndReturnGameBlock(ExtendedDirections.SOUTHWEST);
            if (LootGames.ModConfig.GolConfig.Debug) {
                LootGames.mLog.info((Object)"checkOrDeployStructure() > TRUE");
            }
            return true;
        }
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)"checkOrDeployStructure() > FALSE");
        }
        return false;
    }

    private boolean isValidLocationForDeploy(ExtendedDirections pDirection) {
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)"isValidLocationForDeploy()");
        }
        int x = this.field_145851_c + pDirection.offsetX;
        int y = this.field_145848_d + pDirection.offsetY;
        int z = this.field_145849_e + pDirection.offsetZ;
        boolean tRet = true;
        Block atPos = this.field_145850_b.func_147439_a(x, y, z);
        float atPosHardness = atPos.func_149712_f(this.field_145850_b, x, y, z);
        TileEntity atPosTE = this.field_145850_b.func_147438_o(x, y, z);
        if (atPosHardness == -1.0f && atPos != GameOfLightGame.GameBlock && atPos != LootGames.DungeonWallBlock) {
            tRet = false;
        }
        if (atPosTE != null && !(atPosTE instanceof TELightGameBlock)) {
            tRet = false;
        }
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)String.format("isValidLocationForDeploy() > %s", tRet));
        }
        return tRet;
    }

    private void initTileEntity(int pMasterX, int pMasterY, int pMasterZ, ExtendedDirections pDirection) {
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)String.format("initTileEntity direction: %s master: %d %d %d", pDirection.toString(), pMasterX, pMasterY, pMasterZ));
        }
        this.mTEDirection = pDirection;
        this.mIsActive = false;
        this.mIsMaster = false;
        this.mMasterPos = Vec3.func_72443_a((double)pMasterX, (double)pMasterY, (double)pMasterZ);
    }

    private Vec3 setAndReturnGameBlock(ExtendedDirections pDirection) {
        int x = this.field_145851_c + pDirection.offsetX;
        int y = this.field_145848_d + pDirection.offsetY;
        int z = this.field_145849_e + pDirection.offsetZ;
        this.field_145850_b.func_147449_b(x, y, z, (Block)GameOfLightGame.GameBlock);
        TileEntity tTE = this.field_145850_b.func_147438_o(x, y, z);
        if (tTE != null && tTE instanceof TELightGameBlock) {
            TELightGameBlock tOurTile = (TELightGameBlock)tTE;
            tOurTile.initTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, pDirection);
            return Vec3.func_72443_a((double)x, (double)y, (double)z);
        }
        return null;
    }

    private Vec3 readGameBlockFromNBT(NBTTagCompound pTag, String tTagName) {
        NBTTagCompound tSubTag = pTag.func_74775_l(tTagName);
        int x = tSubTag.func_74762_e(NBTTAG_BLOCKPOS_X);
        int y = tSubTag.func_74762_e(NBTTAG_BLOCKPOS_Y);
        int z = tSubTag.func_74762_e(NBTTAG_BLOCKPOS_Z);
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    private void addGameBlockToNBT(TELightGameBlock pTargetObject, NBTTagCompound pTag, String tTagName) {
        NBTTagCompound tSubTag = new NBTTagCompound();
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)String.format("[%s] Saving bound TE %s at %d %d %d", this.mTEDirection.toString(), tTagName, pTargetObject.field_145851_c, pTargetObject.field_145848_d, pTargetObject.field_145849_e));
        }
        tSubTag.func_74768_a(NBTTAG_BLOCKPOS_X, pTargetObject.field_145851_c);
        tSubTag.func_74768_a(NBTTAG_BLOCKPOS_Y, pTargetObject.field_145848_d);
        tSubTag.func_74768_a(NBTTAG_BLOCKPOS_Z, pTargetObject.field_145849_e);
        pTag.func_74782_a(tTagName, (NBTBase)tSubTag);
    }

    public void func_145839_a(NBTTagCompound pNBTTagCompound) {
        super.func_145839_a(pNBTTagCompound);
        this.mIsMaster = pNBTTagCompound.func_74767_n(NBTTAG_ISMASTER);
        this.mIsActive = pNBTTagCompound.func_74767_n(NBTTAG_ISACTIVE);
        this.mTEDirection = ExtendedDirections.VALID_DIRECTIONS[pNBTTagCompound.func_74762_e(NBTTAG_DIRECTION)];
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_NORTH)) {
            this.mNorthPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_NORTH);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_SOUTH)) {
            this.mSouthPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_SOUTH);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_WEST)) {
            this.mWestPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_WEST);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_EAST)) {
            this.mEastPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_EAST);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_NE)) {
            this.mNorthEastPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_NE);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_NW)) {
            this.mNorthWestPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_NW);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_SW)) {
            this.mSouthWestPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_SW);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_SE)) {
            this.mSouthEastPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_SE);
        }
        if (pNBTTagCompound.func_74764_b(NBTTAG_BLOCK_MASTER)) {
            this.mMasterPos = this.readGameBlockFromNBT(pNBTTagCompound, NBTTAG_BLOCK_MASTER);
        }
    }

    public void func_145841_b(NBTTagCompound pNBTTagCompound) {
        super.func_145841_b(pNBTTagCompound);
        pNBTTagCompound.func_74757_a(NBTTAG_ISMASTER, this.mIsMaster);
        pNBTTagCompound.func_74757_a(NBTTAG_ISACTIVE, this.mIsActive);
        pNBTTagCompound.func_74768_a(NBTTAG_DIRECTION, this.mTEDirection.ordinal());
        if (this.getBlockNorth() != null) {
            this.addGameBlockToNBT(this.getBlockNorth(), pNBTTagCompound, NBTTAG_BLOCK_NORTH);
        }
        if (this.getBlockSouth() != null) {
            this.addGameBlockToNBT(this.getBlockSouth(), pNBTTagCompound, NBTTAG_BLOCK_SOUTH);
        }
        if (this.getBlockWest() != null) {
            this.addGameBlockToNBT(this.getBlockWest(), pNBTTagCompound, NBTTAG_BLOCK_WEST);
        }
        if (this.getBlockEast() != null) {
            this.addGameBlockToNBT(this.getBlockEast(), pNBTTagCompound, NBTTAG_BLOCK_EAST);
        }
        if (this.getBlockNW() != null) {
            this.addGameBlockToNBT(this.getBlockNW(), pNBTTagCompound, NBTTAG_BLOCK_NW);
        }
        if (this.getBlockNE() != null) {
            this.addGameBlockToNBT(this.getBlockNE(), pNBTTagCompound, NBTTAG_BLOCK_NE);
        }
        if (this.getBlockSW() != null) {
            this.addGameBlockToNBT(this.getBlockSW(), pNBTTagCompound, NBTTAG_BLOCK_SW);
        }
        if (this.getBlockSE() != null) {
            this.addGameBlockToNBT(this.getBlockSE(), pNBTTagCompound, NBTTAG_BLOCK_SE);
        }
        if (this.getBlockMaster() != null) {
            this.addGameBlockToNBT(this.getBlockMaster(), pNBTTagCompound, NBTTAG_BLOCK_MASTER);
        }
    }

    private void setActiveState(boolean pActiveState) {
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)String.format("Setactive state %s for %s", pActiveState, this.mTEDirection.toString()));
        }
        this.mIsActive = pActiveState;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    private void toggleGameBlockActiveState(ExtendedDirections pDirectionTarget, boolean pActiveState) {
        this.toggleGameBlockActiveState(pDirectionTarget, pActiveState, true);
    }

    private void toggleGameBlockActiveState(ExtendedDirections pDirectionTarget, boolean pActiveState, boolean pAutoTimeout) {
        TELightGameBlock tTargetBlock = null;
        switch (pDirectionTarget) {
            case UP: {
                tTargetBlock = this._mMasterTE;
                break;
            }
            case NORTH: {
                tTargetBlock = this.getBlockNorth();
                break;
            }
            case SOUTH: {
                tTargetBlock = this.getBlockSouth();
                break;
            }
            case EAST: {
                tTargetBlock = this.getBlockEast();
                break;
            }
            case WEST: {
                tTargetBlock = this.getBlockWest();
                break;
            }
            case NORTHWEST: {
                tTargetBlock = this.getBlockNW();
                break;
            }
            case NORTHEAST: {
                tTargetBlock = this.getBlockNE();
                break;
            }
            case SOUTHWEST: {
                tTargetBlock = this.getBlockSW();
                break;
            }
            case SOUTHEAST: {
                tTargetBlock = this.getBlockSE();
            }
        }
        if (tTargetBlock != null) {
            if (pAutoTimeout && pActiveState) {
                this._mActiveBlocks.put(pDirectionTarget, System.currentTimeMillis());
            }
            tTargetBlock.setActiveState(pActiveState);
            if (pActiveState && pDirectionTarget != ExtendedDirections.UP) {
                this.sendFeedbackParticles(eFXType.FX_PLAYBACK, tTargetBlock.field_145851_c, tTargetBlock.field_145848_d, tTargetBlock.field_145849_e);
            }
        }
    }

    private float getPitchForNote(NoteBlockEvent.Note pNote, NoteBlockEvent.Octave pOctave) {
        int tNoteID = pNote.ordinal() + pOctave.ordinal() * 12;
        return (float)Math.pow(2.0, (double)(tNoteID - 12) / 12.0);
    }

    private void sendFeedbackSound(eSoundType pSound) {
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, String.format("%s:%s", pSound.getModName(), pSound.getSoundName()), 0.75f, 1.0f);
    }

    private void sendFeedbackSoundNote(ExtendedDirections pDirection) {
        NoteBlockEvent.Note tNote = NoteBlockEvent.Note.G_SHARP;
        NoteBlockEvent.Octave tOct = NoteBlockEvent.Octave.LOW;
        switch (pDirection) {
            case UP: 
            case UNKNOWN: 
            case DOWN: {
                break;
            }
            case NORTHWEST: {
                tNote = NoteBlockEvent.Note.G;
                break;
            }
            case NORTH: {
                tNote = NoteBlockEvent.Note.A;
                break;
            }
            case NORTHEAST: {
                tNote = NoteBlockEvent.Note.B;
                break;
            }
            case EAST: {
                tNote = NoteBlockEvent.Note.C;
                break;
            }
            case SOUTHEAST: {
                tNote = NoteBlockEvent.Note.D;
                break;
            }
            case SOUTH: {
                tNote = NoteBlockEvent.Note.E;
                break;
            }
            case SOUTHWEST: {
                tNote = NoteBlockEvent.Note.F;
                break;
            }
            case WEST: {
                tNote = NoteBlockEvent.Note.G;
                tOct = NoteBlockEvent.Octave.MID;
            }
        }
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "note.harp", 3.0f, this.getPitchForNote(tNote, tOct));
    }

    private void sendFeedbackParticles(eFXType pFX, TELightGameBlock pSourceBlock) {
        this.sendFeedbackParticles(pFX, pSourceBlock.field_145851_c, pSourceBlock.field_145848_d, pSourceBlock.field_145849_e);
    }

    private void sendFeedbackParticles(eFXType pFX, int pX, int pY, int pZ) {
        double motionX = 0.0;
        double motionY = 0.02;
        double motionZ = 0.0;
        double fxPosX = pX;
        double fxPosY = (double)pY + 0.5;
        double fxPosZ = pZ;
        if (LootGames.ModConfig.GolConfig.Debug) {
            LootGames.mLog.info((Object)String.format("FX at %.2f %.2f %.2f", fxPosX, fxPosY, fxPosZ));
        }
        NetworkRegistry.TargetPoint tp = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 100.0);
        LootGames.NW.sendToAllAround(new SpawnParticleFXMessage(pFX.getFXName(), fxPosX, fxPosY, fxPosZ, motionX, motionY, motionZ), tp);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.mIsMaster) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145837_r()) {
            return;
        }
        if (LootGames.Rnd.nextInt(5) > 0) {
            return;
        }
        HashMap<ExtendedDirections, Long> tNewHM = new HashMap<ExtendedDirections, Long>();
        if (!this._mActiveBlocks.isEmpty()) {
            for (Map.Entry<ExtendedDirections, Long> entry : this._mActiveBlocks.entrySet()) {
                if (entry.getValue() + 500L < System.currentTimeMillis()) {
                    this.toggleGameBlockActiveState(entry.getKey(), false);
                    continue;
                }
                tNewHM.put(entry.getKey(), entry.getValue());
            }
            this._mActiveBlocks = tNewHM;
        }
        LootGamesConfig.LootStageConfig lsc = this.getCurrentGameStage();
        if (this.mGameStage == eGameStage.ACTIVE_PLAY_SEQUENCE) {
            if (this.mLastGameReplayTime + (long)lsc.DisplayTime < System.currentTimeMillis()) {
                this.mLastGameReplayTime = System.currentTimeMillis();
                ++this.mLastPlayedDigitIndex;
                if (this.mLastPlayedDigitIndex < this.mCurrentGameSequence.size()) {
                    ExtendedDirections newBlock = ExtendedDirections.VALID_DIRECTIONS[this.mCurrentGameSequence.get(this.mLastPlayedDigitIndex)];
                    this.sendFeedbackSoundNote(newBlock);
                    this.toggleGameBlockActiveState(newBlock, true);
                } else {
                    if (LootGames.ModConfig.GolConfig.Debug) {
                        LootGames.mLog.info((Object)"Done replaying, waiting for player input");
                    }
                    this.mLastGameClickTime = System.currentTimeMillis();
                    this.mGameStage = eGameStage.ACTIVE_WAIT_FOR_PLAYER;
                    this.toggleGameBlockActiveState(ExtendedDirections.UP, true, false);
                }
            }
        } else if (this.mGameStage == eGameStage.ACTIVE_WAIT_FOR_PLAYER) {
            if (this.mLastGameClickTime + (long)(LootGames.ModConfig.GolConfig.Timeout * 1000) <= System.currentTimeMillis()) {
                if (LootGames.ModConfig.GolConfig.Debug) {
                    LootGames.mLog.info((Object)String.format("Switching gamestage to SLEEP, as no user input happend for %d seconds", LootGames.ModConfig.GolConfig.Timeout));
                }
                this.mGameStage = eGameStage.SLEEP;
            }
        } else if (this.mGameStage == eGameStage.PENDING_GAME_START && this.mLastGameReplayTime < System.currentTimeMillis()) {
            this.mGameStage = eGameStage.ACTIVE_PLAY_SEQUENCE;
            this.toggleGameBlockActiveState(ExtendedDirections.UP, false);
        }
    }

    private static enum eFXType {
        FX_PLAYBACK("spell"),
        FX_GAME_WIN("happyVillager");

        String _mFxName;

        public String getFXName() {
            return this._mFxName;
        }

        private eFXType(String pParticleEffectName) {
            this._mFxName = pParticleEffectName;
        }
    }

    private static enum eSoundType {
        SND_GAME_START("game_start"),
        SND_GAME_END_LOOSE("gameover_loose"),
        SND_GAME_END_WIN("gameover_win"),
        SND_GAME_PLAYBACK("block_ping"),
        SND_GAME_SEQUENCE_CORRECT("sequence_complete"),
        SND_GAME_SEQUENCE_WRONG("sequence_wrong"),
        SND_PLAYER_CLICK("player_click"),
        SND_LEVELUP("minecraft", "random.levelup");

        String _mSoundName;
        String _mModName;

        public String getSoundName() {
            return this._mSoundName;
        }

        public String getModName() {
            return this._mModName;
        }

        private eSoundType(String pModName, String pSoundName) {
            this._mSoundName = pSoundName;
            this._mModName = pModName;
        }

        private eSoundType(String pSoundName) {
            this("lootgames", pSoundName);
        }
    }

    public static enum eGameStage {
        UNDEPLOYED,
        SLEEP,
        ACTIVE_PLAY_SEQUENCE,
        ACTIVE_WAIT_FOR_PLAYER,
        PENDING_GAME_START,
        PLAYMUSIC;

    }
}

