/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.lootgames.auxiliary;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProfilingStorage {
    private Map<String, List<Long>> mProfilingMap = new HashMap<String, List<Long>>();

    public String[] getUniqueItems() {
        String[] tValues = null;
        this.mProfilingMap.keySet().toArray(tValues);
        return tValues;
    }

    public void AddTimeToList(String pIdentifier, long pTotalTime) {
        try {
            if (pTotalTime == 0L) {
                return;
            }
            if (!this.mProfilingMap.containsKey(pIdentifier)) {
                this.mProfilingMap.put(pIdentifier, new LinkedList());
            }
            LinkedList ll = (LinkedList)this.mProfilingMap.get(pIdentifier);
            ll.addLast(pTotalTime);
            while (ll.size() > 50) {
                ll.removeFirst();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long GetAverageTime(String pIdentifier) {
        try {
            if (!this.mProfilingMap.containsKey(pIdentifier)) {
                return -1L;
            }
            int tTotalVal = 0;
            long tAverage = 0L;
            long tReturnVal = 0L;
            LinkedList ll = (LinkedList)this.mProfilingMap.get(pIdentifier);
            if (ll != null) {
                Iterator qItr = ll.iterator();
                while (qItr.hasNext()) {
                    tAverage += ((Long)qItr.next()).longValue();
                    ++tTotalVal;
                }
                tReturnVal = (long)((float)(tAverage / (long)tTotalVal));
            }
            return tReturnVal;
        }
        catch (Exception e) {
            return -1L;
        }
    }
}

