/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.search;

import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.board.MoveGen;
import com.jamesswafford.chess4j.board.ZugzwangDetector;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.eval.Eval;
import com.jamesswafford.chess4j.hash.TranspositionTable;
import com.jamesswafford.chess4j.hash.TranspositionTableEntry;
import com.jamesswafford.chess4j.hash.TranspositionTableEntryType;
import com.jamesswafford.chess4j.search.Extend;
import com.jamesswafford.chess4j.search.KillerMoves;
import com.jamesswafford.chess4j.search.MVVLVA;
import com.jamesswafford.chess4j.search.MoveOrderer;
import com.jamesswafford.chess4j.search.SEE;
import com.jamesswafford.chess4j.search.SearchStats;
import com.jamesswafford.chess4j.utils.GameStatusChecker;
import eu.usrv.yamcore.auxiliary.LogHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Search {
    private static LogHelper mLog = new LogHelper("LootGames - ChessEngine");
    public static long startTime = 0L;
    public static long stopTime = 0L;
    public static long lastTimeCheck = 0L;
    public static boolean analysisMode = false;
    public static boolean abortSearch = false;

    private Search() {
    }

    public static int search(List<Move> parentPV, int alpha, int beta, Board board, int depth, SearchStats stats, boolean showThinking) {
        int numMovesSearched;
        assert (depth > 0);
        assert (beta > alpha);
        stats.incNodes();
        stats.getFirstLine().clear();
        List<Move> moves = MoveGen.genLegalMoves(board);
        TranspositionTableEntry te = TranspositionTable.getInstance().probe(board.getZobristKey());
        ArrayList<Move> pv = new ArrayList<Move>();
        int totalMoves = moves.size();
        Move pvMove = stats.getLastPV().size() > 0 ? stats.getLastPV().get(0) : null;
        Move hashMove = te == null ? null : te.getMove();
        MoveOrderer mo = new MoveOrderer(board, moves, pvMove, hashMove, null, null);
        for (numMovesSearched = 0; numMovesSearched < totalMoves; ++numMovesSearched) {
            Move move = mo.selectNextMove(numMovesSearched);
            Search.recordFirstLine(true, numMovesSearched, stats, move);
            board.applyMove(move);
            boolean givesCheck = board.isPlayerInCheck();
            int extend = Extend.extendDepth(board, move, givesCheck);
            assert (extend >= 0 && extend <= 1);
            int score = numMovesSearched == 0 ? -Search.searchHelper(pv, -beta, -alpha, board, depth - 1 + extend, 1, true, givesCheck, false, stats) : -Search.searchHelper(pv, -beta, -alpha, board, depth - 1 + extend, 1, false, givesCheck, extend == 0, stats);
            board.undoLastMove();
            if (depth <= 1 || !abortSearch) continue;
            return 0;
        }
        alpha = Search.adjustFinalScoreForMates(board, alpha, numMovesSearched, 0);
        return alpha;
    }

    private static void setParentPV(List<Move> parentPV, Move head, List<Move> tail) {
        parentPV.clear();
        parentPV.add(head);
        parentPV.addAll(tail);
    }

    private static int searchHelper(List<Move> parentPV, int alpha, int beta, Board board, int depth, int ply, boolean pvNode, boolean inCheck, boolean isNullMoveOK, SearchStats stats) {
        assert (ply > 0);
        assert (alpha < beta);
        assert (inCheck == board.isPlayerInCheck());
        int origAlpha = alpha;
        parentPV.clear();
        stats.incNodes();
        if (depth < 1) {
            assert (!inCheck);
            return Search.quiescenceSearch(alpha, beta, inCheck, board, stats);
        }
        if (!analysisMode && lastTimeCheck > 10000L) {
            if (System.currentTimeMillis() > stopTime) {
                abortSearch = true;
                mLog.debug((Object)("# Aborting search depth=" + depth + ", ply=" + ply + " on time..."));
                return 0;
            }
            lastTimeCheck = 0L;
        } else {
            ++lastTimeCheck;
        }
        if (GameStatusChecker.isDrawByRep(board) || board.getFiftyCounter() >= 100) {
            return 0;
        }
        TranspositionTableEntry te = TranspositionTable.getInstance().probe(board.getZobristKey());
        if (te != null && te.getDepth() >= depth) {
            if (te.getType() == TranspositionTableEntryType.LOWER_BOUND) {
                if (te.getScore() >= beta) {
                    stats.incFailHighs();
                    return beta;
                }
            } else if (te.getType() == TranspositionTableEntryType.UPPER_BOUND) {
                if (te.getScore() <= alpha) {
                    stats.incFailLows();
                    return alpha;
                }
            } else if (te.getType() == TranspositionTableEntryType.EXACT_MATCH) {
                stats.incHashExactScores();
                return te.getScore();
            }
        }
        if (!pvNode && !inCheck && isNullMoveOK && depth >= 3 && beta < 50000 && !ZugzwangDetector.isZugzwang(board)) {
            Square nullEP = board.clearEPSquare();
            board.swapPlayer();
            int nullDepth = depth - 4;
            if (nullDepth < 1) {
                nullDepth = 1;
            }
            int nullScore = -Search.searchHelper(parentPV, 0 - beta, 1 - beta, board, nullDepth, ply, false, false, false, stats);
            board.swapPlayer();
            if (nullEP != null) {
                board.setEP(nullEP);
            }
            if (abortSearch) {
                return 0;
            }
            if (nullScore >= beta) {
                return beta;
            }
        }
        List<Move> moves = MoveGen.genPseudoLegalMoves(board);
        ArrayList<Move> pv = new ArrayList<Move>(50);
        int numMovesApplied = 0;
        int numMovesSearched = 0;
        int totalMoves = moves.size();
        Move pvMove = pvNode && stats.getLastPV().size() > ply ? stats.getLastPV().get(ply) : null;
        Move hashMove = te == null ? null : te.getMove();
        MoveOrderer mo = new MoveOrderer(board, moves, pvMove, hashMove, KillerMoves.getInstance().getKiller1(ply), KillerMoves.getInstance().getKiller2(ply));
        Move bestMove = null;
        while (numMovesApplied < totalMoves) {
            int score;
            Move move = mo.selectNextMove(numMovesApplied);
            Search.recordFirstLine(pvNode, numMovesSearched, stats, move);
            board.applyMove(move);
            ++numMovesApplied;
            if (board.isOpponentInCheck()) {
                board.undoLastMove();
                continue;
            }
            boolean givesCheck = board.isPlayerInCheck();
            int extend = Extend.extendDepth(board, move, givesCheck);
            assert (extend >= 0 && extend <= 1);
            if (numMovesSearched == 0) {
                score = -Search.searchHelper(pv, -beta, -alpha, board, depth - 1 + extend, ply + 1, pvNode, givesCheck, !pvNode, stats);
            } else {
                score = numMovesSearched >= 4 && depth >= 3 && !pvNode && !inCheck && !givesCheck && extend == 0 && move.captured() == null && move.promotion() == null && !move.equals(KillerMoves.getInstance().getKiller1(ply)) && !move.equals(KillerMoves.getInstance().getKiller2(ply)) ? -Search.searchHelper(pv, -(alpha + 1), -alpha, board, depth - 2, ply + 1, false, false, true, stats) : alpha + 1;
                if (score > alpha) {
                    score = -Search.searchHelper(pv, -beta, -alpha, board, depth - 1 + extend, ply + 1, false, givesCheck, extend == 0, stats);
                }
            }
            ++numMovesSearched;
            board.undoLastMove();
            if (abortSearch) {
                return 0;
            }
            if (score <= alpha) continue;
            if (score >= beta) {
                TranspositionTable.getInstance().store(TranspositionTableEntryType.LOWER_BOUND, board.getZobristKey(), beta, depth, move);
                if (move.captured() == null && move.promotion() == null) {
                    KillerMoves.getInstance().addKiller(ply, move);
                }
                return beta;
            }
            alpha = score;
            bestMove = move;
            Search.setParentPV(parentPV, move, pv);
        }
        assert (numMovesSearched == MoveGen.genLegalMoves(board).size());
        assert (alpha >= origAlpha);
        alpha = Search.adjustFinalScoreForMates(board, alpha, numMovesSearched, ply);
        TranspositionTableEntryType tet = bestMove == null ? TranspositionTableEntryType.UPPER_BOUND : TranspositionTableEntryType.EXACT_MATCH;
        TranspositionTable.getInstance().store(tet, board.getZobristKey(), alpha, depth, bestMove);
        return alpha;
    }

    public static int quiescenceSearch(int alpha, int beta, boolean inCheck, Board board, SearchStats stats) {
        assert (alpha < beta);
        if (!analysisMode && lastTimeCheck > 10000L) {
            if (System.currentTimeMillis() > stopTime) {
                mLog.debug((Object)"# Aborting qsearch on time...");
                abortSearch = true;
                return 0;
            }
            lastTimeCheck = 0L;
        } else {
            ++lastTimeCheck;
        }
        int standPat = Eval.eval(board);
        if (standPat > alpha) {
            if (standPat >= beta) {
                return beta;
            }
            alpha = standPat;
        }
        List<Move> moves = MoveGen.genPseudoLegalMoves(board, true);
        Collections.sort(moves, new MVVLVA(board));
        for (Move mv : moves) {
            assert (mv.captured() != null || mv.promotion() != null);
            board.applyMove(mv);
            if (board.isOpponentInCheck()) {
                board.undoLastMove();
                continue;
            }
            if (!inCheck && mv.promotion() == null && Eval.getPieceValue(board.getPiece(mv.to())) > Eval.getPieceValue(mv.captured()) && SEE.see(board, mv) < 0) {
                board.undoLastMove();
                continue;
            }
            boolean givesCheck = false;
            stats.incQNodes();
            int score = -Search.quiescenceSearch(-beta, -alpha, givesCheck, board, stats);
            board.undoLastMove();
            if (abortSearch) {
                return 0;
            }
            if (score <= alpha) continue;
            if (score >= beta) {
                return beta;
            }
            alpha = score;
        }
        return alpha;
    }

    private static void recordFirstLine(boolean isPVNode, int numMovesSearched, SearchStats stats, Move move) {
        if (isPVNode && numMovesSearched == 0) {
            stats.getFirstLine().add(move);
        }
    }

    private static int adjustFinalScoreForMates(Board board, int score, int numMovesSearched, int ply) {
        int adjScore = score;
        if (numMovesSearched == 0) {
            adjScore = board.isPlayerInCheck() ? -(30000 - ply) : 0;
        }
        return adjScore;
    }
}

